#ifdef PRECOMPILEDHEADERS
#include "Tactical All.h"
#else
#include "builddefines.h"
#include <stdio.h>
#include <string.h>
#include "stdlib.h"
#include "debug.h"
#include "Animation Control.h"
#include "Animation Data.h"
#include "FileMan.h"
#include "weapons.h"
#include "message.h"
#include "structure.h"
#include "worlddef.h"
#include "worldman.h"
#include "rotting corpses.h"
#include "Debug Control.h"
#include "Random.h"
#include "Soldier Control.h"
#endif

#include "connect.h"

// Defines for Anim inst reading, taken from orig Jagged
#define	ANIMFILENAME					"BINARYDATA\\ja2bin.dat"

#define EMPTY_INDEX						999


#define	NUM_INJURED_SUBS							1

typedef struct
{
	UINT16	usAnimState;
	UINT16	usAnimationSurfaces[ 4 ];

} ANIMSUBTYPE;


//<SB> crouch throwing
static UINT16 CrouchedThrowAnimationScript[MAX_FRAMES_PER_ANIM] = { 1,2,3,4,5,6,7,8,9,460,10,11,12,13,14,442,603,999,0,0,0,0 };
//</SB>

///ddd
static UINT16 StoneAnimationScript[MAX_FRAMES_PER_ANIM] = { 1,2,3,4,5,6,7,8,402,1,2,3,4,5,6,7,8,402,1,2,3,4,5,6,7,8,601,999,0,0,0,0,0 };

static UINT16 CrouchedShootRocketScript[MAX_FRAMES_PER_ANIM] = 
{757,1,2,3,4,5,6,7,8,9,10,11,12,470,430,13,14,15,16,477,17,18,19,20,753,499,999,0,0,0,0};
static UINT16 SwatWithKnifeScript[MAX_FRAMES_PER_ANIM] = 
//{1,2,3,4,5,6,7,703,8,9,10,11,704,12,13,14,15,16,17,18,19,501,999,0,0,0,0};
{5,703,6,7,8,9,10,11,704,12,13,14,15,16,501,999,0,0,0,0};//such a sequence is available in dzha2bin
static UINT16 SwatBackWithKnifeScript[MAX_FRAMES_PER_ANIM] = 
{16,15,14,13,12,704,11,10,9,8,7,6,703,5,501,999,0,0,0,0}; 

static UINT16 SwatBackWithNothingScript[MAX_FRAMES_PER_ANIM] = 
{16,15,14,13,12,704,11,10,9,8,7,6,703,5,501,999,0,0,0,0};

//xs, may need to edit the numbers. throwing grenades script
static UINT16 ThrowGrenadeStanceAnimationScript[MAX_FRAMES_PER_ANIM] = { 1,2,3,4,5,6,7,8,9,10,460,11,12,13,14,15,16,17,18,19,442,601,999,0,0,0,0  };
static UINT16 LobGrenadeStanceAnimationScript[MAX_FRAMES_PER_ANIM] = { 1,2,3,4,5,6,7,8,9,10,460,11,12,13,14,15,16,17,18,19,442,601,999,0,0,0,0  };
//Rolls
static UINT16 ROLL_L_AnimationScript[MAX_FRAMES_PER_ANIM] = { 1,2,3,4,5,6,7,8,9,10,11,12,13,14,501,999,0,0,0,0  };
static UINT16 ROLL_R_AnimationScript[MAX_FRAMES_PER_ANIM] = { 14,13,12,11,10,9,8,7,6,5,4,3,2,1,501,999,0,0,0,0  };

static UINT16 JUMP_WALL_UP_AnimationScript[MAX_FRAMES_PER_ANIM] = { 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,601,999,0,0,0,0  };
static UINT16 JUMP_WALL_DOWN_AnimationScript[MAX_FRAMES_PER_ANIM] = { 44,43,42,41,40,39,38,37,36,35,34,33,32,31,30,29,28,27,26,25,24,23,22,21,20,19,18,17,16,15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,601,999,0,0,0,0  };

static UINT16 REMOTE_DET_AnimationScript[MAX_FRAMES_PER_ANIM] = { 1,2,3,4,484,4,5,6,1,442,499,999,0,0,0,0  }; // SANDRO - new animation of remote detonator by PasHancock

static UINT16 THROW_KNIFE_SP_BM_AnimationScript[MAX_FRAMES_PER_ANIM] = { 757,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,12,13,709,14,15,16,430,16,17,17,18,19,20,21,753,442,499,999,0,0,0,0  };

static UINT16 PRONE_START_FIRST_AID_AnimationScript[MAX_FRAMES_PER_ANIM] = { 1,2,3,4,442,1033,0,0,0,0  };
static UINT16 PRONE_GIVE_FIRST_AID_AnimationScript[MAX_FRAMES_PER_ANIM] = { 4,5,6,7,6,5,4,3,4,5,6,6,5,7,6,5,4,3,4,5,5,6,7,6,7,6,5,7,6,5,4,3,2,3,2,4,501,0,0,0,0  };

static UINT16 DUAL_BURST_ST_CR_AnimationScript[MAX_FRAMES_PER_ANIM] = { 757,459,441,448,430,17,477,458,441,448,430,21,19,24,477,1101,449,753,473,1102,999,0,0,0,0  };
static UINT16 DUAL_BURST_PRONE_AnimationScript[MAX_FRAMES_PER_ANIM] = { 757,4,459,441,448,430,5,477,458,441,448,430,9,7,11,477,1101,449,753,473,1102,999,0,0,0,0  };

//static UINT16 SHOOT_ALTERNATIVE_STAND_LOW_AnimationScript[MAX_FRAMES_PER_ANIM] = { 757,3,4,470,441,430,5,6,477,7,8,4,3,753,473,612,999,0,0,0,0  };
//static UINT16 BURST_ALTERNATIVE_STAND_LOW_AnimationScript[MAX_FRAMES_PER_ANIM] = { 757,3,4,441,448,430,5,4,477,441,448,430,5,4,477,441,448,430,5,4,477,441,448,430,5,4,477,441,448,430,5,4,477,441,448,430,5,6,7,477,8,4,3,449,753,473,612,999,0,0,0,0  };

static UINT16 START_COWER_CROUCHED_AnimationScript[MAX_FRAMES_PER_ANIM] = { 4,5,442,922,999,0,0,0,0  };
static UINT16 END_COWER_CROUCHED_AnimationScript[MAX_FRAMES_PER_ANIM] = { 5,4,442,499,999,0,0,0,0  };
static UINT16 START_COWER_PRONE_AnimationScript[MAX_FRAMES_PER_ANIM] = { 1,2,3,4,442,1052,999,0,0,0,0  };
static UINT16 COWER_PRONE_AnimationScript[MAX_FRAMES_PER_ANIM] = { 5,6,7,8,9,10,9,8,5,4,5,6,501,999,0,0,0,0  };
static UINT16 END_COWER_PRONE_AnimationScript[MAX_FRAMES_PER_ANIM] = { 4,3,2,1,442,499,999,0,0,0,0  };

static UINT16 F_IDLE_ANIM_KICKSN_AnimationScript[MAX_FRAMES_PER_ANIM] = { 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,601,0,0,0,0  };
static UINT16 F_IDLE_ANIM_LOOK_AnimationScript[MAX_FRAMES_PER_ANIM] = { 1,2,3,4,5,6,7,8,9,10,11,12,13,14,13,12,11,10,9,8,7,6,5,4,3,2,1,601,0,0,0,0  };
static UINT16 NINJA_SPINKICK_AnimationScript[MAX_FRAMES_PER_ANIM] = { 757,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,727,492,32,33,34,430,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,753,442,468,999,0,0,0,0  };

static UINT16 FOCUSED_PUNCH_AnimationScript[MAX_FRAMES_PER_ANIM] = { 757,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,12,12,12,12,12,12,12,13,13,14,14,727,492,15,16,17,430,18,19,19,19,19,20,20,20,20,21,21,21,22,22,22,23,23,23,24,24,24,753,442,468,999,0,0,0,0  };
static UINT16 FOCUSED_STAB_AnimationScript[MAX_FRAMES_PER_ANIM] = { 757,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,5,5,5,6,6,7,727,492,8,9,430,10,10,10,10,11,11,11,11,12,12,12,13,13,13,14,14,14,442,912,499,0,0,0,0  };
static UINT16 HTH_KICK_AnimationScript[MAX_FRAMES_PER_ANIM] = { 757,1,2,3,4,5,6,7,727,492,8,9,10,430,11,11,12,13,14,15,16,17,18,19,442,468,999,0,0,0,0  };
static UINT16 FOCUSED_HTH_KICK_AnimationScript[MAX_FRAMES_PER_ANIM] = { 757,1,1,1,2,2,2,3,3,3,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,7,7,7,7,727,492,8,8,9,10,430,10,10,11,11,11,11,12,12,12,13,13,13,14,14,14,15,15,16,16,17,17,18,18,19,19,442,468,999,0,0,0,0  };

//static UINT16 LONG_JUMP_AnimationScript[MAX_FRAMES_PER_ANIM] = { 1,2,3,703,4,5,6,6,7,8,9,10,11,704,12,13,14,501,999,0,0,0,0  };
static UINT16 LONG_JUMP_AnimationScript[MAX_FRAMES_PER_ANIM] = { 2,703,3,4,5,6,6,7,7,8,704,9,501,999,0,0,0,0  };

ANI_SPEED_DEF gubAnimCrawlSpeeds[ TOTALBODYTYPES ];
//Block for anim file
UINT16	gusAnimInst[ MAX_ANIMATIONS ][ MAX_FRAMES_PER_ANIM ];

// OK, this array contains definitions for random animations based on bodytype, total # allowed, and what is in their hand....
RANDOM_ANI_DEF	gRandomAnimDefs[ TOTALBODYTYPES ][ MAX_RANDOM_ANIMS_PER_BODYTYPE ];


ANIMCONTROLTYPE		gAnimControl[ NUMANIMATIONSTATES ] =
{
	//NAME								//AP		//SPEED	// MOVE	// FLAGS						// HEIGHT

	//WALKING
	{"WALKING"							, 20,			0, (FLOAT)1.6, ANIM_MOVING | ANIM_TURNING	| ANIM_NORESTART | ANIM_RAISE_WEAPON | ANIM_VARIABLE_EFFORT,			ANIM_STAND,	ANIM_STAND, -1},

	//Breathing
	{"STANDING"						, 0,			0,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_RAISE_WEAPON | ANIM_VARIABLE_EFFORT	| ANIM_BREATH,		ANIM_STAND,	ANIM_STAND, -1},

	//KNEEL DOWN
	{"KNEEL DOWN"					, 0,		90,		(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING	| ANIM_NOMOVE_MARKER | ANIM_STANCECHANGEANIM	| ANIM_NOCHANGE_WEAPON | ANIM_MIN_EFFORT,	ANIM_STAND, ANIM_CROUCH, -1},

	//CROUCHING
	{"CROUCHED"						,	0,			0,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_RAISE_WEAPON | ANIM_NO_EFFORT	| ANIM_BREATH,		ANIM_CROUCH, ANIM_CROUCH, -1},

	//KNEEL UP
	{"KNEEL UP"						,	0,		90,			(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING	| ANIM_NOMOVE_MARKER | ANIM_STANCECHANGEANIM	| ANIM_NOCHANGE_WEAPON | ANIM_MIN_EFFORT,	ANIM_CROUCH, ANIM_STAND, -1},

	//SWAT
	{"SWAT"								,	0,		0,			(FLOAT)2.2, ANIM_MOVING | ANIM_TURNING	| ANIM_NORESTART	| ANIM_RAISE_WEAPON | ANIM_LIGHT_EFFORT,	ANIM_CROUCH, ANIM_CROUCH, -1},

	//RUN
	{"RUN"									, 0,		0,			(FLOAT)2.6, ANIM_MOVING | ANIM_TURNING	| ANIM_NORESTART | ANIM_RAISE_WEAPON | ANIM_MODERATE_EFFORT,	ANIM_STAND, ANIM_STAND, -1},

	//PRONE DOWN
	{"PRONE DOWN"					, 0,		100,	 (FLOAT)0,	ANIM_STATIONARY	| ANIM_NOMOVE_MARKER | ANIM_STANCECHANGEANIM | ANIM_NOCHANGE_WEAPON | ANIM_MIN_EFFORT,		ANIM_CROUCH, ANIM_PRONE, -1},

	//CRAWL
	{"CRAWL"								, 0,		0,	 (FLOAT).8,	ANIM_MOVING | ANIM_TURNING	| ANIM_NORESTART | ANIM_RAISE_WEAPON | ANIM_MODERATE_EFFORT,	ANIM_PRONE, ANIM_PRONE, -1},

	//PRONE UP
	{"PRONE UP"						, 0,		100,	 (FLOAT)0,		ANIM_STATIONARY	| ANIM_NOMOVE_MARKER | ANIM_STANCECHANGEANIM | ANIM_NOCHANGE_WEAPON | ANIM_MIN_EFFORT,		ANIM_PRONE, ANIM_CROUCH, -1},

	//PRONE BREATHING
	{"PRONE"								, 0,		0,	 (FLOAT)0,	ANIM_STATIONARY | ANIM_FASTTURN | ANIM_RAISE_WEAPON | ANIM_NO_EFFORT	| ANIM_BREATH,			ANIM_PRONE, ANIM_PRONE, -1},

	// READY_RIFLE_STAND
	{"READY AIM (R) STAND"	, 0,			0,	(FLOAT)0,	ANIM_OK_CHARGE_AP_FOR_TURN | ANIM_NORESTART | ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_RAISE_WEAPON | ANIM_MIN_EFFORT ,										ANIM_STAND,	ANIM_STAND, -1},

	// AIM_RIFLE_STAND
	{"AIM (R) STAND"				, 0,			250,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_FIREREADY | ANIM_FASTTURN | ANIM_RAISE_WEAPON | ANIM_LIGHT_EFFORT,	ANIM_STAND, ANIM_STAND,	-1},

	// SHOOT_RIFLE_STAND
	{"SHOOT (R) STAND"			, 0,			100,	(FLOAT)0,	ANIM_NORESTART | ANIM_STATIONARY | ANIM_TURNING | ANIM_RAISE_WEAPON | ANIM_LIGHT_EFFORT | ANIM_FIRE | ANIM_RT_NONINTERRUPT | ANIM_ATTACK,										ANIM_STAND,	ANIM_STAND, -1},

	// END_RIFLE_STAND
	{"END RIFLE STAND"			, 0,			80,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_RAISE_WEAPON | ANIM_NOCHANGE_PENDINGCOUNT | ANIM_MIN_EFFORT,										ANIM_STAND, ANIM_STAND,	-1},

	// FROM CROUCH TO SWAT
	{"CROUCH TO SWAT"			, 0,			40,	(FLOAT)1.3,	ANIM_MOVING | ANIM_TURNING | ANIM_LIGHT_EFFORT,											ANIM_CROUCH, ANIM_CROUCH,	-1},

	// FROM SWAT TO CROUCH
	{"SWAT TO CROUCH"			, 0,			40,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_LIGHT_EFFORT,										ANIM_CROUCH, ANIM_CROUCH,	-1},

	// FLYBACK HIT ANIMATION
	{"FLYBACK HIT"					, 0,			80,	(FLOAT)1.6,	ANIM_SPECIALMOVE | ANIM_HITSTART | ANIM_HITFINISH | ANIM_NONINTERRUPT | ANIM_NOSHOW_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_IGNORE_AUTOSTANCE | ANIM_ATTACK,	ANIM_STAND, ANIM_PRONE,	-1},

	// READY_RIFLE_PRONE
	{"READY (R) PRONE"			, 0,			150,	(FLOAT)0,	ANIM_OK_CHARGE_AP_FOR_TURN | ANIM_NORESTART | ANIM_STATIONARY | ANIM_TURNING| ANIM_RAISE_WEAPON | ANIM_MIN_EFFORT,										ANIM_PRONE, ANIM_PRONE,	-1},

	// AIM_RIFLE_PRONE
	{"AIM (R) PRONE"				, 0,			250,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_FIREREADY | ANIM_FASTTURN| ANIM_RAISE_WEAPON | ANIM_LIGHT_EFFORT,	ANIM_PRONE, ANIM_PRONE,	-1},

	// SHOOT_RIFLE_PRONE
	{"SHOOT (R) PRONE"			, 0,			100,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_RAISE_WEAPON | ANIM_LIGHT_EFFORT | ANIM_FIRE | ANIM_RT_NONINTERRUPT | ANIM_ATTACK,										ANIM_PRONE, ANIM_PRONE,	-1},

	// END_RIFLE_PRONE
	{"END (R) AIM PRONE"		, 0,			150,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_RAISE_WEAPON | ANIM_NOCHANGE_PENDINGCOUNT | ANIM_MIN_EFFORT,										ANIM_PRONE, ANIM_PRONE,	-1},

	// DEATH TWITCH ONE
	{"DEATH TWITCH ONE"		, 0,			100,	(FLOAT)0,	ANIM_STATIONARY | ANIM_NOSHOW_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,																		ANIM_PRONE, ANIM_PRONE,	-1},

	// GENERIC_HIT STANDING
	{"GENERIC HIT STAND"		, 0,			130,	(FLOAT)0,	ANIM_STATIONARY | ANIM_HITSTART | ANIM_TURNING | ANIM_NONINTERRUPT | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_IGNORE_AUTOSTANCE | ANIM_ATTACK,										ANIM_STAND, ANIM_STAND,	-1},

	// FLYBACK HIT ANIMATION W/ BLOOD
	{"FLYBACK HIT w/B"			, 0,			80,	(FLOAT)1.6,	ANIM_SPECIALMOVE | ANIM_HITSTART | ANIM_HITFINISH | ANIM_NONINTERRUPT | ANIM_NOSHOW_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_IGNORE_AUTOSTANCE | ANIM_ATTACK,	ANIM_PRONE, 	ANIM_PRONE,	-1},

	// FLYBACK HIT DEATH
	{"FLYBACK HIT DEATH"		, 0,			120,	(FLOAT)0,		ANIM_STATIONARY | ANIM_NONINTERRUPT | ANIM_NOSHOW_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,							ANIM_PRONE, ANIM_PRONE,	-1},

	// READY_RIFLE_CROUCH
	{"READY (R) CROUCH"		, 0,			150,	(FLOAT)0,	ANIM_OK_CHARGE_AP_FOR_TURN | ANIM_NORESTART | ANIM_STATIONARY | ANIM_TURNING | ANIM_RAISE_WEAPON | ANIM_MIN_EFFORT,										ANIM_CROUCH, ANIM_CROUCH,	-1},

	// AIM_RIFLE_CROUCH
	{"AIM (R) CROUCH"			, 0,			250,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_FIREREADY | ANIM_FASTTURN | ANIM_RAISE_WEAPON | ANIM_LIGHT_EFFORT,	ANIM_CROUCH, ANIM_CROUCH,	-1},

	// SHOOT_RIFLE_CROUCH
	{"SHOOT (R) CROUCH"		, 0,			100,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_RAISE_WEAPON | ANIM_LIGHT_EFFORT | ANIM_FIRE | ANIM_RT_NONINTERRUPT | ANIM_ATTACK,										ANIM_CROUCH, ANIM_CROUCH, -1},

	// END_RIFLE_CROUCH
	{"END (R) CROUCH"			, 0,			150,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_RAISE_WEAPON | ANIM_NOCHANGE_PENDINGCOUNT | ANIM_MIN_EFFORT,										ANIM_CROUCH, ANIM_CROUCH,	-1},

	// FALLBACK HIT STANDING
	{"FALLBACK HIT STAND"	, 0,			130,	(FLOAT)1.6,	ANIM_SPECIALMOVE | ANIM_NONINTERRUPT | ANIM_HITFINISH | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_IGNORE_AUTOSTANCE | ANIM_ATTACK,										ANIM_STAND, ANIM_PRONE,	-1},

	// ROLLOVER
	{"ROOLOVER"						, 0,			100,	(FLOAT)0,		ANIM_STATIONARY | ANIM_TURNING | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,													ANIM_PRONE, ANIM_PRONE,	-1},

	// CLIMBROOF
	{"CLIMBROOF"						, 0,			30,	(FLOAT)0,		ANIM_NONINTERRUPT | ANIM_NORESTART | ANIM_STATIONARY | ANIM_NOSHOW_MARKER | ANIM_MODERATE_EFFORT | ANIM_LOWER_WEAPON,																	ANIM_STAND, ANIM_CROUCH,	-1},

	// FALL
	{"FALL"								, 0,			60,	(FLOAT)0,		ANIM_NONINTERRUPT | ANIM_STATIONARY | ANIM_HITFINISH | ANIM_NOSHOW_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_IGNORE_AUTOSTANCE | ANIM_ATTACK,														ANIM_STAND, ANIM_PRONE,	-1},

	//GETUP FROM ROLLOVER
	{"GETUP FROM ROLLOVER"	, 0,		100,	 (FLOAT)0,		ANIM_STATIONARY | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,							ANIM_PRONE, ANIM_STAND,	-1},

	//CLIMBDOWNROOF
	{"CLIMBDOWNROOF"				, 0,		30,	 (FLOAT)0,		ANIM_NONINTERRUPT | ANIM_NORESTART | ANIM_STATIONARY | ANIM_NOSHOW_MARKER | ANIM_MODERATE_EFFORT | ANIM_LOWER_WEAPON,																	ANIM_CROUCH,	ANIM_STAND,	-1},

	// FALL FORWARD
	{"FALL FORWARD ROOF"		, 0,			60,	(FLOAT)0,		ANIM_NONINTERRUPT | ANIM_STATIONARY | ANIM_HITFINISH | ANIM_NOSHOW_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_IGNORE_AUTOSTANCE | ANIM_ATTACK,														ANIM_STAND,	ANIM_PRONE,	-1},

	// GENERIC HIT DEATHTWICH NO BLOOD
	{"BELLY DEATHHIT NB"		, 0,			100,	(FLOAT)0,		ANIM_STATIONARY | ANIM_HITWHENDOWN | ANIM_NONINTERRUPT | ANIM_NOSHOW_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,						ANIM_PRONE,	ANIM_PRONE,	-1},

	// GENERIC HIT DEATHTWICH BLOOD
	{"BELLY DEATHHIT B"		, 0,			100,	(FLOAT)0,		ANIM_STATIONARY | ANIM_HITWHENDOWN | ANIM_NONINTERRUPT | ANIM_NOSHOW_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,						ANIM_PRONE,	ANIM_PRONE,	-1},

	// FALLBACK HIT DEATHTWICH NO BLOOD
	{"FALLBACK DEATHHIT NB", 0,			100,	(FLOAT)0,		ANIM_STATIONARY | ANIM_HITWHENDOWN | ANIM_NONINTERRUPT | ANIM_NOSHOW_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,						ANIM_PRONE,	ANIM_PRONE,	-1},

	// FALLBACK HIT DEATHTWICH BLOOD
	{"FALLBACK DEATHHIT B"	, 0,			100,	(FLOAT)0,		ANIM_STATIONARY | ANIM_HITWHENDOWN | ANIM_NONINTERRUPT | ANIM_NOSHOW_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,						ANIM_PRONE,	ANIM_PRONE,	-1},

	// GENERIC HIT DEATH
	{"BELLY HIT DEATH"			, 0,			120,	(FLOAT)0,		ANIM_STATIONARY | ANIM_NONINTERRUPT | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,																		ANIM_PRONE, ANIM_PRONE,	-1},

	// FALLBACK HIT DEATH
	{"FALLBACK HIT DEATH"	, 0,			120,	(FLOAT)0,		ANIM_STATIONARY | ANIM_NONINTERRUPT | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,											ANIM_PRONE, ANIM_PRONE,	-1},

	// GENERIC HIT CROUCHED
	{"GENERIC HIT CROUCH"	, 0,			80,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_HITSTART | ANIM_NONINTERRUPT | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,														ANIM_CROUCH, ANIM_CROUCH,	-1},

	// STAND BURST // Lesh: AniDelay, speed=0 for control it
	{"STAND BURST SHOOT"		, 0,			0,	(FLOAT)0,	ANIM_NORESTART | ANIM_STATIONARY | ANIM_TURNING | ANIM_RAISE_WEAPON | ANIM_LIGHT_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_FIRE | ANIM_ATTACK,														ANIM_STAND, ANIM_STAND,	-1},

	// STANDING BURST HIT
	{"STAND BUTST HIT"			, 0,			80,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_HITSTART | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_IGNORE_AUTOSTANCE | ANIM_ATTACK,													ANIM_STAND, ANIM_STAND,	-1},

	// FALL FORWARD FROM HIT STAND
	{"FALL FROM STAND"			, 0,			120,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_NONINTERRUPT | ANIM_HITFINISH | ANIM_NOMOVE_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,				ANIM_STAND, ANIM_PRONE,	-1},

	// FALL FORWARD FROM HIT CROUCH
	{"FALL FROM CROUCH"		, 0,			120,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_NONINTERRUPT | ANIM_HITFINISH | ANIM_NOMOVE_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,				ANIM_CROUCH, ANIM_PRONE, -1},

	// END FALL FORWARD FROM HIT CROUCH
	{"END FALL F CROUCH"		, 0,			120,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_NONINTERRUPT | ANIM_HITFINISH	| ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,				ANIM_PRONE,					ANIM_PRONE,	-1},

	// GENERIC HIT PRONE
	{"GENERIC HIT PRONE"	, 0,			80,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_HITSTART | ANIM_NONINTERRUPT | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,																ANIM_PRONE,					ANIM_PRONE,	-1},

	// PRONE HIT DEATH
	{"PRONE HIT DEATH"		, 0,			120,	(FLOAT)0,		ANIM_STATIONARY | ANIM_NONINTERRUPT | ANIM_NOSHOW_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,													ANIM_PRONE,	ANIM_PRONE,	-1},

	// PRONE LAY FROM HIT
	{"PRONE LAY FROM HIT" , 0,			160,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_NONINTERRUPT | ANIM_HITFINISH | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,					ANIM_PRONE,				ANIM_PRONE,	-1},

	// PRONE HIT DEATHTWICH NO BLOOD
	{"PRONE DEATHHIT NB", 0,				100,	(FLOAT)0,		ANIM_STATIONARY | ANIM_HITWHENDOWN | ANIM_NONINTERRUPT | ANIM_NOSHOW_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,												ANIM_PRONE, ANIM_PRONE, -1},

	// PRONE HIT DEATHTWICH BLOOD
	{"PRONE DEATHHIT B"	, 0,			100,	(FLOAT)0,		ANIM_STATIONARY | ANIM_HITWHENDOWN | ANIM_NONINTERRUPT | ANIM_NOSHOW_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,												ANIM_PRONE, ANIM_PRONE,	-1},

	// FEMALE MONSTER BREATHING
	{"FEMADMON BREATHING", 0,			100,	(FLOAT)0,		ANIM_STATIONARY | ANIM_TURNING | ANIM_NORESTART | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,															ANIM_STAND,	ANIM_STAND,	-1},

	// FEMALE MONSTER BREATHING
	{"FEMADMON WALKING", 0 ,			30,	(FLOAT)2.5,		ANIM_MOVING | ANIM_TURNING | ANIM_NORESTART | ANIM_LIGHT_EFFORT | ANIM_NOCHANGE_WEAPON,																ANIM_STAND,			ANIM_STAND,	-1},

	// FEMALE MONSTER ATTACK
	{"FEMADMON ATTACK", 0 ,			70,	(FLOAT)2.5,		ANIM_STATIONARY | ANIM_TURNING | ANIM_NORESTART | ANIM_LIGHT_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,																ANIM_STAND,			ANIM_STAND, -1},

	{"FLYBACK HIT DEATH STOP"	, 0,			120,	(FLOAT)0,		ANIM_STATIONARY | ANIM_HITSTOP | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,																					ANIM_PRONE, ANIM_PRONE,	-1},

	{"BELLY HIT DEATH STOP"		, 0,			120,	(FLOAT)0,		ANIM_STATIONARY | ANIM_HITSTOP | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,																					ANIM_PRONE, ANIM_PRONE,	-1},

	{"FALLBACK HIT DEATH STOP"	, 0,			120,	(FLOAT)0,		ANIM_STATIONARY | ANIM_HITSTOP | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,																					ANIM_PRONE, ANIM_PRONE,	-1},

	{"PRONE HIT DEATH STOP"		, 0,			120,	(FLOAT)0,		ANIM_STATIONARY | ANIM_HITSTOP | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,																					ANIM_PRONE, ANIM_PRONE,	-1},

	{"FLYBACK HIT STOP"				, 0,			70,	(FLOAT)0,	ANIM_STATIONARY | ANIM_HITSTOP | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,																				 ANIM_PRONE, ANIM_PRONE, -1},

	{"FALLBACK HIT STOP"				, 0,			350,	(FLOAT)0,	ANIM_STATIONARY | ANIM_HITSTOP | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,																				 ANIM_PRONE, ANIM_PRONE, -1},

	{"FALLOFF STOP"						, 0,			350,	(FLOAT)0,	ANIM_STATIONARY | ANIM_HITSTOP | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,																				 ANIM_PRONE, ANIM_PRONE, -1},

	{"FALLOFF FORWARD HIT STOP", 0,			350,	(FLOAT)0,	ANIM_STATIONARY | ANIM_HITSTOP | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,																				 ANIM_PRONE, ANIM_PRONE, -1},

	{"FALLFORWARD HIT STOP", 0,					650,	(FLOAT)0,			ANIM_STATIONARY | ANIM_HITSTOP | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,																				 ANIM_PRONE, ANIM_PRONE, -1},

	{"PRONE_LAYFROMHIT STOP"		, 0,			70,	(FLOAT)0,	ANIM_STATIONARY | ANIM_HITSTOP | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,																				 ANIM_PRONE, ANIM_PRONE, -1},

	{"HOP FENCE"								, 0,			50,	(FLOAT)0,		ANIM_NOCHANGE_PENDINGCOUNT | ANIM_NORESTART | ANIM_STATIONARY | ANIM_NOSHOW_MARKER | ANIM_MODERATE_EFFORT | ANIM_LOWER_WEAPON | ANIM_NONINTERRUPT,																	ANIM_STAND, ANIM_CROUCH,	-1},

	// GENERIC HIT CROUCHED
	{"FEMMONS HIT"							, 0,			80,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_HITSTART | ANIM_NONINTERRUPT | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,														ANIM_STAND, ANIM_STAND,	-1},

	// FALL FORWARD FROM HIT STAND
	{"FEMMONS DIE"							, 0,			80,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_NONINTERRUPT | ANIM_HITFINISH | ANIM_NOMOVE_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,				ANIM_STAND, ANIM_PRONE,	-1},

	// FALL FORWARD FROM HIT STAND
	{"FEMMONS DIE STOP"							, 0,			350,	(FLOAT)0,	ANIM_STATIONARY | ANIM_HITSTOP | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,																				 ANIM_PRONE, ANIM_PRONE, -1},

	//Breathing
	{"PUNCH BREATH"									, 0,			150,			(FLOAT)0, ANIM_NORESTART | ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_FIREREADY | ANIM_LIGHT_EFFORT	| ANIM_NOCHANGE_WEAPON,		ANIM_STAND,	ANIM_STAND, -1},

	// Punch
	{"PUNCH"												, 0,				70,		(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_NO_EFFORT	| ANIM_NOCHANGE_WEAPON | ANIM_NORESTART | ANIM_ATTACK,																					ANIM_STAND,		ANIM_STAND, -1},

	//Breathing
	{"NOTHING_STAND"								, 0,			150,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,						ANIM_STAND,	ANIM_STAND, -1},

	// JFK HIT DEATH
	{"JFK HIT DEATH"								, 0,			160,		(FLOAT)0,	ANIM_STATIONARY | ANIM_NONINTERRUPT | ANIM_HITSTART | ANIM_HITFINISH	| ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,			ANIM_STAND, ANIM_PRONE,	-1},

	{"JFK HIT DEATH STOP"					, 0,			120,		(FLOAT)0,		ANIM_STATIONARY | ANIM_HITSTOP | ANIM_NOSHOW_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,																					ANIM_PRONE, ANIM_PRONE,	-1},

	{"JFK DEATHHIT B"							, 0,			100,	(FLOAT)0,		ANIM_STATIONARY | ANIM_HITWHENDOWN | ANIM_NONINTERRUPT | ANIM_NOSHOW_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,										ANIM_PRONE,	ANIM_PRONE,	-1},

	// STAND BURST // Lesh: AniDelay, speed=0 for control it
	{"STAND BURST SPREAD"					, 0,			0,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_LIGHT_EFFORT | ANIM_ATTACK,														ANIM_STAND, ANIM_STAND,	-1},

	// FALLOFF DEATH
	{"FALLOFF DEATH"							, 0,			120,	(FLOAT)0,		ANIM_STATIONARY | ANIM_NONINTERRUPT | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,											ANIM_PRONE, ANIM_PRONE,	-1},

	// FALLOFF DEATH STOP
	{"FALLOFF DEATH STOP"							, 0,			120,	(FLOAT)0,		ANIM_STATIONARY | ANIM_HITSTOP | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,											ANIM_PRONE, ANIM_PRONE,	-1},

	// FALLOFF TWITCHB
	{"FALLOFF TWITCH BLOOD"							, 0,			120,	(FLOAT)0,		ANIM_STATIONARY | ANIM_HITWHENDOWN | ANIM_NONINTERRUPT | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,											ANIM_PRONE, ANIM_PRONE,	-1},

	// FALLOFF TWITCH NB
	{"FALLOFF TWITCH NOBLOOD"							, 0,			120,	(FLOAT)0,		ANIM_STATIONARY | ANIM_HITWHENDOWN | ANIM_NONINTERRUPT | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,											ANIM_PRONE, ANIM_PRONE,	-1},


	// FALLOFF FORWARD DEATH
	{"FALLOFF FORWARD DEATH"							, 0,			120,	(FLOAT)0,		ANIM_STATIONARY | ANIM_NONINTERRUPT | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,											ANIM_PRONE, ANIM_PRONE,	-1},

	// FALLOFF FORWARD DEATH STOP
	{"FALLOFF FORWARD DEATH STOP"					, 0,			120,	(FLOAT)0,		ANIM_STATIONARY | ANIM_HITSTOP | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,											ANIM_PRONE, ANIM_PRONE,	-1},

	// FALLOFF FORWARD TWITCHB
	{"FALLOFF FORWARD TWITCH BLOOD"				, 0,			120,	(FLOAT)0,		ANIM_STATIONARY | ANIM_HITWHENDOWN | ANIM_NONINTERRUPT | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,											ANIM_PRONE, ANIM_PRONE,	-1},

	// FALLOFF TWITCH NB
	{"FALLOFF FORWARD TWITCH NOBLOOD"			, 0,			120,	(FLOAT)0,		ANIM_STATIONARY | ANIM_HITWHENDOWN | ANIM_NONINTERRUPT | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,											ANIM_PRONE, ANIM_PRONE,	-1},

	//OPEN DOOR
	{"OPEN DOOR"							, 0,			70,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT,		ANIM_STAND,	ANIM_STAND, -1},

	//OPEN STRUCT
	{"OPEN STRUCT"							, 0,			70,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT,		ANIM_STAND,	ANIM_STAND, -1},

	//OPEN STRUCT
	{"PICKUP ITEM"							, 0,			100,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT,		ANIM_STAND,	ANIM_STAND, -1},

	//DROP ITEM
	{"DROP ITEM"							, 0,			100,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT,		ANIM_STAND,	ANIM_STAND, -1},

	//SLICE
	{"SLICE"							, 0,			70,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LIGHT_EFFORT	| ANIM_ATTACK ,		ANIM_STAND,	ANIM_STAND, -1},

	//STAB
	{"STAB"							, 0,			70,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LIGHT_EFFORT	| ANIM_ATTACK ,		ANIM_STAND,	ANIM_STAND, -1},

	//CROUCH STAB
	{"CROUCH STAB"						, 0,			70,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LIGHT_EFFORT	| ANIM_ATTACK ,		ANIM_CROUCH,	ANIM_CROUCH, -1},

	//START GIVING AID
	{"START AID"							, 0,			90,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT	,		ANIM_CROUCH,	ANIM_CROUCH, -1},

	//GIVING AID
	{"GIVING AID"							, 0,			120,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LIGHT_EFFORT	,		ANIM_CROUCH,	ANIM_CROUCH, -1},

	//END GIVING AID
	{"END AID"							, 0,			90,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_RAISE_WEAPON | ANIM_NO_EFFORT	| ANIM_NOCHANGE_PENDINGCOUNT,		ANIM_CROUCH,	ANIM_CROUCH, -1},

	//DODGE ONE
	{"DODGE ONE"							, 0,			40,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,		ANIM_STAND,	ANIM_STAND, -1},

	//FATCIV_ASSSCRATCH
	{"FATCIV ASS SCRATCH"		, 0,			110,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_NO_EFFORT,		ANIM_STAND,	ANIM_STAND, -1},

	// READY_RIFLE_STAND
	{"READY AIM (DW) STAND"	, 0,			150,	(FLOAT)0,	ANIM_OK_CHARGE_AP_FOR_TURN | ANIM_NORESTART | ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN	| ANIM_LIGHT_EFFORT,										ANIM_STAND,	ANIM_STAND, -1},

	// AIM_RIFLE_STAND
	{"AIM (DW) STAND"				, 0,			250,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_FIREREADY | ANIM_FASTTURN | ANIM_LIGHT_EFFORT,	ANIM_STAND, ANIM_STAND,	-1},

	// SHOOT_RIFLE_STAND
	{"SHOOT (DW) STAND"			, 0,			150,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_LIGHT_EFFORT | ANIM_FIRE | ANIM_ATTACK,										ANIM_STAND,	ANIM_STAND, -1},

	// END_RIFLE_STAND
	{"END DUAL STAND"			, 0,			150,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_NOCHANGE_PENDINGCOUNT | ANIM_LIGHT_EFFORT,										ANIM_STAND, ANIM_STAND,	-1},

	//RAISE RIFLE
	{"RAISE RIFLE"						, 0,		70,	 (FLOAT)0,		ANIM_STATIONARY	| ANIM_NOMOVE_MARKER | ANIM_NOCHANGE_WEAPON | ANIM_NO_EFFORT,		ANIM_STAND, ANIM_STAND, -1},

	//LOWER RIFLE
	{"LOWER RIFLE"						, 0,		70,	 (FLOAT)0,		ANIM_STATIONARY	| ANIM_NOMOVE_MARKER | ANIM_NOCHANGE_WEAPON | ANIM_NO_EFFORT,		ANIM_STAND, ANIM_STAND, -1},

	//BOD BLOW
	{"BOD BLOW"						, 0,		200,	 (FLOAT)0,		ANIM_STATIONARY	| ANIM_NOMOVE_MARKER | ANIM_NO_EFFORT | ANIM_NONINTERRUPT | ANIM_NOCHANGE_WEAPON | ANIM_IGNORE_AUTOSTANCE | ANIM_ATTACK,		ANIM_STAND, ANIM_STAND, -1},

	//THROW ITEM
	{"THROW ITEM"						, 0,		80,	 (FLOAT)0,		ANIM_STATIONARY	| ANIM_NOMOVE_MARKER | ANIM_NONINTERRUPT | ANIM_MIN_EFFORT	| ANIM_ATTACK ,		ANIM_STAND, ANIM_STAND, -1},

	//LOB ITEM
	{"LOB ITEM"						, 0,		80,	 (FLOAT)0,		ANIM_STATIONARY	| ANIM_NOMOVE_MARKER | ANIM_NONINTERRUPT | ANIM_MIN_EFFORT	| ANIM_ATTACK ,		ANIM_STAND, ANIM_STAND, -1},

	//QUEEN MONSTER STATIONARY
	{"MONSTER_STATIONARY"						, 0,		100,	 (FLOAT)0,		ANIM_STATIONARY	| ANIM_NOMOVE_MARKER | ANIM_NO_EFFORT | ANIM_BREATH,		ANIM_STAND, ANIM_STAND, -1},

	// CROUCHED BURST // Lesh: AniDelay, speed=0 for control it
	{"CROUCHED BURST SHOOT"		, 0,			0,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_LIGHT_EFFORT | ANIM_FIRE | ANIM_ATTACK,														ANIM_CROUCH, ANIM_CROUCH,	-1},

	// PRONE BURST // Lesh: AniDelay, speed=0 for control it
	{"PRONE BURST SHOOT"		, 0,			0,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_LIGHT_EFFORT | ANIM_FIRE | ANIM_ATTACK,														ANIM_PRONE, ANIM_PRONE,	-1},
	//180
	{"NOT USED 1"					, 20,			20, (FLOAT)0.9, ANIM_MOVING | ANIM_TURNING	| ANIM_NORESTART	| ANIM_NO_EFFORT,			ANIM_STAND,	ANIM_STAND, -1},

	// BIG GUY FLEX
	{"BIG GUY FLEX"		, 0,			150,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_MERCIDLE | ANIM_LOWER_WEAPON | ANIM_NO_EFFORT,														ANIM_STAND, ANIM_STAND,	-1},

	// BIG GUY STRECH
	{"BIG GUY STRECH"		, 0,			110,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_MERCIDLE | ANIM_LOWER_WEAPON | ANIM_NO_EFFORT,														ANIM_STAND, ANIM_STAND,	-1},

	// BIG GUY SOEDUST
	{"BIG GUY SHOE DUST"		, 0,			90,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_MERCIDLE | ANIM_NOCHANGE_WEAPON | ANIM_NO_EFFORT,														ANIM_STAND, ANIM_STAND,	-1},

	// BIG GUY HEADTURN
	{"BIG GUY HEAD TURN"		, 0,			180,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_MERCIDLE | ANIM_NOCHANGE_WEAPON | ANIM_NO_EFFORT,														ANIM_STAND, ANIM_STAND,	-1},

	// MINI GIRL STOCKING
	{"MINI GIRL STOCKING"		, 0,			120,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_NO_EFFORT,														ANIM_STAND, ANIM_STAND,	-1},

	//GIVE ITEM
	{"GIVE ITEM"							, 0,			110,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT	| ANIM_ATTACK ,		ANIM_STAND,	ANIM_STAND, -1},

	//CLIMB MOUNTIAIN
	{"CLIMB MOUNTAIN"					, 0,			50,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_NOSHOW_MARKER | ANIM_MODERATE_EFFORT,		ANIM_STAND,	ANIM_CROUCH, -1},

	{"COW EATING"							, 0,		200,				(FLOAT)0.0, ANIM_STATIONARY | ANIM_TURNING | ANIM_NO_EFFORT,									ANIM_STAND,	ANIM_STAND, -1},

	// COW HIT
	{"COW HIT"									, 0,			150,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_HITSTART | ANIM_NONINTERRUPT | ANIM_NO_EFFORT | ANIM_ATTACK,														ANIM_STAND, ANIM_STAND,	-1},

	// COW DIE
	{"COW DIE"									, 0,			150,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_NONINTERRUPT | ANIM_HITFINISH | ANIM_NOMOVE_MARKER | ANIM_NO_EFFORT | ANIM_ATTACK,				ANIM_STAND, ANIM_PRONE,	-1},

	// COW DIE STOP
	{"COW DIE STOP"						, 0,			350,	(FLOAT)0,	ANIM_STATIONARY | ANIM_HITSTOP | ANIM_NO_EFFORT,																				 ANIM_PRONE, ANIM_PRONE, -1},

	// WATER HIT
	{"WATER HIT"									, 0,			80,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_HITSTART | ANIM_NONINTERRUPT | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,														ANIM_STAND, ANIM_STAND,	-1},

	// WATER DIE
	{"WATER DIE"									, 0,			160,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_NONINTERRUPT | ANIM_HITFINISH | ANIM_NOMOVE_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,				ANIM_STAND, ANIM_PRONE,	-1},

	// WATER DIE STOP
	{"WATER DIE STOP"						, 0,			340,	(FLOAT)0,	ANIM_STATIONARY | ANIM_HITSTOP | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,																				 ANIM_PRONE, ANIM_PRONE, -1},

	{"CROW WALK"									, 0,			80, (FLOAT)1.6, ANIM_MOVING | ANIM_TURNING	| ANIM_NORESTART | ANIM_LIGHT_EFFORT,			ANIM_STAND,	ANIM_STAND, -1},

	{"CROW TAKEOFF"							, 0,			80, (FLOAT)1.6, ANIM_MOVING | ANIM_TURNING	| ANIM_NORESTART | ANIM_NO_EFFORT,			ANIM_STAND,	ANIM_STAND, -1},

	{"CROW LAND"							, 0,			80, (FLOAT)1.6, ANIM_MOVING | ANIM_TURNING	| ANIM_NORESTART | ANIM_NO_EFFORT,			ANIM_STAND,	ANIM_STAND, -1},

	{"CROW FLY"									, 0,			20, (FLOAT)0.5, ANIM_SPECIALMOVE |	ANIM_MOVING | ANIM_TURNING	| ANIM_NORESTART | ANIM_LIGHT_EFFORT,			ANIM_STAND,	ANIM_STAND, -1},

	{"CROW EAT"									, 0,			80, (FLOAT)0, ANIM_STATIONARY	| ANIM_TURNING	| ANIM_NORESTART | ANIM_MIN_EFFORT,			ANIM_STAND,	ANIM_STAND, -1},

	{"HELIDROP"									, 0,			60, (FLOAT)0, ANIM_STATIONARY	| ANIM_TURNING	| ANIM_NORESTART | ANIM_NOSHOW_MARKER | ANIM_NO_EFFORT | ANIM_ATTACK,			ANIM_STAND,	ANIM_CROUCH, -1},

	{"FEM CLEAN"									, 0,			110,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_MERCIDLE | ANIM_NOCHANGE_WEAPON | ANIM_NO_EFFORT,														ANIM_STAND, ANIM_STAND,	-1},

	{"FEM KICKSN"								, 0,			110,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_MERCIDLE | ANIM_LOWER_WEAPON | ANIM_NO_EFFORT,														ANIM_STAND, ANIM_STAND,	-1},

	{"FEM LOOK"									, 0,			180,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_MERCIDLE | ANIM_NOCHANGE_WEAPON | ANIM_NO_EFFORT,														ANIM_STAND, ANIM_STAND,	-1},

	{"FEM WIPE"									, 0,			110,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_MERCIDLE | ANIM_LOWER_WEAPON | ANIM_NO_EFFORT,														ANIM_STAND, ANIM_STAND,	-1},

	{"REG SQUISH"								, 0,			110,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_MERCIDLE | ANIM_LOWER_WEAPON | ANIM_NO_EFFORT,														ANIM_STAND, ANIM_STAND,	-1},

	{"REG PULL"									, 0,			110,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_MERCIDLE | ANIM_LOWER_WEAPON | ANIM_NO_EFFORT,														ANIM_STAND, ANIM_STAND,	-1},

	{"REG SPIT"									, 0,			130,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_MERCIDLE | ANIM_NOCHANGE_WEAPON | ANIM_NO_EFFORT,														ANIM_STAND, ANIM_STAND,	-1},

	{"KID YOYO"									, 0,			140,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_NO_EFFORT,														ANIM_STAND, ANIM_STAND,	-1},

	{"KID ARMPIT"								, 0,			70,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_NO_EFFORT,														ANIM_STAND, ANIM_STAND,	-1},

	{"ADULT MONSTER CLOSE ATTACK", 0 ,			70,	(FLOAT)0,		ANIM_STATIONARY | ANIM_TURNING | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_LIGHT_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,						ANIM_STAND,			ANIM_STAND, -1},

	"ADULT MONSTER SPIT ATTACK", 0 ,			70,	(FLOAT)0,		ANIM_STATIONARY | ANIM_TURNING | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_LIGHT_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,						ANIM_STAND,			ANIM_STAND, -1,

	"ADULT MONSTER BEGIN EATING", 0 ,						70,	(FLOAT)0,		ANIM_STATIONARY | ANIM_TURNING | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_NO_EFFORT,																ANIM_STAND,			ANIM_STAND, -1,

	"ADULT MONSTER EATING",				0 ,						70,	(FLOAT)0,		ANIM_STATIONARY | ANIM_TURNING | ANIM_NORESTART | ANIM_LIGHT_EFFORT,																										ANIM_STAND,			ANIM_STAND, -1,

	"ADULT MONSTER END EATING",		0 ,						70,	(FLOAT)0,		ANIM_STATIONARY | ANIM_TURNING | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_NO_EFFORT,																ANIM_STAND,			ANIM_STAND, -1,

	//RUN
	"BLOODCAT RUN"							, 0,						50,			(FLOAT)5.4, ANIM_MOVING | ANIM_TURNING	| ANIM_NORESTART | ANIM_MODERATE_EFFORT,	ANIM_STAND, ANIM_STAND, -1,

	//
	"BLOODCAT BEGIN READY"			, 0,						70,	(FLOAT)0,		ANIM_OK_CHARGE_AP_FOR_TURN | ANIM_STATIONARY | ANIM_TURNING | ANIM_NORESTART | ANIM_NO_EFFORT,																										ANIM_STAND,			ANIM_STAND, -1,

	"BLOODCAT READY"						, 0,						130,	(FLOAT)0,		ANIM_STATIONARY | ANIM_TURNING | ANIM_NORESTART | ANIM_NO_EFFORT,																										ANIM_STAND,			ANIM_STAND, -1,

	"BLOODCAT END READY"				, 0,						70,	(FLOAT)0,		ANIM_STATIONARY | ANIM_TURNING | ANIM_NORESTART | ANIM_NO_EFFORT,																										ANIM_STAND,			ANIM_STAND, -1,

	// CAT HIT
	"BLOODCAT HIT"							, 0,						110,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_HITSTART | ANIM_NONINTERRUPT | ANIM_NO_EFFORT | ANIM_ATTACK,																	ANIM_STAND, ANIM_STAND,	-1,

	// CAT DIE
	"BLOODCAT DIE"							, 0,						110,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_NONINTERRUPT | ANIM_HITFINISH | ANIM_NOMOVE_MARKER | ANIM_ATTACK,						ANIM_STAND, ANIM_PRONE,	-1,

	// CAT DIE STOP
	"BLOODCAT DIE STOP"					, 0,						100,	(FLOAT)0,	ANIM_STATIONARY | ANIM_HITSTOP | ANIM_NO_EFFORT,																																	 ANIM_PRONE, ANIM_PRONE, -1,

	"BLOODCAT SWIPE"						, 0 ,						70,	(FLOAT)0,		ANIM_STATIONARY | ANIM_TURNING | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_MIN_EFFORT | ANIM_ATTACK,																ANIM_STAND,			ANIM_STAND, -1,

	"NINJA GOTO BREATH"					, 0,						70,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_LIGHT_EFFORT | ANIM_NOCHANGE_WEAPON,																			ANIM_STAND,	ANIM_STAND, -1,

	"NINJA BREATH"							, 0,						0,		(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_LIGHT_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_FIREREADY,																										ANIM_STAND,		ANIM_STAND, -1,//dnl ch73 280913

	"NINJA LOWKICK"							, 0,						50,		(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_NONINTERRUPT | ANIM_LIGHT_EFFORT	| ANIM_NOCHANGE_WEAPON | ANIM_NORESTART | ANIM_ATTACK,															ANIM_STAND,		ANIM_STAND, -1,

	"NINJA PUNCH"							, 0,						50,		(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_NONINTERRUPT | ANIM_LIGHT_EFFORT	| ANIM_NOCHANGE_WEAPON | ANIM_NORESTART | ANIM_ATTACK,															ANIM_STAND,		ANIM_STAND, -1,

	"NINJA SPIN KICK"						, 0,						70,		(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_NONINTERRUPT | ANIM_MODERATE_EFFORT	| ANIM_NOCHANGE_WEAPON | ANIM_NORESTART | ANIM_ATTACK,															ANIM_STAND,		ANIM_STAND, -1,

	//END OPEN DOOR
	"END OPEN DOOR"							, 0,			100,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LOWER_WEAPON | ANIM_MIN_EFFORT,		ANIM_STAND,	ANIM_STAND, -1,

	//END OPEN LOCKED DOOR
	"END OPEN LOCKED DOOR"			, 0,			100,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_LOWER_WEAPON | ANIM_MIN_EFFORT,		ANIM_STAND,	ANIM_STAND, -1,

	//KICK DOOR
	"KICK DOOR"									, 0,			70,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART |	ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT | ANIM_ATTACK,		ANIM_STAND,	ANIM_STAND, -1,

	//KICK DOOR
	"CLOSE DOOR"								, 0,			100,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LOWER_WEAPON | ANIM_MIN_EFFORT,		ANIM_STAND,	ANIM_STAND, -1,

	// HIT STANDING RIFLE
	"HIT STAND RIFLE"						, 0,			150,	(FLOAT)0,	ANIM_STATIONARY | ANIM_HITSTART | ANIM_TURNING | ANIM_NONINTERRUPT | ANIM_NOCHANGE_WEAPON | ANIM_NO_EFFORT | ANIM_ATTACK,										ANIM_STAND, ANIM_STAND,	-1,

	// DEEP WATER TREAD
	"DEEP WATER TREAD"					, 0,			200,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_NOCHANGE_WEAPON | ANIM_MODERATE_EFFORT,																																							ANIM_STAND, ANIM_STAND,	-1,

	// DEEP WATER SWIM
	"DEEP WATER SWIM"						, 0,			160,	(FLOAT)1.3,	ANIM_MOVING | ANIM_TURNING	| ANIM_NORESTART | ANIM_NOCHANGE_WEAPON | ANIM_MODERATE_EFFORT,																					ANIM_STAND, ANIM_STAND,	-1,

	// DEEP WATER HIT
	"DEEP WATER HIT"						, 0,			100,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_HITSTART | ANIM_NONINTERRUPT | ANIM_NO_EFFORT | ANIM_ATTACK,														ANIM_STAND, ANIM_STAND,	-1,

	// DEEP WATER DIE
	"DEEP WATER DIE"						, 0,			210,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_NONINTERRUPT | ANIM_HITFINISH | ANIM_NOMOVE_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,				ANIM_STAND, ANIM_PRONE,	-1,

	// DEEP WATER DIE STOPPING
	"DEEP WATER DIE STOPPING"		, 0,			340,	(FLOAT)0,	ANIM_STATIONARY | ANIM_NONINTERRUPT | ANIM_HITSTOP | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,																				 ANIM_PRONE, ANIM_PRONE, -1,

	// DEEP WATER DIE STOP
	"DEEP WATER DIE STOP"				, 0,			340,	(FLOAT)0,	ANIM_STATIONARY | ANIM_HITSTOP | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,																				 ANIM_PRONE, ANIM_PRONE, -1,

	// WATER TRANSITION
	"LOW TO DEEP WATER"					, 0,			100,	(FLOAT)0,	ANIM_STATIONARY | ANIM_NOCHANGE_WEAPON | ANIM_NO_EFFORT,																				 ANIM_STAND, ANIM_STAND, -1,

	// WATER TRANSITION
	"DEEP TO LOW WATER"					, 0,			100,	(FLOAT)0,	ANIM_STATIONARY | ANIM_NOCHANGE_WEAPON | ANIM_NO_EFFORT,																				 ANIM_STAND, ANIM_STAND, -1,

	// GOTO SLEEP
	"GOTO SLEEP"								, 0,			100,	(FLOAT)0,	ANIM_STATIONARY | ANIM_LOWER_WEAPON | ANIM_NONINTERRUPT| ANIM_NO_EFFORT,																				 ANIM_CROUCH, ANIM_PRONE, -1,

	// SLEEP
	"SLEEPING"								, 0,				2000,	(FLOAT)0,	ANIM_STATIONARY | ANIM_NOCHANGE_WEAPON | ANIM_NO_EFFORT | ANIM_UPDATEMOVEMENTMODE,																		 ANIM_PRONE, ANIM_PRONE, -1,

	// WAKEUP
	"WAKEUP"									, 0,				100,	(FLOAT)0,	ANIM_STATIONARY | ANIM_RAISE_WEAPON | ANIM_NO_EFFORT,																				 ANIM_PRONE, ANIM_CROUCH, -1,

	// SHOOT_RIFLE_STAND LOW
	"SHOOT (R) STAND LOW"					, 0,			100,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_RAISE_WEAPON | ANIM_LIGHT_EFFORT | ANIM_FIRE | ANIM_ATTACK,										ANIM_STAND,	ANIM_STAND, -1,

	// SHOOT_RIFLE_STAND LOW // Lesh: AniDelay, speed=0 for control it
	"BURST SHOOT (R) STAND LOW"		, 0,			0,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_RAISE_WEAPON | ANIM_LIGHT_EFFORT | ANIM_FIRE | ANIM_ATTACK,										ANIM_STAND,	ANIM_STAND, -1,

	//LARVAE Breathing
	"LARVAE BREATH"							, 0,			250,			(FLOAT)0,		ANIM_STATIONARY | ANIM_TURNING | ANIM_NORESTART | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,															ANIM_STAND,	ANIM_STAND,	-1,

	// GENERIC HIT CROUCHED
	"LARVAE HIT"								, 0,			80,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_HITSTART | ANIM_NONINTERRUPT | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,														ANIM_STAND, ANIM_STAND,	-1,

	// FALL FORWARD FROM HIT STAND
	"LARVAE DIE"								, 0,			80,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_NONINTERRUPT | ANIM_HITFINISH | ANIM_NOMOVE_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,				ANIM_STAND, ANIM_PRONE,	-1,

	// FALL FORWARD FROM HIT STAND
	"LARVAE DIE STOP"						, 0,			350,	(FLOAT)0,	ANIM_STATIONARY | ANIM_HITSTOP | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,																				 ANIM_PRONE, ANIM_PRONE, -1,

	// FEMALE MONSTER BREATHING
	"LARVAE WALKING"						, 0 ,			110,	(FLOAT)0.5,		ANIM_MOVING | ANIM_TURNING | ANIM_NORESTART | ANIM_LIGHT_EFFORT | ANIM_NOCHANGE_WEAPON,																ANIM_STAND,			ANIM_STAND,	-1,

	// GENERIC HIT CROUCHED
	"INFANT HIT"								, 0,			80,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_HITSTART | ANIM_NONINTERRUPT | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,														ANIM_STAND, ANIM_STAND,	-1,

	// FALL FORWARD FROM HIT STAND
	"INFANT DIE"								, 0,			80,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_NONINTERRUPT | ANIM_HITFINISH | ANIM_NOMOVE_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,				ANIM_STAND, ANIM_PRONE,	-1,

	// FALL FORWARD FROM HIT STAND
	"INFANT DIE STOP"						, 0,			350,	(FLOAT)0,	ANIM_STATIONARY | ANIM_HITSTOP | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,																				 ANIM_PRONE, ANIM_PRONE, -1,

	"INFANT MONSTER SPIT ATTACK", 0 ,			70,	(FLOAT)0,		ANIM_STATIONARY | ANIM_TURNING | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_LIGHT_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,																ANIM_STAND,			ANIM_STAND, -1,

	"INFANT MONSTER BEGIN EATING",	0 ,						70,	(FLOAT)0,		ANIM_STATIONARY | ANIM_TURNING | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,																ANIM_STAND,			ANIM_STAND, -1,

	"INFANT MONSTER EATING",				0 ,						120,	(FLOAT)0,		ANIM_STATIONARY | ANIM_TURNING | ANIM_NORESTART | ANIM_LIGHT_EFFORT | ANIM_NOCHANGE_WEAPON,																										ANIM_STAND,			ANIM_STAND, -1,

	"INFANT MONSTER END EATING",		0 ,						70,	(FLOAT)0,		ANIM_STATIONARY | ANIM_TURNING | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,																ANIM_STAND,			ANIM_STAND, -1,

	"ADULT	MONSTER UP",						0 ,						130,	(FLOAT)0,		ANIM_STATIONARY | ANIM_TURNING | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,																ANIM_STAND,			ANIM_STAND, -1,

	"ADULT	MONSTER JUMP",					0 ,						110,	(FLOAT)0,		ANIM_STATIONARY | ANIM_TURNING | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,																ANIM_STAND,			ANIM_STAND, -1,

	// UNJAM STANDING
	"UNJAM STANDING"							, 0,			150,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NOCHANGE_WEAPON | ANIM_MIN_EFFORT	| ANIM_ATTACK,																													ANIM_STAND,	ANIM_STAND, -1,

	// UNJAM CROUCH
	"UNJAM CROUCH"								, 0,			150,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NOCHANGE_WEAPON | ANIM_MIN_EFFORT	| ANIM_ATTACK,																													ANIM_CROUCH,	ANIM_CROUCH, -1,

	// UNJAM PRONE
	"UNJAM PRONE"								, 0,			150,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NOCHANGE_WEAPON | ANIM_MIN_EFFORT	| ANIM_ATTACK,																														ANIM_PRONE,	ANIM_PRONE, -1,

	// UNJAM STAND DWEL
	"UNJAM STAND DWEL"					, 0,			150,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NOCHANGE_WEAPON | ANIM_MIN_EFFORT	| ANIM_ATTACK,																														ANIM_STAND,	ANIM_STAND, -1,

	// UNJAM STAND LOW
	"UNJAM STAND LOW"						, 0,			150,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NOCHANGE_WEAPON | ANIM_MIN_EFFORT	| ANIM_ATTACK,																														ANIM_STAND,	ANIM_STAND, -1,

	// READY_RIFLE_CROUCH
	"READY AIM (DW) CROUCH"			, 0,			150,	(FLOAT)0,	ANIM_OK_CHARGE_AP_FOR_TURN | ANIM_NORESTART | ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN	| ANIM_LIGHT_EFFORT,							ANIM_CROUCH,	ANIM_CROUCH, -1,

	// AIM_RIFLE_CROUCH
	"AIM (DW) CROUCH"						, 0,			250,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_FIREREADY | ANIM_FASTTURN | ANIM_LIGHT_EFFORT,								ANIM_CROUCH, ANIM_CROUCH,	-1,

	// SHOOT_RIFLE_CROUCH
	"SHOOT (DW) CROUCH"					, 0,			150,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_LIGHT_EFFORT | ANIM_FIRE | ANIM_ATTACK,																			ANIM_CROUCH,	ANIM_CROUCH, -1,

	// END_RIFLE_STAND
	"END DUAL CROUCH"						, 0,			150,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_NOCHANGE_PENDINGCOUNT | ANIM_LIGHT_EFFORT,										ANIM_CROUCH, ANIM_CROUCH,	-1,

	// UNJAM CROUCH DWEL
	"UNJAM CROUCH DWEL"					, 0,			150,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NOCHANGE_WEAPON | ANIM_MIN_EFFORT	| ANIM_ATTACK,																														ANIM_CROUCH,	ANIM_CROUCH, -1,

	//GET ADJACENT ITEM
	"GET ADJACENT ITEM"					, 0,			100,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT,												ANIM_STAND,	ANIM_STAND, -1,

	//CUTTING FENCE
	"CUTTING FENCE"							, 0,			90,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT	| ANIM_ATTACK,		ANIM_CROUCH,	ANIM_CROUCH, -1,

	"CRIPPLE BEG"								, 0,			110,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_MERCIDLE | ANIM_NOCHANGE_WEAPON | ANIM_NO_EFFORT,														ANIM_STAND, ANIM_STAND,	-1,

	// CRIPPLE HIT
	"CRIPPLE HIT"								, 0,			80,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_HITSTART | ANIM_NONINTERRUPT | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,															ANIM_STAND, ANIM_STAND,	-1,

	// CRIPPLE DIE
	"CRIPPLE DIE"								, 0,			80,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_NONINTERRUPT | ANIM_HITFINISH | ANIM_NOMOVE_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,				ANIM_STAND, ANIM_PRONE,	-1,

	// CRIPPLE DIE STOP
	"CRIPPLE DIE STOP"					, 0,			350,	(FLOAT)0,	ANIM_STATIONARY | ANIM_HITSTOP | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,																																	ANIM_PRONE, ANIM_PRONE, -1,

	// CRIPPLE FLYBACK DIE
	"CRIPPLE FLYBACK DIE"								, 0,			80,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_NONINTERRUPT | ANIM_HITFINISH | ANIM_NOMOVE_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,				ANIM_STAND, ANIM_PRONE,	-1,

	// CRIPPLE FLYBACK DIE STOP
	"CRIPPLE FLYBACK DIE STOP"					, 0,			350,	(FLOAT)0,	ANIM_STATIONARY | ANIM_HITSTOP | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,																																	ANIM_PRONE, ANIM_PRONE, -1,

	// CRIPPLE KICK
	"CRIPPLE KICK"								, 0,			80,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_NONINTERRUPT | ANIM_NOMOVE_MARKER | ANIM_MIN_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,															ANIM_STAND, ANIM_STAND,	-1,

	// INJURED TRANSITION
	"INJURED TRANSITION"					, 0,			80,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_NONINTERRUPT | ANIM_NOMOVE_MARKER | ANIM_MIN_EFFORT | ANIM_NOCHANGE_WEAPON,															ANIM_STAND, ANIM_STAND,	-1,

	//THROW KNIFE
	"THROW KNIFE"									, 0,		50,	 (FLOAT)0,		ANIM_STATIONARY	| ANIM_NOMOVE_MARKER | ANIM_NONINTERRUPT | ANIM_MIN_EFFORT	| ANIM_ATTACK ,		ANIM_STAND, ANIM_STAND, -1,

	//Breathing
	"KNIFE BREATH"									, 0,			150,			(FLOAT)0, ANIM_NORESTART | ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_FIREREADY | ANIM_LIGHT_EFFORT	| ANIM_NOCHANGE_WEAPON,		ANIM_STAND,	ANIM_STAND, -1,

	//Breathing
	"KNIFE GOTO BREATH"							, 0,			150,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_FIREREADY | ANIM_LIGHT_EFFORT	| ANIM_NOCHANGE_WEAPON | ANIM_NONINTERRUPT | ANIM_ATTACK,		ANIM_STAND,	ANIM_STAND, -1,

	//Breathing
	"KNIFE END BREATH"							, 0,			150,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_FIREREADY | ANIM_LIGHT_EFFORT	| ANIM_NOCHANGE_WEAPON | ANIM_NONINTERRUPT,		ANIM_STAND,	ANIM_STAND, -1,

	// ROBOT HIT
	"ROBOT HIT"								, 0,			80,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_HITSTART | ANIM_NONINTERRUPT | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,															ANIM_STAND, ANIM_STAND,	-1,

	// ROBOT DIE
	"ROBOT DIE"								, 0,			80,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_NONINTERRUPT | ANIM_HITFINISH | ANIM_NOMOVE_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,				ANIM_STAND, ANIM_PRONE,	-1,

	// ROBOT DIE STOP
	"ROBOT DIE STOP"					, 0,			350,	(FLOAT)0,	ANIM_STATIONARY | ANIM_HITSTOP | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,																																	ANIM_PRONE, ANIM_PRONE, -1,

	//Catch Standing
	"Catch Standing"				, 0,			80,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_FIREREADY | ANIM_LIGHT_EFFORT	| ANIM_LOWER_WEAPON | ANIM_ATTACK,		ANIM_STAND,	ANIM_STAND, -1,

	//Catch Crouched
	"Catch Crouched"				, 0,			80,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_FIREREADY | ANIM_LIGHT_EFFORT	| ANIM_LOWER_WEAPON | ANIM_ATTACK,		ANIM_CROUCH,	ANIM_CROUCH, -1,

	//PLANT BOMB
	"PLANT BOMB"							, 0,			120,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT | ANIM_ATTACK,		ANIM_STAND,	ANIM_STAND, -1,

	//Use remote
	"Use Remote"				, 0,			80,			(FLOAT)0, ANIM_NORESTART | ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_FIREREADY | ANIM_LIGHT_EFFORT	| ANIM_NOCHANGE_WEAPON | ANIM_NONINTERRUPT,		ANIM_STAND,	ANIM_STAND, -1,

	//COWER
	"START Cower"					, 0,			150,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LIGHT_EFFORT	| ANIM_NOCHANGE_WEAPON | ANIM_NONINTERRUPT | ANIM_IGNORE_AUTOSTANCE,		ANIM_STAND,	ANIM_CROUCH, -1,

	//COWER
	"Cowering"						, 0,			150,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LIGHT_EFFORT	| ANIM_NOCHANGE_WEAPON ,		ANIM_CROUCH,	ANIM_CROUCH, -1,

	//END COWER
	"End Cower"						, 0,			150,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LIGHT_EFFORT	| ANIM_NOCHANGE_WEAPON | ANIM_IGNORE_AUTOSTANCE,		ANIM_CROUCH,	ANIM_STAND, -1,

	//STEAL ITEM
	"STEAL ITEM"						, 0,			110,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT	| ANIM_ATTACK ,		ANIM_STAND,	ANIM_STAND, -1,

	//LAUNCH ROCKET
	"LAUNCH ROCKET"					, 0,			110,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LIGHT_EFFORT	| ANIM_ATTACK ,		ANIM_STAND,	ANIM_STAND, -1,

	// CIV ALT DIE
	"CIV ALT DIE"							, 0,			80,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_NONINTERRUPT | ANIM_HITFINISH | ANIM_NOMOVE_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,				ANIM_STAND, ANIM_PRONE,	-1,

	//SHOOT MORTAR
	"SHOOT MORTAR"					, 0,			110,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT	| ANIM_ATTACK ,		ANIM_CROUCH,	ANIM_CROUCH, -1,

	//CROW DIE
	"CROW_DIE"						, 0,				130,			(FLOAT)0, ANIM_STATIONARY | ANIM_NONINTERRUPT | ANIM_FASTTURN | ANIM_NORESTART | ANIM_NOCHANGE_WEAPON | ANIM_LIGHT_EFFORT ,		ANIM_STAND,	ANIM_STAND, -1,

	//SIDE STEPPING
	"SIDE STEPPING"			, 0,			50, (FLOAT)0.4, ANIM_MOVING | ANIM_NORESTART | ANIM_RAISE_WEAPON | ANIM_VARIABLE_EFFORT,			ANIM_STAND,	ANIM_STAND, -1,

	//WALK BACKWARDS
	"WALK BACKWARDS"			, 0,			110, (FLOAT)1.4,	ANIM_MOVING | ANIM_NORESTART | ANIM_RAISE_WEAPON | ANIM_VARIABLE_EFFORT | ANIM_TURNING,			ANIM_STAND,	ANIM_STAND, -1,

	//OPEN STRUCT
	"BEGIN OPEN STRUCT"		, 0,			70,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT,		ANIM_STAND,	ANIM_STAND, -1,

	//END STRUCT
	"END OPEN STRUCT"		, 0,				70,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT,		ANIM_STAND,	ANIM_STAND, -1,

	//END OPEN LOCKED
	"END OPEN LOCKED STRUCT"		, 0,			70,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT,		ANIM_STAND,	ANIM_STAND, -1,

	// Punch LOw
	"LOW PUNCH"								, 0,				70,		(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_NO_EFFORT	| ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,																					ANIM_CROUCH,		ANIM_CROUCH, -1,

	// SHOOT_PISTOL_STAND LOW
	"SHOOT (P) STAND LOW"					, 0,			100,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_RAISE_WEAPON | ANIM_LIGHT_EFFORT | ANIM_FIRE | ANIM_ATTACK,										ANIM_STAND,	ANIM_STAND, -1,

	//DECAPITATE
	"DECAPITATE"						, 0,			70,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LIGHT_EFFORT	| ANIM_NONINTERRUPT | ANIM_ATTACK,		ANIM_CROUCH,	ANIM_CROUCH, -1,

	"BLOODCAT BITE"						, 0 ,						70,	(FLOAT)0,		ANIM_STATIONARY | ANIM_TURNING | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_MIN_EFFORT | ANIM_ATTACK,																ANIM_STAND,			ANIM_STAND, -1,

	"BIGMERC S NECK"				, 0,			110,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_MERCIDLE | ANIM_NOCHANGE_WEAPON | ANIM_NO_EFFORT,														ANIM_STAND, ANIM_STAND,	-1,

	//CROUCH TRANSITION
	"BIGMERC CROUCH TRANS INTO"		, 0,		90,		(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING	| ANIM_NOMOVE_MARKER | ANIM_STANCECHANGEANIM	| ANIM_RAISE_WEAPON | ANIM_MIN_EFFORT,	ANIM_STAND, ANIM_CROUCH, -1,

	//CROUCH TRANSITION
	"BIGMERC CROUCH TRANS OUTOF"		, 0,		90,		(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING	| ANIM_NOMOVE_MARKER | ANIM_STANCECHANGEANIM	| ANIM_RAISE_WEAPON | ANIM_MIN_EFFORT,	ANIM_CROUCH, ANIM_STAND, -1,

	//GOTO PATIENT
	"GOTO PATIENT"								, 0,		1000,	 (FLOAT)0,	ANIM_STATIONARY | ANIM_FASTTURN | ANIM_NOCHANGE_WEAPON | ANIM_NO_EFFORT	,			ANIM_PRONE, ANIM_PRONE, -1,

	//BEING PATIENT
	"BEING PATIENT"								, 0,		1000,	 (FLOAT)0,	ANIM_STATIONARY | ANIM_FASTTURN | ANIM_NOCHANGE_WEAPON | ANIM_NO_EFFORT | ANIM_UPDATEMOVEMENTMODE ,			ANIM_PRONE, ANIM_PRONE, -1,

	//GOTO DOCTOR
	"GOTO DOCTOR"							, 0,			90,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT,		ANIM_CROUCH,	ANIM_CROUCH, -1,

	//BEING DOCTOR
	"BEING DOCTOR"						, 0,			120,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LIGHT_EFFORT | ANIM_UPDATEMOVEMENTMODE ,		ANIM_CROUCH,	ANIM_CROUCH, -1,

	//ENDING DOCTOR
	"END DOCTOR"							, 0,			90,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_RAISE_WEAPON | ANIM_NO_EFFORT	| ANIM_NOCHANGE_PENDINGCOUNT,		ANIM_CROUCH,	ANIM_CROUCH, -1,

	//GOTO REPAIRMAN
	"GOTO REPAIRMAN"							, 0,			90,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT	,		ANIM_CROUCH,	ANIM_CROUCH, -1,

	//BEING REPAIRMAN
	"BEING REPAIRMAN"						, 0,			120,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LIGHT_EFFORT | ANIM_UPDATEMOVEMENTMODE ,		ANIM_CROUCH,	ANIM_CROUCH, -1,

	//ENDING REPAIRMAN
	"END REPAIRMAN"							, 0,			90,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_RAISE_WEAPON | ANIM_NO_EFFORT	| ANIM_NOCHANGE_PENDINGCOUNT,		ANIM_CROUCH,	ANIM_CROUCH, -1,

	//FALL INTO PIT
	"FALL INTO PIT"							, 0,			60,	(FLOAT)0,		ANIM_STATIONARY | ANIM_NONINTERRUPT | ANIM_HITFINISH | ANIM_NOSHOW_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,																	ANIM_STAND, ANIM_PRONE,	-1,

	// ROBOT WALK
	"ROBOT WALKING"							, 0 ,			80,	(FLOAT)1.5,	ANIM_MOVING | ANIM_TURNING | ANIM_NORESTART | ANIM_LIGHT_EFFORT | ANIM_NOCHANGE_WEAPON,																ANIM_STAND,			ANIM_STAND,	-1,

	// ROBOT SHOOT
	"ROBOT SHOOT"								, 0,			100,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_RAISE_WEAPON | ANIM_LIGHT_EFFORT | ANIM_FIRE | ANIM_ATTACK,										ANIM_STAND,	ANIM_STAND, -1,

	// QUEEN HIT
	"QUEEN HIT"								, 0,			200,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_HITSTART | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,															ANIM_STAND, ANIM_STAND,	-1,

	// QUEEN DIE
	"QUEEN DIE"								, 0,			120,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_HITFINISH | ANIM_NOMOVE_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,				ANIM_STAND, ANIM_PRONE,	-1,

	// QUEEN DIE STOP
	"QUEEN DIE STOP"					, 0,			350,	(FLOAT)0,	ANIM_STATIONARY | ANIM_HITSTOP | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON,																																	ANIM_PRONE, ANIM_PRONE, -1,

	"QUEEN INTO READY"				, 0,						130,	(FLOAT)0,		ANIM_STATIONARY | ANIM_TURNING | ANIM_NORESTART | ANIM_NO_EFFORT,																										ANIM_STAND,			ANIM_STAND, -1,

	"QUEEN READY"							, 0,						130,	(FLOAT)0,		ANIM_STATIONARY | ANIM_TURNING | ANIM_NORESTART | ANIM_NO_EFFORT,																										ANIM_STAND,			ANIM_STAND, -1,

	"QUEEN END READY"					, 0,						130,	(FLOAT)0,		ANIM_STATIONARY | ANIM_TURNING | ANIM_NORESTART | ANIM_NO_EFFORT,																										ANIM_STAND,			ANIM_STAND, -1,

	"QUEEN CALL"							, 0,						130,	(FLOAT)0,		ANIM_STATIONARY | ANIM_TURNING | ANIM_NORESTART | ANIM_NO_EFFORT | ANIM_ATTACK,																										ANIM_STAND,			ANIM_STAND, -1,

	"QUEEN MONSTER SPIT ATTACK", 0 ,					130,	 (FLOAT)0,		ANIM_STATIONARY | ANIM_TURNING | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_LIGHT_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,			ANIM_STAND,			ANIM_STAND, -1,

	"QUEEN MONSTER SWIPE ATTACK", 0 ,					130,	 (FLOAT)0,		ANIM_STATIONARY | ANIM_TURNING | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_LIGHT_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,			ANIM_STAND,			ANIM_STAND, -1,

	//RELOAD ROBOT
	"RELOAD ROBOT"			, 0,			70,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT | ANIM_ATTACK,		ANIM_CROUCH,	ANIM_CROUCH, -1,

	//End Catch Standing
	"Catch Standing"				, 0,			80,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_FIREREADY | ANIM_LIGHT_EFFORT	| ANIM_NOCHANGE_WEAPON | ANIM_NONINTERRUPT | ANIM_ATTACK,		ANIM_STAND,	ANIM_STAND, -1,

	//End Catch Crouched
	"Catch Crouched"				, 0,			80,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_FIREREADY | ANIM_LIGHT_EFFORT	| ANIM_NOCHANGE_WEAPON | ANIM_NONINTERRUPT | ANIM_ATTACK,		ANIM_CROUCH,	ANIM_CROUCH, -1,

	"RADIO"								, 0,						130,	(FLOAT)0,		ANIM_STATIONARY | ANIM_TURNING | ANIM_NORESTART | ANIM_NO_EFFORT | ANIM_ATTACK,																										ANIM_STAND,			ANIM_STAND, -1,

	"CROUCH RADIO"								, 0,						130,	(FLOAT)0,		ANIM_STATIONARY | ANIM_TURNING | ANIM_NORESTART | ANIM_NO_EFFORT | ANIM_ATTACK,																										ANIM_CROUCH,			ANIM_CROUCH, -1,

	// TANK SHOOT
	"TANK SHOOT"					, 0,			200,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_NOCHANGE_WEAPON | ANIM_LIGHT_EFFORT | ANIM_FIRE | ANIM_ATTACK,										ANIM_STAND,	ANIM_STAND, -1,

	// TANK SHOOT // Lesh: AniDelay, speed=0 for control it
	"TANK BURST"					, 0,			0,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_NOCHANGE_WEAPON | ANIM_LIGHT_EFFORT | ANIM_FIRE | ANIM_ATTACK,										ANIM_STAND,	ANIM_STAND, -1,

	//Queen Slap
	"QUEEN SLAP"					, 0,			120,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART |	ANIM_LIGHT_EFFORT	| ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,		ANIM_STAND,	ANIM_STAND, -1,

	//Slap hit
	"SLAP HIT"						, 0,			70,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART |	ANIM_LIGHT_EFFORT	| ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,		ANIM_STAND,	ANIM_STAND, -1,

	//GET BLOOD
	"GET BLOOD"			, 0,			70,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT,		ANIM_CROUCH,	ANIM_CROUCH, -1,

	//VEHICLE DIE
	"VEHICLE DIE"			, 0,			150,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_NOCHANGE_WEAPON | ANIM_LIGHT_EFFORT | ANIM_ATTACK,		ANIM_STAND,	ANIM_STAND, -1,

	//Queen Frustrated Slap
	"QUEEN FRUSTRATED SLAP"			, 0,			120,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART |	ANIM_LIGHT_EFFORT	| ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,		ANIM_STAND,	ANIM_STAND, -1,

	//SOLDIER BRUN
	"FIRE FIRE"				, 0,			150,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_NOCHANGE_WEAPON | ANIM_LIGHT_EFFORT | ANIM_IGNORE_AUTOSTANCE | ANIM_ATTACK,		ANIM_STAND,	ANIM_STAND, -1,

	//AI TRIGGER
	"AI TRIGGER"							, 0,			70,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT,		ANIM_STAND,	ANIM_STAND, -1,

	// MONSTER MELT
	"MONSTERMELT"							, 0,			80,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_NONINTERRUPT | ANIM_HITFINISH | ANIM_NOMOVE_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_ATTACK,				ANIM_PRONE, ANIM_PRONE,	-1,

	"MERC INJURED IDLE ANIM"	, 0,			110,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_MERCIDLE | ANIM_NOCHANGE_WEAPON | ANIM_NO_EFFORT,														ANIM_STAND, ANIM_STAND,	-1,

	// INJURED TRANSITION
	"END INJURED WALK"					, 0,			80,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_NOMOVE_MARKER | ANIM_MIN_EFFORT | ANIM_NOCHANGE_WEAPON,															ANIM_STAND, ANIM_STAND,	-1,

	//PASS OBJECT
	"PASS OBJECT"							, 0,			110,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT	| ANIM_ATTACK ,		ANIM_STAND,	ANIM_STAND, -1,

	//ADJACENT DROP OBJECT
	"ADJACENT DROP OBJECT"		, 0,			110,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT	| ANIM_ATTACK ,		ANIM_STAND,	ANIM_STAND, -1,

	// READY_RIFLE_PRONE
	"READY AIM (DW) PRONE"	, 0,			150,	(FLOAT)0,	ANIM_NORESTART | ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN	| ANIM_LIGHT_EFFORT,										ANIM_PRONE,	ANIM_PRONE, -1,

	// AIM_RIFLE_PRONE
	"AIM (DW) PRONE"				, 0,			250,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_FIREREADY | ANIM_FASTTURN | ANIM_LIGHT_EFFORT,	ANIM_PRONE, ANIM_PRONE,	-1,

	// SHOOT_RIFLE_PRONE
	"SHOOT (DW) PRONE"			, 0,			150,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_LIGHT_EFFORT | ANIM_FIRE | ANIM_ATTACK,										ANIM_PRONE,	ANIM_PRONE, -1,

	// END_RIFLE_PRONE
	"END DUAL PRONE"			, 0,			150,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_NOCHANGE_PENDINGCOUNT | ANIM_LIGHT_EFFORT,										ANIM_PRONE, ANIM_PRONE,	-1,

	// UNJAM PRONE DWEL
	"UNJAM PRONE DWEL"					, 0,			150,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NOCHANGE_WEAPON | ANIM_MIN_EFFORT	| ANIM_ATTACK,			ANIM_PRONE,	ANIM_PRONE, -1,

	//PICK LOCK
	"PICK LOCK"							, 0,			70,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT | ANIM_ATTACK,		ANIM_STAND,	ANIM_STAND, -1,

	//OPEN DOOR CROUCHED
	"OPEN DOOR CROUCHED"		, 0,			70,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT,		ANIM_CROUCH,	ANIM_CROUCH, -1,

	//BEGIN OPENSTRUCT CROUCHED
	"BEGIN OPEN STRUCT CROUCHED"		, 0,			70,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT,		ANIM_CROUCH,	ANIM_CROUCH, -1,

	//CLOSE DOOR CROUCHED
	"CLOSE DOOR CROUCHED"		, 0,			70,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT,		ANIM_CROUCH,	ANIM_CROUCH, -1,

	//OPEN STRUCT CROUCHED
	"OPEN STRUCT CROUCHED"		, 0,			70,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT,		ANIM_CROUCH,	ANIM_CROUCH, -1,

	//END OPEN DOOR CROUCHED
	"END OPEN DOOR CROUCHED"		, 0,			70,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT,		ANIM_CROUCH,	ANIM_CROUCH, -1,

	//END OPENSTRUCT CROUCHED
	"END OPENSTRUCT CROUCHED"		, 0,			70,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT,		ANIM_CROUCH,	ANIM_CROUCH, -1,

	//END OPEN LOCKED DOOR CROUCHED
	"END OPNE LOCKED DOOR CR"		, 0,			70,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT,		ANIM_CROUCH,	ANIM_CROUCH, -1,

	//END OPEN STRUCT LOCKED CR
	"END OPEN STRUCT LOCKED CR"		, 0,			70,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT,		ANIM_CROUCH,	ANIM_CROUCH, -1,

	"DRUNK IDLE"									, 0,			170,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_MERCIDLE | ANIM_NOCHANGE_WEAPON | ANIM_NO_EFFORT,										ANIM_STAND, ANIM_STAND,	-1,

	// CROWBAR
	"CROWBAR"										, 0,				70,		(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_NO_EFFORT	| ANIM_NOCHANGE_WEAPON | ANIM_NORESTART | ANIM_ATTACK,									ANIM_STAND,		ANIM_STAND, -1,

	// COWER HIT ANIMATION
	"COWER HIT"					, 0,			80,	(FLOAT)1.6,	ANIM_HITSTART | ANIM_HITFINISH | ANIM_NONINTERRUPT | ANIM_NOSHOW_MARKER | ANIM_NO_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_IGNORE_AUTOSTANCE | ANIM_ATTACK,	ANIM_CROUCH, ANIM_CROUCH,	-1,

	// BLOODCAT WALK BACKWARDS
	"BLOODCAT WALKING BACKWARDS", 0 ,			30,	(FLOAT)1.2,		ANIM_MOVING | ANIM_TURNING | ANIM_NORESTART | ANIM_LIGHT_EFFORT | ANIM_NOCHANGE_WEAPON,																ANIM_STAND,			ANIM_STAND,	-1,

	// CREATURE WALK BACKWARDS
	"MONSTER WALKING BACKWARDS", 0 ,			30,	(FLOAT)2.5,		ANIM_MOVING | ANIM_TURNING | ANIM_NORESTART | ANIM_LIGHT_EFFORT | ANIM_NOCHANGE_WEAPON,																ANIM_STAND,			ANIM_STAND,	-1,

	// KID SKIPPING
	"KID SKIPPING", 0 ,					70,	(FLOAT)2.0,		ANIM_MOVING | ANIM_TURNING | ANIM_NORESTART | ANIM_LIGHT_EFFORT | ANIM_NOCHANGE_WEAPON,																ANIM_STAND,			ANIM_STAND,	-1,

	// STAND BURST // Lesh: AniDelay, speed=0 for control it
	"STAND BURST SHOOT"		, 0,			0,	(FLOAT)0,	ANIM_NORESTART | ANIM_STATIONARY | ANIM_TURNING | ANIM_RAISE_WEAPON | ANIM_LIGHT_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_FIRE | ANIM_ATTACK,														ANIM_STAND, ANIM_STAND,	-1,

	//Attach string
	"Attach String"			, 0,			70,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT | ANIM_ATTACK,		ANIM_CROUCH,	ANIM_CROUCH, -1,

	//SWAT BACKWARDS
	"SWAT BACKWARDS"			, 0,			110, (FLOAT)1.4,	ANIM_MOVING | ANIM_NORESTART | ANIM_LIGHT_EFFORT | ANIM_TURNING,			ANIM_CROUCH,	ANIM_CROUCH, -1,

	//JUMP OVER BLOCKING PERSON
	"JUMP OVER"			, 0,			110, (FLOAT)3.6,	ANIM_SPECIALMOVE | ANIM_NORESTART | ANIM_LOWER_WEAPON | ANIM_MODERATE_EFFORT | ANIM_TURNING | ANIM_ATTACK,			ANIM_STAND,	ANIM_STAND, -1,

	//REFUEL VEHICLE
	"REFUEL VEHICLE"			, 0,			70,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT,		ANIM_CROUCH,	ANIM_CROUCH, -1,

	//Robot camera not moving
	"ROBOT CAMERA"					, 0,			0,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_RAISE_WEAPON | ANIM_VARIABLE_EFFORT	| ANIM_BREATH,		ANIM_STAND,	ANIM_STAND, -1,

	//CRIPPLE OPEN DOOR
	"CRIPPLE OPEN DOOR"			, 0,			70,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LIGHT_EFFORT,		ANIM_STAND,	ANIM_STAND, -1,

	//CRIPPLE CLOSE DOOR
	"CRIPPLE CLOSE DOOR"		, 0,			100,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_MIN_EFFORT,		ANIM_STAND,	ANIM_STAND, -1,

	//CRIPPLE END OPEN DOOR
	"END OPEN DOOR"							, 0,			100,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART	| ANIM_MIN_EFFORT,		ANIM_STAND,	ANIM_STAND, -1,

	//CRIPPLE END OPEN LOCKED DOOR
	"END OPEN LOCKED DOOR"			, 0,			100,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_MIN_EFFORT,		ANIM_STAND,	ANIM_STAND, -1,

	//CROUCH PICK LOCK
	"CROUCH PICK LOCK"							, 0,			70,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT,		ANIM_CROUCH,	ANIM_CROUCH, -1,

	//<SB> crouch throwing
	"THROW ITEM CROUCHED",	0,	80,	(FLOAT)0,	ANIM_STATIONARY	| ANIM_NOMOVE_MARKER | ANIM_NONINTERRUPT | ANIM_MIN_EFFORT | ANIM_ATTACK,	ANIM_CROUCH,	ANIM_CROUCH, -1,
	//</SB
	//ddd
		// BIG GUY with stone
	"BIG GUY STONE" , 0, 180, (FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_MERCIDLE | ANIM_NO_EFFORT, ANIM_STAND, ANIM_STAND,	-1,
	"SHOOT ROCKET CROUCHED" , 0,110,(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LIGHT_EFFORT	| ANIM_ATTACK ,		ANIM_CROUCH,	ANIM_CROUCH, -1,
	//"SWAT with knife"		,0,	0,	(FLOAT)2.2, ANIM_MOVING | ANIM_TURNING	| ANIM_NORESTART | ANIM_RAISE_WEAPON | ANIM_LIGHT_EFFORT,	ANIM_CROUCH, ANIM_CROUCH, -1,
	"SWAT with knife"		,0,	0,	(FLOAT)2.2, ANIM_MOVING | ANIM_NORESTART | ANIM_LIGHT_EFFORT | ANIM_TURNING, ANIM_CROUCH, ANIM_CROUCH, -1,
	"SWAT BACKWARDS with knife"	,  0, 110, (FLOAT)1.4, ANIM_MOVING | ANIM_NORESTART | ANIM_LIGHT_EFFORT | ANIM_TURNING, ANIM_CROUCH, ANIM_CROUCH, -1,
	"SWAT BACKWARDS with nothing", 0, 110, (FLOAT)1.4, ANIM_MOVING | ANIM_NORESTART | ANIM_LIGHT_EFFORT | ANIM_TURNING, ANIM_CROUCH, ANIM_CROUCH, -1,
	
	//THROW gren
	{"THROW GRENADE"	, 0,80, (FLOAT)0,	ANIM_STATIONARY	| ANIM_NOMOVE_MARKER | ANIM_NONINTERRUPT | ANIM_MIN_EFFORT	| ANIM_ATTACK ,		ANIM_STAND, ANIM_STAND, -1},
	//LOB gren
	{"LOB GRENADE"						, 0,		80,	 (FLOAT)0,		ANIM_STATIONARY	| ANIM_NOMOVE_MARKER | ANIM_NONINTERRUPT | ANIM_MIN_EFFORT	| ANIM_ATTACK ,		ANIM_STAND, ANIM_STAND, -1},

	//ROLL PRONE LEFT
	{"ROLL PRONE LEFT"			, 0,			80, (FLOAT)0.8 /*1.1*/, ANIM_MOVING | ANIM_NORESTART | ANIM_RAISE_WEAPON | ANIM_VARIABLE_EFFORT,	ANIM_PRONE,	ANIM_PRONE, -1},

	//ROLL PRONE RIGHT
	{"ROLL PRONE RIGHT"			, 0,			80, (FLOAT)0.8 /*1.1*/, ANIM_MOVING | ANIM_NORESTART | ANIM_RAISE_WEAPON | ANIM_VARIABLE_EFFORT,	ANIM_PRONE,	ANIM_PRONE, -1},
	
	// JUMPUPWALL
	{"JUMPUPWALL"						, 0,			30,	(FLOAT)0,		ANIM_NONINTERRUPT | ANIM_NORESTART | ANIM_STATIONARY | ANIM_NOSHOW_MARKER | ANIM_MODERATE_EFFORT | ANIM_LOWER_WEAPON, ANIM_STAND, ANIM_CROUCH,	-1},

	//JUMPDOWNWALL
	{"JUMPDOWNWALL"				, 0,		30,	 (FLOAT)0,		ANIM_NONINTERRUPT | ANIM_NORESTART | ANIM_STATIONARY | ANIM_NOSHOW_MARKER | ANIM_MODERATE_EFFORT | ANIM_LOWER_WEAPON, ANIM_CROUCH, ANIM_STAND,	-1},

	{"JUMP WINDOWS"								, 0,			50,	(FLOAT)0,		ANIM_NOCHANGE_PENDINGCOUNT | ANIM_NORESTART | ANIM_STATIONARY | ANIM_NOSHOW_MARKER | ANIM_MODERATE_EFFORT | ANIM_LOWER_WEAPON | ANIM_NONINTERRUPT, ANIM_STAND, ANIM_CROUCH,	-1},

	//SPECIAL THROW KNIFE FOR BIG MALES
	"THROW KNIFE 2"									, 0,		50,	 (FLOAT)0,		ANIM_STATIONARY	| ANIM_NOMOVE_MARKER | ANIM_NONINTERRUPT | ANIM_MIN_EFFORT	| ANIM_ATTACK ,		ANIM_STAND, ANIM_STAND, -1,

	//RUN (with pistol)
	{"RUN WITH PISTOL"									, 0,		0,			(FLOAT)2.6, ANIM_MOVING | ANIM_TURNING	| ANIM_NORESTART | ANIM_RAISE_WEAPON | ANIM_MODERATE_EFFORT,	ANIM_STAND, ANIM_STAND, -1},

	//SIDE STEPPING WITH READIED WEAPON
	"SIDE STEPPING WITH RIFLE RDY"			, 0,			50, (FLOAT)0.4, ANIM_MOVING | ANIM_NORESTART | ANIM_FIREREADY | ANIM_RAISE_WEAPON | ANIM_VARIABLE_EFFORT,			ANIM_STAND,	ANIM_STAND, -1,
	"SIDE STEPPING WITH DUAL RDY"			, 0,			50, (FLOAT)0.4, ANIM_MOVING | ANIM_NORESTART | ANIM_FIREREADY | ANIM_RAISE_WEAPON | ANIM_VARIABLE_EFFORT,			ANIM_STAND,	ANIM_STAND, -1,

	//WALKING WITH READIED WEAPON
	{"WALKING WITH RIFLE RDY"							, 20,			0, (FLOAT)1.6, ANIM_MOVING | ANIM_TURNING | ANIM_NORESTART | ANIM_FIREREADY | ANIM_RAISE_WEAPON | ANIM_VARIABLE_EFFORT,			ANIM_STAND,	ANIM_STAND, -1},
	{"WALKING WITH DUAL RDY"							, 20,			0, (FLOAT)1.6, ANIM_MOVING | ANIM_TURNING | ANIM_NORESTART | ANIM_FIREREADY | ANIM_RAISE_WEAPON | ANIM_VARIABLE_EFFORT,			ANIM_STAND,	ANIM_STAND, -1},

	//GIVING AID WHILE PRONE
	{"PRN START AID"							, 0,			90,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_NONINTERRUPT | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT	,		ANIM_PRONE,	ANIM_PRONE, -1},
	{"PRN GIVING AID"							, 0,			120,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LIGHT_EFFORT	,		ANIM_PRONE,	ANIM_PRONE, -1},
	{"PRN END AID"							, 0,			90,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_RAISE_WEAPON | ANIM_NO_EFFORT	| ANIM_NOCHANGE_PENDINGCOUNT,		ANIM_PRONE,	ANIM_PRONE, -1},

	//GET ADJACENT ITEM CROUCHED
	"GET ADJACENT ITEM CROUCHED"					, 0,			100,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT,		ANIM_CROUCH,	ANIM_CROUCH, -1,
	//STEAL ITEM CROUCHED
	"STEAL ITEM CROUCHED"					, 0,			100,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LOWER_WEAPON | ANIM_LIGHT_EFFORT,		ANIM_CROUCH,	ANIM_CROUCH, -1,

	// STAND BURST DUAL
	{"STAND BURST DUAL"		, 0,			0,	(FLOAT)0,	ANIM_NORESTART | ANIM_STATIONARY | ANIM_TURNING | ANIM_RAISE_WEAPON | ANIM_LIGHT_EFFORT | ANIM_FIRE | ANIM_ATTACK,														ANIM_STAND, ANIM_STAND,	-1},
	// CROUCH BURST DUAL
	{"CROUCH BURST DUAL"		, 0,			0,	(FLOAT)0,	ANIM_NORESTART | ANIM_STATIONARY | ANIM_TURNING | ANIM_RAISE_WEAPON | ANIM_LIGHT_EFFORT | ANIM_FIRE | ANIM_ATTACK,														ANIM_CROUCH, ANIM_CROUCH,	-1},
	// PRONE BURST DUAL
	{"PRONE BURST DUAL"		, 0,			0,	(FLOAT)0,	ANIM_NORESTART | ANIM_STATIONARY | ANIM_TURNING | ANIM_RAISE_WEAPON | ANIM_LIGHT_EFFORT | ANIM_FIRE | ANIM_ATTACK,														ANIM_PRONE, ANIM_PRONE,	-1},

	// firing from hip animations
	{"ALTERNATIVE READY"			, 0,			100,	(FLOAT)0,	ANIM_OK_CHARGE_AP_FOR_TURN | ANIM_NORESTART | ANIM_STATIONARY | ANIM_TURNING | ANIM_ALT_WEAPON_HOLDING | ANIM_FASTTURN | ANIM_RAISE_WEAPON | ANIM_MIN_EFFORT ,				ANIM_STAND,	ANIM_STAND, -1},
	{"ALTERNATIVE AIM"				, 0,			250,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_ALT_WEAPON_HOLDING | ANIM_FIREREADY | ANIM_FASTTURN | ANIM_RAISE_WEAPON | ANIM_LIGHT_EFFORT,											ANIM_STAND, ANIM_STAND,	-1},
	{"ALTERNATIVE SHOOT"			, 0,			100,	(FLOAT)0,	ANIM_NORESTART | ANIM_STATIONARY | ANIM_TURNING | ANIM_ALT_WEAPON_HOLDING | ANIM_RAISE_WEAPON | ANIM_LIGHT_EFFORT | ANIM_FIRE | ANIM_RT_NONINTERRUPT | ANIM_ATTACK,			ANIM_STAND,	ANIM_STAND, -1},
	{"ALTERNATIVE BURST"			, 0,			0,		(FLOAT)0,	ANIM_NORESTART | ANIM_STATIONARY | ANIM_TURNING | ANIM_ALT_WEAPON_HOLDING | ANIM_RAISE_WEAPON | ANIM_LIGHT_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_FIRE | ANIM_ATTACK,			ANIM_STAND, ANIM_STAND,	-1},
	{"ALTERNATIVE LOW"				, 0,			100,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_ALT_WEAPON_HOLDING | ANIM_RAISE_WEAPON | ANIM_LIGHT_EFFORT | ANIM_FIRE | ANIM_ATTACK,													ANIM_STAND,	ANIM_STAND, -1},
	{"ALTERNATIVE LOW BURST"		, 0,			0,		(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_ALT_WEAPON_HOLDING | ANIM_RAISE_WEAPON | ANIM_LIGHT_EFFORT | ANIM_FIRE | ANIM_ATTACK,													ANIM_STAND,	ANIM_STAND, -1},
	{"ALTERNATIVE UNREADY"			, 0,			80,		(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_ALT_WEAPON_HOLDING | ANIM_RAISE_WEAPON | ANIM_NOCHANGE_PENDINGCOUNT | ANIM_MIN_EFFORT,												ANIM_STAND, ANIM_STAND,	-1},
	{"ALTERNATIVE UNJAM"			, 0,			150,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_ALT_WEAPON_HOLDING | ANIM_FASTTURN | ANIM_NOCHANGE_WEAPON | ANIM_MIN_EFFORT	| ANIM_ATTACK,											ANIM_STAND,	ANIM_STAND, -1},
	{"ALTERNATIVE LOW UNJAM"		, 0,			150,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_ALT_WEAPON_HOLDING | ANIM_FASTTURN | ANIM_NOCHANGE_WEAPON | ANIM_MIN_EFFORT	| ANIM_ATTACK,											ANIM_STAND,	ANIM_STAND, -1},
	{"ALTERNATIVE WALKING"			, 20,			0,		(FLOAT)1.6, ANIM_MOVING | ANIM_TURNING | ANIM_ALT_WEAPON_HOLDING | ANIM_NORESTART | ANIM_FIREREADY | ANIM_RAISE_WEAPON | ANIM_VARIABLE_EFFORT,											ANIM_STAND,	ANIM_STAND, -1},
	{"ALTERNATIVE SIDE STEP"		, 0,			50,		(FLOAT)0.4, ANIM_MOVING | ANIM_NORESTART | ANIM_ALT_WEAPON_HOLDING | ANIM_FIREREADY | ANIM_RAISE_WEAPON | ANIM_VARIABLE_EFFORT,															ANIM_STAND,	ANIM_STAND, -1},

	//COWER CROUCHED
	{"COWER CROUCHED"					, 0,			150,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LIGHT_EFFORT | ANIM_NOCHANGE_WEAPON | ANIM_NONINTERRUPT,		ANIM_CROUCH,	ANIM_CROUCH, -1},
	//END COWER CROUCHED
	{"END COWER CROUCHED"				, 0,			150,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_LIGHT_EFFORT | ANIM_NOCHANGE_WEAPON,		ANIM_CROUCH,	ANIM_CROUCH, -1},
	//COWER PRONE
	{"START COWER PRONE"					, 0,			150,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_MIN_EFFORT	| ANIM_NOCHANGE_WEAPON | ANIM_NONINTERRUPT,		ANIM_PRONE,	ANIM_PRONE, -1},
	//COWER PRONE
	{"COWER PRONE"						, 0,			150,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_MIN_EFFORT	| ANIM_NOCHANGE_WEAPON,		ANIM_PRONE,	ANIM_PRONE, -1},
	//END COWER PRONE
	{"End COWER PRONE"					, 0,			150,			(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_FASTTURN | ANIM_NORESTART | ANIM_MIN_EFFORT	| ANIM_NOCHANGE_WEAPON,		ANIM_PRONE,	ANIM_PRONE, -1},

	{"BIGMERC IDLE NECK 2"				, 0,			110,	(FLOAT)0,	ANIM_STATIONARY | ANIM_TURNING | ANIM_MERCIDLE | ANIM_NOCHANGE_WEAPON | ANIM_NO_EFFORT,														ANIM_STAND, ANIM_STAND,	-1},

	{"FOCUSED PUNCH"					, 0,			40,		(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_NONINTERRUPT | ANIM_MODERATE_EFFORT	| ANIM_NOCHANGE_WEAPON | ANIM_NORESTART | ANIM_ATTACK,		ANIM_STAND,		ANIM_STAND, -1},
	{"FOCUSED STAB"						, 0,			40,		(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_NONINTERRUPT | ANIM_MODERATE_EFFORT	| ANIM_NOCHANGE_WEAPON | ANIM_NORESTART | ANIM_ATTACK,		ANIM_STAND,		ANIM_STAND, -1},
	{"HTH KICK"							, 0,			70,		(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_NONINTERRUPT | ANIM_MODERATE_EFFORT	| ANIM_NOCHANGE_WEAPON | ANIM_NORESTART | ANIM_ATTACK,		ANIM_STAND,		ANIM_STAND, -1},
	{"FOCUSED HTH KICK"					, 0,			40,		(FLOAT)0, ANIM_STATIONARY | ANIM_TURNING | ANIM_NONINTERRUPT | ANIM_MODERATE_EFFORT	| ANIM_NOCHANGE_WEAPON | ANIM_NORESTART | ANIM_ATTACK,		ANIM_STAND,		ANIM_STAND, -1},

	// LONG JUMP 
	"LONG JUMP"					, 0,			100, (FLOAT)3.4,	ANIM_SPECIALMOVE | ANIM_NORESTART | ANIM_LOWER_WEAPON | ANIM_MODERATE_EFFORT | ANIM_TURNING,			ANIM_STAND,	ANIM_STAND, -1,

};

ANI_SPEED_DEF gubAnimWalkSpeeds[ TOTALBODYTYPES ] =
{
	-5,(FLOAT)1.6,				//REGMALE
	-10,(FLOAT)1.6,				//BIGMALE
	-5,(FLOAT)1.6,				//STOCKYMALE
	-15,(FLOAT)1.6,				//REGFEMALE
	0,	(FLOAT)1.6,				//ADULTMONSTER
	0,	(FLOAT)1.6,				//ADULTMONSTER
	0,	(FLOAT)1.6,				//ADULTMONSTER
	0,	(FLOAT)1.6,				//ADULTMONSTER
	0,	(FLOAT)1.6,				//ADULTMONSTER
	0,	(FLOAT)2.2,				//INFANT
	0,	(FLOAT)1.6,				//QUEEN MONSTER
	40, (FLOAT)1.3,				//FATCIV
	10, (FLOAT)1.3,				//MANCIV
	-10,(FLOAT)1.3,				//MINICIV
	-10,(FLOAT)1.3,				//DRESSCIV
	-20,(FLOAT)1.6,				//HAT KID
	-20,(FLOAT)1.6,				//NOHAT KID
	-20,(FLOAT)1.6,				//CRIPPLE
	60, (FLOAT)0.9,				//COW
	20, (FLOAT)1.6,				//CROW
	0, (FLOAT)1.2,				//BLOOD CAT
	20, (FLOAT)1.1,				//ROBOT1
	-10, (FLOAT)4.0,			//HUMVEE

	-10, (FLOAT)4.0,			//TANK_NW
	-10, (FLOAT)4.0,			//TANK_NE
	-10, (FLOAT)4.0,			//ELDORADO
	-10, (FLOAT)4.0,			//ICECREAMTRUCK
	-10, (FLOAT)4.0,			//JEEP
};

extern INT16 gubMaxActionPoints[TOTALBODYTYPES] = {0};
/*
UINT8 gubMaxActionPoints[ TOTALBODYTYPES ] =
{
	APBPConstants[AP_MAXIMUM],				//REGMALE
	APBPConstants[AP_MAXIMUM],				//BIGMALE
	APBPConstants[AP_MAXIMUM],				//STOCKYMALE
	APBPConstants[AP_MAXIMUM],				//REGFEMALE
	APBPConstants[AP_MONSTER_MAXIMUM],				//ADULTMONSTER
	APBPConstants[AP_MONSTER_MAXIMUM],				//ADULTMONSTER
	APBPConstants[AP_MONSTER_MAXIMUM],				//ADULTMONSTER
	APBPConstants[AP_MONSTER_MAXIMUM],				//ADULTMONSTER
	APBPConstants[AP_MONSTER_MAXIMUM],				//ADULTMONSTER
	APBPConstants[AP_MONSTER_MAXIMUM],				//INFANT
	APBPConstants[AP_MONSTER_MAXIMUM],				//QUEEN MONSTER
	APBPConstants[AP_MAXIMUM],							//FATCIV
	APBPConstants[AP_MAXIMUM],				//MANCIV
	APBPConstants[AP_MAXIMUM],				//MINICIV
	APBPConstants[AP_MAXIMUM],				//DRESSCIV
	APBPConstants[AP_MAXIMUM],				//HAT KID
	APBPConstants[AP_MAXIMUM],				//NOHAT KID
	APBPConstants[AP_MAXIMUM],				//CRIPPLE
	APBPConstants[AP_MAXIMUM],				//COW
	APBPConstants[AP_MAXIMUM],				//CROW
	APBPConstants[AP_MAXIMUM],				//BLOOD CAT
	APBPConstants[AP_MAXIMUM],				// ROBOT1
	APBPConstants[AP_VEHICLE_MAXIMUM],				//HUMVEE
	APBPConstants[AP_VEHICLE_MAXIMUM],				//TANK1
	APBPConstants[AP_VEHICLE_MAXIMUM],				//TANK2
	APBPConstants[AP_VEHICLE_MAXIMUM],				//ELDORADO
	APBPConstants[AP_VEHICLE_MAXIMUM],				//ICECREAMTRUCK
	APBPConstants[AP_VEHICLE_MAXIMUM],				//JEEP
};
*/

ANI_SPEED_DEF gubAnimRunSpeeds[ TOTALBODYTYPES ] =
{
	0,	(FLOAT)2.6,					//REGMALE
	5,		(FLOAT)2.6,				//BIGMALE
	0,		(FLOAT)2.6,				//STOCKYMALE
	-10,	(FLOAT)2.6,				//REGFEMALE
	0,		(FLOAT)2.6,				//ADULTMONSTER
	0,		(FLOAT)2.6,				//ADULTMONSTER
	0,		(FLOAT)2.6,				//ADULTMONSTER
	0,		(FLOAT)2.6,				//ADULTMONSTER
	0,		(FLOAT)2.6,				//ADULTMONSTER
	0,		(FLOAT)2.6,				//ADULTMONSTER
	0,		(FLOAT)2.8,				//INFANT
	10,		(FLOAT)2.3,				//FATCIV
	-10,		(FLOAT)2.3,				//MANCIV
	-20,	(FLOAT)2.3,				//MINICIV
	-30,	(FLOAT)2.3,				//DRESSCIV
	-40,	(FLOAT)2.6,				//HAT KID
	-40,	(FLOAT)2.6,				//NOHAT KID
	-20,	(FLOAT)2.3,				//CRIPPLE
	30,		(FLOAT)2.0,				//COW
};


// Really only the first mercs are using any of these values....
ANI_SPEED_DEF gubAnimSwatSpeeds[ TOTALBODYTYPES ] =
{
	0,	(FLOAT)2.2,				//REGMALE
	20, (FLOAT)2.2,				//BIGMALE
	0,	(FLOAT)2.2,				//STOCKYMALE
	-10,(FLOAT)2.2,				//REGFEMALE
};

// Really only the first mercs are using any of these values....
ANI_SPEED_DEF gubAnimCrawlingSpeeds[ TOTALBODYTYPES ] =
{
	0,	(FLOAT)0.8,				//REGMALE
	20, (FLOAT)0.8,				//BIGMALE
	0,	(FLOAT)0.8,				//STOCKYMALE
	-10,(FLOAT)0.8,				//REGFEMALE
};


UINT16 gusNothingBreath[ ] =
{
	RGMNOTHING_STD,
	BGMNOTHING_STD,
	RGMNOTHING_STD,
	RGFNOTHING_STD,
};


UINT16 gubAnimSurfaceIndex[ TOTALBODYTYPES ][ NUMANIMATIONSTATES ];
UINT16 gubAnimSurfaceMidWaterSubIndex[ TOTALBODYTYPES ][ NUMANIMATIONSTATES ][2];
UINT16 gubAnimSurfaceItemSubIndex[ TOTALBODYTYPES ][ NUMANIMATIONSTATES ];
UINT16 gubAnimSurfaceCorpseID[ TOTALBODYTYPES ][ NUMANIMATIONSTATES ];


ANIMSUBTYPE gRifleInjuredSub[] =
{
	WALKING,	RGMHURTWALKINGR,	BGMHURTWALKINGR,	RGMHURTWALKINGR,	RGFHURTWALKINGR,
};

ANIMSUBTYPE gNothingInjuredSub[] =
{
	WALKING,	RGMHURTWALKINGN,	BGMHURTWALKINGN,	RGMHURTWALKINGN,	RGFHURTWALKINGN,
};

ANIMSUBTYPE gDoubleHandledSub =
{
	STANDING, RGMDBLBREATH,			BGMDBLBREATH,			RGMDBLBREATH,			RGFDBLBREATH
};

void	InitAnimationSurfacesPerBodytype( )
{
	INT32 cnt1, cnt2;

	// Should be set to a non-init values
	for ( cnt1 = 0; cnt1 < TOTALBODYTYPES; cnt1 ++ )
	{
		for ( cnt2 = 0; cnt2 < NUMANIMATIONSTATES; cnt2 ++ )
		{
			gubAnimSurfaceIndex[ cnt1][ cnt2 ] = INVALID_ANIMATION;
			gubAnimSurfaceItemSubIndex[ cnt1][ cnt2 ] = INVALID_ANIMATION;
			gubAnimSurfaceMidWaterSubIndex[ cnt1][ cnt2 ][ 0 ] = INVALID_ANIMATION;
			gubAnimSurfaceMidWaterSubIndex[ cnt1][ cnt2 ][ 1 ] = INVALID_ANIMATION;
			gubAnimSurfaceCorpseID[ cnt1][ cnt2 ] = NO_CORPSE;
		}
	}
	memset( gRandomAnimDefs, 0, sizeof( gRandomAnimDefs ) );


	// REGULAR MALE GUY
	gubAnimSurfaceIndex[ REGMALE ][ WALKING ]								= RGMBASICWALKING;
	gubAnimSurfaceIndex[ REGMALE ][ STANDING ]							= RGMSTANDING;
	gubAnimSurfaceIndex[ REGMALE ][ KNEEL_DOWN ]						= RGMCROUCHING;
	gubAnimSurfaceIndex[ REGMALE ][ CROUCHING ]							= RGMCROUCHING;
	gubAnimSurfaceIndex[ REGMALE ][ KNEEL_UP ]							= RGMCROUCHING;
	gubAnimSurfaceIndex[ REGMALE ][ SWATTING ]							= RGMSNEAKING;
	gubAnimSurfaceIndex[ REGMALE ][ RUNNING ]								= RGMRUNNING;
	gubAnimSurfaceIndex[ REGMALE ][ PRONE_DOWN ]						= RGMPRONE;
	gubAnimSurfaceIndex[ REGMALE ][ CRAWLING ]							= RGMPRONE;
	gubAnimSurfaceIndex[ REGMALE ][ PRONE_UP ]							= RGMPRONE;
	gubAnimSurfaceIndex[ REGMALE ][ PRONE ]									= RGMPRONE;
	gubAnimSurfaceIndex[ REGMALE ][ READY_RIFLE_STAND ]			= RGMSTANDAIM;
	gubAnimSurfaceIndex[ REGMALE ][ AIM_RIFLE_STAND ]				= RGMSTANDAIM;
	gubAnimSurfaceIndex[ REGMALE ][ SHOOT_RIFLE_STAND ]			= RGMSTANDAIM;
	gubAnimSurfaceIndex[ REGMALE ][ END_RIFLE_STAND ]				= RGMSTANDAIM;
	gubAnimSurfaceIndex[ REGMALE ][ START_SWAT ]						= RGMSNEAKING;
	gubAnimSurfaceIndex[ REGMALE ][ END_SWAT ]							= RGMSNEAKING;
	gubAnimSurfaceIndex[ REGMALE ][ FLYBACK_HIT ]						= RGMHITHARD;
	gubAnimSurfaceIndex[ REGMALE ][ READY_RIFLE_PRONE ]			= RGMPRONE;
	gubAnimSurfaceIndex[ REGMALE ][ AIM_RIFLE_PRONE ]				= RGMPRONE;
	gubAnimSurfaceIndex[ REGMALE ][ SHOOT_RIFLE_PRONE ]			= RGMPRONE;
	gubAnimSurfaceIndex[ REGMALE ][ END_RIFLE_PRONE ]				= RGMPRONE;
	gubAnimSurfaceIndex[ REGMALE ][ FALLBACK_DEATHTWICH ]		= RGMHITHARD;
	gubAnimSurfaceIndex[ REGMALE ][ GENERIC_HIT_STAND ]			= RGMHITSTAND;
	gubAnimSurfaceIndex[ REGMALE ][ FLYBACK_HIT_BLOOD_STAND ]		= RGMHITHARDBLOOD;
	gubAnimSurfaceIndex[ REGMALE ][ FLYBACK_HIT_DEATH ]			= RGMHITHARD;
	gubAnimSurfaceIndex[ REGMALE ][ READY_RIFLE_CROUCH ]		= RGMCROUCHAIM;
	gubAnimSurfaceIndex[ REGMALE ][ AIM_RIFLE_CROUCH ]			= RGMCROUCHAIM;
	gubAnimSurfaceIndex[ REGMALE ][ SHOOT_RIFLE_CROUCH ]		= RGMCROUCHAIM;
	gubAnimSurfaceIndex[ REGMALE ][ END_RIFLE_CROUCH ]			= RGMCROUCHAIM;
	gubAnimSurfaceIndex[ REGMALE ][ FALLBACK_HIT_STAND ]		= RGMHITFALLBACK;
	gubAnimSurfaceIndex[ REGMALE ][ ROLLOVER ]							= RGMROLLOVER;
	gubAnimSurfaceIndex[ REGMALE ][ CLIMBUPROOF ]						= RGMCLIMBROOF;
	gubAnimSurfaceIndex[ REGMALE ][ FALLOFF ]								= RGMFALL;
	gubAnimSurfaceIndex[ REGMALE ][ GETUP_FROM_ROLLOVER ]		= RGMPRONE;
	gubAnimSurfaceIndex[ REGMALE ][ CLIMBDOWNROOF ]					= RGMCLIMBROOF;
	gubAnimSurfaceIndex[ REGMALE ][ FALLFORWARD_ROOF ]			= RGMFALLF;
	gubAnimSurfaceIndex[ REGMALE ][ GENERIC_HIT_DEATHTWITCHNB ]		= RGMHITSTAND;
	gubAnimSurfaceIndex[ REGMALE ][ GENERIC_HIT_DEATHTWITCHB ]		= RGMHITSTAND;
	gubAnimSurfaceIndex[ REGMALE ][ FALLBACK_HIT_DEATHTWITCHNB ]	= RGMHITFALLBACK;
	gubAnimSurfaceIndex[ REGMALE ][ FALLBACK_HIT_DEATHTWITCHB ]		= RGMHITFALLBACK;
	gubAnimSurfaceIndex[ REGMALE ][ GENERIC_HIT_DEATH ]			= RGMHITSTAND;
	gubAnimSurfaceIndex[ REGMALE ][ FALLBACK_HIT_DEATH ]		= RGMHITFALLBACK;
	gubAnimSurfaceIndex[ REGMALE ][ GENERIC_HIT_CROUCH ]		= RGMHITCROUCH;
	gubAnimSurfaceIndex[ REGMALE ][ STANDING_BURST ]				= RGMSTANDAIM;
	gubAnimSurfaceIndex[ REGMALE ][ STANDING_BURST_HIT ]		= RGMHITHARD;
	gubAnimSurfaceIndex[ REGMALE ][ GENERIC_HIT_DEATH ]			= RGMHITSTAND;
	gubAnimSurfaceIndex[ REGMALE ][ FALLFORWARD_FROMHIT_STAND ]		= RGMHITSTAND;
	gubAnimSurfaceIndex[ REGMALE ][ FALLFORWARD_FROMHIT_STAND ]				= RGMHITSTAND;
	gubAnimSurfaceIndex[ REGMALE ][ FALLFORWARD_FROMHIT_CROUCH ]			= RGMHITCROUCH;
	gubAnimSurfaceIndex[ REGMALE ][ ENDFALLFORWARD_FROMHIT_CROUCH ]		= RGMHITSTAND;
	gubAnimSurfaceIndex[ REGMALE ][ GENERIC_HIT_PRONE ]			= RGMHITPRONE;
	gubAnimSurfaceIndex[ REGMALE ][ PRONE_HIT_DEATH ]				= RGMHITPRONE;
	gubAnimSurfaceIndex[ REGMALE ][ PRONE_LAY_FROMHIT ]			= RGMHITPRONE;
	gubAnimSurfaceIndex[ REGMALE ][ PRONE_HIT_DEATHTWITCHNB ]					= RGMHITPRONE;
	gubAnimSurfaceIndex[ REGMALE ][ PRONE_HIT_DEATHTWITCHB ]					= RGMHITPRONE;
	gubAnimSurfaceIndex[ REGMALE ][ FLYBACK_HITDEATH_STOP ]					= RGMHITHARD;
	gubAnimSurfaceIndex[ REGMALE ][ FALLFORWARD_HITDEATH_STOP ]			= RGMHITSTAND;
	gubAnimSurfaceIndex[ REGMALE ][ FALLBACK_HITDEATH_STOP ]				= RGMHITFALLBACK;
	gubAnimSurfaceIndex[ REGMALE ][ PRONE_HITDEATH_STOP ]						= RGMHITPRONE;
	gubAnimSurfaceIndex[ REGMALE ][ FLYBACKHIT_STOP ]								= RGMHITHARD;
	gubAnimSurfaceIndex[ REGMALE ][ FALLBACKHIT_STOP ]							= RGMHITFALLBACK;
	gubAnimSurfaceIndex[ REGMALE ][ FALLOFF_STOP ]									= RGMFALL;
	gubAnimSurfaceIndex[ REGMALE ][ FALLOFF_FORWARD_STOP ]					= RGMFALLF;
	gubAnimSurfaceIndex[ REGMALE ][ STAND_FALLFORWARD_STOP ]				= RGMHITSTAND;
	gubAnimSurfaceIndex[ REGMALE ][ PRONE_LAYFROMHIT_STOP ]					= RGMHITPRONE;
	gubAnimSurfaceIndex[ REGMALE ][ HOPFENCE ]											= RGMHOPFENCE;
	gubAnimSurfaceIndex[ REGMALE ][ PUNCH_BREATH ]									= RGMPUNCH;
	gubAnimSurfaceIndex[ REGMALE ][ PUNCH ]													= RGMPUNCH;
	gubAnimSurfaceIndex[ REGMALE ][ NOTHING_STAND ]									= RGMNOTHING_STD;
	gubAnimSurfaceIndex[ REGMALE ][ JFK_HITDEATH ]									= RGMDIE_JFK;
	gubAnimSurfaceIndex[ REGMALE ][ JFK_HITDEATH_STOP ]							= RGMDIE_JFK;
	gubAnimSurfaceIndex[ REGMALE ][ JFK_HITDEATH_TWITCHB ]					= RGMDIE_JFK;
	gubAnimSurfaceIndex[ REGMALE ][ FIRE_STAND_BURST_SPREAD ]				= RGMSTANDAIM;
	gubAnimSurfaceIndex[ REGMALE ][ FALLOFF_DEATH ]									= RGMFALL;
	gubAnimSurfaceIndex[ REGMALE ][ FALLOFF_DEATH_STOP ]						= RGMFALL;
	gubAnimSurfaceIndex[ REGMALE ][ FALLOFF_TWITCHB ]								= RGMFALL;
	gubAnimSurfaceIndex[ REGMALE ][ FALLOFF_TWITCHNB ]							= RGMFALL;
	gubAnimSurfaceIndex[ REGMALE ][ FALLOFF_FORWARD_DEATH ]					= RGMFALLF;
	gubAnimSurfaceIndex[ REGMALE ][ FALLOFF_FORWARD_DEATH_STOP ]		= RGMFALLF;
	gubAnimSurfaceIndex[ REGMALE ][ FALLOFF_FORWARD_TWITCHB ]				= RGMFALLF;
	gubAnimSurfaceIndex[ REGMALE ][ FALLOFF_FORWARD_TWITCHNB ]			= RGMFALLF;
	gubAnimSurfaceIndex[ REGMALE ][ OPEN_DOOR ]											= RGMOPEN;
	gubAnimSurfaceIndex[ REGMALE ][ OPEN_STRUCT ]										= RGMOPEN;
	gubAnimSurfaceIndex[ REGMALE ][ PICKUP_ITEM ]										= RGMPICKUP;
	gubAnimSurfaceIndex[ REGMALE ][ DROP_ITEM ]											= RGMPICKUP;
	gubAnimSurfaceIndex[ REGMALE ][ SLICE ]													= RGMSLICE;
	gubAnimSurfaceIndex[ REGMALE ][ STAB ]													= RGMSTAB;
	gubAnimSurfaceIndex[ REGMALE ][ CROUCH_STAB ]										= RGMCSTAB;
	gubAnimSurfaceIndex[ REGMALE ][ START_AID ]											= RGMMEDIC;
	gubAnimSurfaceIndex[ REGMALE ][ GIVING_AID ]										= RGMMEDIC;
	gubAnimSurfaceIndex[ REGMALE ][ END_AID ]												= RGMMEDIC;
	gubAnimSurfaceIndex[ REGMALE ][ DODGE_ONE ]											= RGMDODGE;
	gubAnimSurfaceIndex[ REGMALE ][ READY_DUAL_STAND ]							= RGMSTANDDWALAIM;
	gubAnimSurfaceIndex[ REGMALE ][ AIM_DUAL_STAND ]								= RGMSTANDDWALAIM;
	gubAnimSurfaceIndex[ REGMALE ][ SHOOT_DUAL_STAND ]							= RGMSTANDDWALAIM;
	gubAnimSurfaceIndex[ REGMALE ][ END_DUAL_STAND ]								= RGMSTANDDWALAIM;
	gubAnimSurfaceIndex[ REGMALE ][ RAISE_RIFLE ]										= RGMRAISE;
	gubAnimSurfaceIndex[ REGMALE ][ LOWER_RIFLE ]										= RGMRAISE;
	gubAnimSurfaceIndex[ REGMALE ][ BODYEXPLODING ]									= BODYEXPLODE;
	gubAnimSurfaceIndex[ REGMALE ][ THROW_ITEM ]										= RGMTHROW;
	gubAnimSurfaceIndex[ REGMALE ][ LOB_ITEM ]											= RGMLOB;
	gubAnimSurfaceIndex[ REGMALE ][ CROUCHED_BURST ]								= RGMCROUCHAIM;
	gubAnimSurfaceIndex[ REGMALE ][ PRONE_BURST ]										= RGMPRONE;
	gubAnimSurfaceIndex[ REGMALE ][ GIVE_ITEM ]											= RGMOPEN;
	gubAnimSurfaceIndex[ REGMALE ][ CLIMB_CLIFF ]										= RGMMCLIMB;
	gubAnimSurfaceIndex[ REGMALE ][ CLIMB_CLIFF ]										= RGMMCLIMB;
	gubAnimSurfaceIndex[ REGMALE ][ WATER_HIT ]											= RGMWATER_DIE;
	gubAnimSurfaceIndex[ REGMALE ][ WATER_DIE]											= RGMWATER_DIE;
	gubAnimSurfaceIndex[ REGMALE ][ WATER_DIE_STOP ]								= RGMWATER_DIE;
	gubAnimSurfaceIndex[ REGMALE ][ HELIDROP ]											= RGMHELIDROP;
	gubAnimSurfaceIndex[ REGMALE ][ FEM_LOOK ]											= RGM_LOOK;
	gubAnimSurfaceIndex[ REGMALE ][ REG_SQUISH ]										= RGM_SQUISH;
	gubAnimSurfaceIndex[ REGMALE ][ REG_PULL ]											= RGM_PULL;
	gubAnimSurfaceIndex[ REGMALE ][ REG_SPIT ]											= RGM_SPIT;
	gubAnimSurfaceIndex[ REGMALE ][ NINJA_GOTOBREATH ]							= RGMLOWKICK;
	gubAnimSurfaceIndex[ REGMALE ][ NINJA_BREATH ]									= RGMLOWKICK;
	gubAnimSurfaceIndex[ REGMALE ][ NINJA_LOWKICK ]									= RGMLOWKICK;
	gubAnimSurfaceIndex[ REGMALE ][ NINJA_PUNCH ]										= RGMNPUNCH;
	gubAnimSurfaceIndex[ REGMALE ][ NINJA_SPINKICK ]								= RGMSPINKICK;
	gubAnimSurfaceIndex[ REGMALE ][ END_OPEN_DOOR ]									= RGMOPEN;
	gubAnimSurfaceIndex[ REGMALE ][ END_OPEN_LOCKED_DOOR ]					= RGMOPEN;
	gubAnimSurfaceIndex[ REGMALE ][ KICK_DOOR ]											= RGMKICKDOOR;
	gubAnimSurfaceIndex[ REGMALE ][ CLOSE_DOOR ]										= RGMOPEN;
	gubAnimSurfaceIndex[ REGMALE ][ RIFLE_STAND_HIT ]								= RGMRHIT;
	gubAnimSurfaceIndex[ REGMALE ][ DEEP_WATER_TRED ]								= RGMDEEPWATER_TRED;
	gubAnimSurfaceIndex[ REGMALE ][ DEEP_WATER_SWIM ]								= RGMDEEPWATER_SWIM;
	gubAnimSurfaceIndex[ REGMALE ][ DEEP_WATER_HIT ]								= RGMDEEPWATER_DIE;
	gubAnimSurfaceIndex[ REGMALE ][ DEEP_WATER_DIE]									= RGMDEEPWATER_DIE;
	gubAnimSurfaceIndex[ REGMALE ][ DEEP_WATER_DIE_STOPPING ]				= RGMWATER_DIE;
	gubAnimSurfaceIndex[ REGMALE ][ DEEP_WATER_DIE_STOP ]						= RGMWATER_DIE;
	gubAnimSurfaceIndex[ REGMALE ][ LOW_TO_DEEP_WATER ]							= RGMWATER_TRANS;
	gubAnimSurfaceIndex[ REGMALE ][ DEEP_TO_LOW_WATER ]							= RGMWATER_TRANS;
	gubAnimSurfaceIndex[ REGMALE ][ GOTO_SLEEP ]										= RGMSLEEP;
	gubAnimSurfaceIndex[ REGMALE ][ SLEEPING ]											= RGMSLEEP;
	gubAnimSurfaceIndex[ REGMALE ][ WKAEUP_FROM_SLEEP ]							= RGMSLEEP;
	gubAnimSurfaceIndex[ REGMALE ][ FIRE_LOW_STAND ]								= RGMSHOOT_LOW;
	gubAnimSurfaceIndex[ REGMALE ][ FIRE_BURST_LOW_STAND ]					= RGMSHOOT_LOW;
	gubAnimSurfaceIndex[ REGMALE ][ STANDING_SHOOT_UNJAM ]					= RGMSTANDAIM;
	gubAnimSurfaceIndex[ REGMALE ][ CROUCH_SHOOT_UNJAM ]						= RGMCROUCHAIM;
	gubAnimSurfaceIndex[ REGMALE ][ PRONE_SHOOT_UNJAM ]							= RGMPRONE;
	gubAnimSurfaceIndex[ REGMALE ][ STANDING_SHOOT_DWEL_UNJAM ]		= RGMSTANDDWALAIM;
	gubAnimSurfaceIndex[ REGMALE ][ STANDING_SHOOT_LOW_UNJAM ]		= RGMSHOOT_LOW;
	gubAnimSurfaceIndex[ REGMALE ][ READY_DUAL_CROUCH ]							= RGMCDBLSHOT;
	gubAnimSurfaceIndex[ REGMALE ][ AIM_DUAL_CROUCH ]								= RGMCDBLSHOT;
	gubAnimSurfaceIndex[ REGMALE ][ SHOOT_DUAL_CROUCH ]							= RGMCDBLSHOT;
	gubAnimSurfaceIndex[ REGMALE ][ END_DUAL_CROUCH ]								= RGMCDBLSHOT;
	gubAnimSurfaceIndex[ REGMALE ][ CROUCH_SHOOT_DWEL_UNJAM ]				= RGMCDBLSHOT;
	gubAnimSurfaceIndex[ REGMALE ][ ADJACENT_GET_ITEM ]							= RGMOPEN;
	gubAnimSurfaceIndex[ REGMALE ][ CUTTING_FENCE ]									= RGMMEDIC;
	gubAnimSurfaceIndex[ REGMALE ][ FROM_INJURED_TRANSITION ]				= RGMHURTTRANS;
	gubAnimSurfaceIndex[ REGMALE ][ THROW_KNIFE ]										= RGMTHROWKNIFE;
	gubAnimSurfaceIndex[ REGMALE ][ KNIFE_BREATH ]									= RGMBREATHKNIFE;
	gubAnimSurfaceIndex[ REGMALE ][ KNIFE_GOTOBREATH ]							= RGMBREATHKNIFE;
	gubAnimSurfaceIndex[ REGMALE ][ KNIFE_ENDBREATH ]								= RGMBREATHKNIFE;
	gubAnimSurfaceIndex[ REGMALE ][ CATCH_STANDING ]								= RGMOPEN;
	gubAnimSurfaceIndex[ REGMALE ][ CATCH_CROUCHED ]								= RGMMEDIC;
	gubAnimSurfaceIndex[ REGMALE ][ PLANT_BOMB ]										= RGMPICKUP;
	gubAnimSurfaceIndex[ REGMALE ][ USE_REMOTE ]										= RGMUSEREMOTE;
	gubAnimSurfaceIndex[ REGMALE ][ START_COWER ]										= RGMCOWER;
	gubAnimSurfaceIndex[ REGMALE ][ COWERING ]											= RGMCOWER;
	gubAnimSurfaceIndex[ REGMALE ][ END_COWER ]											= RGMCOWER;
	gubAnimSurfaceIndex[ REGMALE ][ STEAL_ITEM ]										= RGMOPEN;
	gubAnimSurfaceIndex[ REGMALE ][ SHOOT_ROCKET ]									= RGMROCKET;
	gubAnimSurfaceIndex[ REGMALE ][ SHOOT_MORTAR ]									= RGMMORTAR;
	gubAnimSurfaceIndex[ REGMALE ][ SIDE_STEP ]											= RGMSIDESTEP;
	gubAnimSurfaceIndex[ REGMALE ][ WALK_BACKWARDS ]								= RGMBASICWALKING;
	gubAnimSurfaceIndex[ REGMALE ][ BEGIN_OPENSTRUCT ]							= RGMOPEN;
	gubAnimSurfaceIndex[ REGMALE ][ END_OPENSTRUCT ]								= RGMOPEN;
	gubAnimSurfaceIndex[ REGMALE ][ END_OPENSTRUCT_LOCKED ]					= RGMOPEN;
	gubAnimSurfaceIndex[ REGMALE ][ PUNCH_LOW ]											= RGMPUNCHLOW;
	gubAnimSurfaceIndex[ REGMALE ][ PISTOL_SHOOT_LOW ]							= RGMPISTOLSHOOTLOW;
	gubAnimSurfaceIndex[ REGMALE ][ DECAPITATE ]										= RGMCSTAB;
	gubAnimSurfaceIndex[ REGMALE ][ GOTO_PATIENT ]									= RGMHITPRONE;
	gubAnimSurfaceIndex[ REGMALE ][ BEING_PATIENT ]									= RGMHITPRONE;
	gubAnimSurfaceIndex[ REGMALE ][ GOTO_DOCTOR ]										= RGMMEDIC;
	gubAnimSurfaceIndex[ REGMALE ][ BEING_DOCTOR ]									= RGMMEDIC;
	gubAnimSurfaceIndex[ REGMALE ][ END_DOCTOR ]										= RGMMEDIC;
	gubAnimSurfaceIndex[ REGMALE ][ GOTO_REPAIRMAN ]								= RGMMEDIC;
	gubAnimSurfaceIndex[ REGMALE ][ BEING_REPAIRMAN ]								= RGMMEDIC;
	gubAnimSurfaceIndex[ REGMALE ][ END_REPAIRMAN ]									= RGMMEDIC;
	gubAnimSurfaceIndex[ REGMALE ][ FALL_INTO_PIT ]									= RGMFALL;
	gubAnimSurfaceIndex[ REGMALE ][ RELOAD_ROBOT ]									= RGMMEDIC;
	gubAnimSurfaceIndex[ REGMALE ][ END_CATCH ]											= RGMOPEN;
	gubAnimSurfaceIndex[ REGMALE ][ END_CROUCH_CATCH ]							= RGMMEDIC;
	gubAnimSurfaceIndex[ REGMALE ][ AI_RADIO ]											= RGMRADIO;
	gubAnimSurfaceIndex[ REGMALE ][ AI_CR_RADIO ]										= RGMCRRADIO;
	gubAnimSurfaceIndex[ REGMALE ][ SLAP_HIT ]											= RGMHITSTAND;
	gubAnimSurfaceIndex[ REGMALE ][ TAKE_BLOOD_FROM_CORPSE ]				= RGMMEDIC;
	gubAnimSurfaceIndex[ REGMALE ][ CHARIOTS_OF_FIRE ]							= RGMBURN;
	gubAnimSurfaceIndex[ REGMALE ][ AI_PULL_SWITCH ]								= RGMOPEN;
	gubAnimSurfaceIndex[ REGMALE ][ MERC_HURT_IDLE_ANIM ]						= RGMHURTSTANDINGR;
	gubAnimSurfaceIndex[ REGMALE ][ END_HURT_WALKING ]							= RGMHURTSTANDINGR;
	gubAnimSurfaceIndex[ REGMALE ][ PASS_OBJECT ]										= RGMOPEN;
	gubAnimSurfaceIndex[ REGMALE ][ DROP_ADJACENT_OBJECT ]					= RGMOPEN;
	gubAnimSurfaceIndex[ REGMALE ][ READY_DUAL_PRONE ]							= RGMDWPRONE;
	gubAnimSurfaceIndex[ REGMALE ][ AIM_DUAL_PRONE ]								= RGMDWPRONE;
	gubAnimSurfaceIndex[ REGMALE ][ SHOOT_DUAL_PRONE ]							= RGMDWPRONE;
	gubAnimSurfaceIndex[ REGMALE ][ END_DUAL_PRONE ]								= RGMDWPRONE;
	gubAnimSurfaceIndex[ REGMALE ][ PRONE_SHOOT_DWEL_UNJAM ]			= RGMDWPRONE;
	gubAnimSurfaceIndex[ REGMALE ][ PICK_LOCK ]										= RGMOPEN;
	gubAnimSurfaceIndex[ REGMALE ][ OPEN_DOOR_CROUCHED ]						= RGMMEDIC;
	gubAnimSurfaceIndex[ REGMALE ][ BEGIN_OPENSTRUCT_CROUCHED ]			= RGMMEDIC;
	gubAnimSurfaceIndex[ REGMALE ][ CLOSE_DOOR_CROUCHED ]						= RGMMEDIC;
	gubAnimSurfaceIndex[ REGMALE ][ OPEN_STRUCT_CROUCHED ]					= RGMMEDIC;
	gubAnimSurfaceIndex[ REGMALE ][ END_OPEN_DOOR_CROUCHED ]				= RGMMEDIC;
	gubAnimSurfaceIndex[ REGMALE ][ END_OPENSTRUCT_CROUCHED ]				= RGMMEDIC;
	gubAnimSurfaceIndex[ REGMALE ][ END_OPEN_LOCKED_DOOR_CROUCHED ]	= RGMMEDIC;
	gubAnimSurfaceIndex[ REGMALE ][ END_OPENSTRUCT_LOCKED_CROUCHED ]= RGMMEDIC;
	gubAnimSurfaceIndex[ REGMALE ][ DRUNK_IDLE ]										= RGMDRUNK;
	gubAnimSurfaceIndex[ REGMALE ][ CROWBAR_ATTACK ]								= RGMCROWBAR;
	gubAnimSurfaceIndex[ REGMALE ][ CRIPPLE_KICKOUT ]								= CRIPCIVKICK;
	gubAnimSurfaceIndex[ REGMALE ][ ATTACH_CAN_TO_STRING ]					= RGMMEDIC;
	gubAnimSurfaceIndex[ REGMALE ][ SWAT_BACKWARDS ]								= RGMSNEAKING;
	gubAnimSurfaceIndex[ REGMALE ][ JUMP_OVER_BLOCKING_PERSON ]			= RGMJUMPOVER;
	gubAnimSurfaceIndex[ REGMALE ][ REFUEL_VEHICLE ]								= RGMMEDIC;
	gubAnimSurfaceIndex[ REGMALE ][ LOCKPICK_CROUCHED ]						= RGMMEDIC;

	//<SB> crouch throwing
	gubAnimSurfaceIndex[ REGMALE ][ THROW_ITEM_CROUCHED ]										= RGMCRTHROW;
	//</SB>
	//ddd shoot rocket crouched
	gubAnimSurfaceIndex[ REGMALE ][ SHOOT_ROCKET_CROUCHED ]							= RGMCRROCKET;
	gubAnimSurfaceIndex[ REGMALE ][ SWATTING_WK ]							= RGMSWKNIFE;
	gubAnimSurfaceIndex[ REGMALE ][ SWAT_BACKWARDS_WK ]						= RGMSWKNIFE;
	gubAnimSurfaceIndex[ REGMALE ][ SWAT_BACKWARDS_NOTHING ]				= RGMNOTHING_SWAT;
	//grenade throwing
	gubAnimSurfaceIndex[ REGMALE ][ THROW_GRENADE_STANCE ]				= RGMSTHRG;
	gubAnimSurfaceIndex[ REGMALE ][ LOB_GRENADE_STANCE ]				= RGMSLOBG;
	//roll over
	gubAnimSurfaceIndex[ REGMALE ][ ROLL_PRONE_L ]					  	= RGMROLL_PR;
	gubAnimSurfaceIndex[ REGMALE ][ ROLL_PRONE_R ]					  	= RGMROLL_PR;

	gubAnimSurfaceIndex[ REGMALE ][ JUMPUPWALL ]						= RGMWALLJUMP;
	gubAnimSurfaceIndex[ REGMALE ][ JUMPDOWNWALL ]					= RGMWALLJUMP;
	
	gubAnimSurfaceIndex[ REGMALE ][ JUMPWINDOWS ]											= RGMJUMPWINDOWS;
	
	gubAnimSurfaceIndex[ REGMALE ][ SIDE_STEP_WEAPON_RDY ]				= RGMSIDESTEP_R_RDY;
	gubAnimSurfaceIndex[ REGMALE ][ SIDE_STEP_DUAL_RDY ]				= RGMSIDESTEP_D_RDY;
	
	gubAnimSurfaceIndex[ REGMALE ][ WALKING_WEAPON_RDY ]				= RGMWALK_R_RDY;
	gubAnimSurfaceIndex[ REGMALE ][ WALKING_DUAL_RDY ]					= RGMWALK_D_RDY;

	gubAnimSurfaceIndex[ REGMALE ][ START_AID_PRN ]						= RGMMEDICPRN;
	gubAnimSurfaceIndex[ REGMALE ][ GIVING_AID_PRN ]					= RGMMEDICPRN;
	gubAnimSurfaceIndex[ REGMALE ][ END_AID_PRN ]						= RGMMEDICPRN;

	gubAnimSurfaceIndex[ REGMALE ][ ADJACENT_GET_ITEM_CROUCHED ]		= RGMMEDIC;
	gubAnimSurfaceIndex[ REGMALE ][ STEAL_ITEM_CROUCHED ]		= RGMMEDIC;
	
	gubAnimSurfaceIndex[ REGMALE ][ BURST_DUAL_STAND ]							= RGMSTANDDWALAIM;
	gubAnimSurfaceIndex[ REGMALE ][ BURST_DUAL_CROUCH ]							= RGMCDBLSHOT;
	gubAnimSurfaceIndex[ REGMALE ][ BURST_DUAL_PRONE ]							= RGMDWPRONE;
	
	gubAnimSurfaceIndex[ REGMALE ][ READY_ALTERNATIVE_STAND ]				= RGM_HIP_AIM;
	gubAnimSurfaceIndex[ REGMALE ][ AIM_ALTERNATIVE_STAND ]				= RGM_HIP_AIM;
	gubAnimSurfaceIndex[ REGMALE ][ SHOOT_ALTERNATIVE_STAND ]				= RGM_HIP_AIM;
	gubAnimSurfaceIndex[ REGMALE ][ BURST_ALTERNATIVE_STAND ]				= RGM_HIP_AIM;
	gubAnimSurfaceIndex[ REGMALE ][ LOW_SHOT_ALTERNATIVE_STAND ]				= RGM_HIP_LOW;
	gubAnimSurfaceIndex[ REGMALE ][ LOW_BURST_ALTERNATIVE_STAND ]			= RGM_HIP_LOW;
	gubAnimSurfaceIndex[ REGMALE ][ UNREADY_ALTERNATIVE_STAND ]			= RGM_HIP_AIM;
	gubAnimSurfaceIndex[ REGMALE ][ UNJAM_ALTERNATIVE_STAND ]				= RGM_HIP_AIM;
	gubAnimSurfaceIndex[ REGMALE ][ LOW_UNJAM_ALTERNATIVE_STAND ]			= RGM_HIP_LOW;
	gubAnimSurfaceIndex[ REGMALE ][ WALKING_ALTERNATIVE_RDY ]			= RGMBASICWALKING;
	gubAnimSurfaceIndex[ REGMALE ][ SIDE_STEP_ALTERNATIVE_RDY ]			= RGMSIDESTEP;
	
	gubAnimSurfaceIndex[ REGMALE ][ START_COWER_CROUCHED ]			= RGMCOWER;
	gubAnimSurfaceIndex[ REGMALE ][ END_COWER_CROUCHED ]			= RGMCOWER;
	gubAnimSurfaceIndex[ REGMALE ][ START_COWER_PRONE ]				= RGM_COWER_PRONE;
	gubAnimSurfaceIndex[ REGMALE ][ COWERING_PRONE ]				= RGM_COWER_PRONE;
	gubAnimSurfaceIndex[ REGMALE ][ END_COWER_PRONE ]				= RGM_COWER_PRONE;
	
	gubAnimSurfaceIndex[ REGMALE ][ FOCUSED_PUNCH ]					= RGMPUNCH;
	gubAnimSurfaceIndex[ REGMALE ][ FOCUSED_STAB ]					= RGMSTAB;
	gubAnimSurfaceIndex[ REGMALE ][ HTH_KICK ]						= RGMKICKDOOR;
	gubAnimSurfaceIndex[ REGMALE ][ FOCUSED_HTH_KICK ]				= RGMKICKDOOR;
	
	gubAnimSurfaceIndex[ REGMALE ][ LONG_JUMP ]						= RGMJUMPOVER;

	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ STANDING][0]									= RGMWATER_R_STD;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ WALKING ][0]									= RGMWATER_R_WALK;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ RUNNING ][0]									= RGMWATER_R_WALK;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ READY_RIFLE_STAND ][0]				= RGMWATER_R_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ AIM_RIFLE_STAND ][0]					= RGMWATER_R_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ SHOOT_RIFLE_STAND ][0]				= RGMWATER_R_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ END_RIFLE_STAND ][0]					= RGMWATER_R_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ STANDING_BURST ][0]					= RGMWATER_R_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ FIRE_STAND_BURST_SPREAD ][0]	= RGMWATER_R_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ STANDING][1]									= RGMWATER_N_STD;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ WALKING ][1]									= RGMWATER_N_WALK;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ RUNNING ][1]									= RGMWATER_N_WALK;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ READY_RIFLE_STAND ][1]				= RGMWATER_N_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ AIM_RIFLE_STAND ][1]					= RGMWATER_N_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ SHOOT_RIFLE_STAND ][1]				= RGMWATER_N_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ END_RIFLE_STAND ][1]					= RGMWATER_N_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ STANDING_BURST ][1]					= RGMWATER_N_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ FIRE_STAND_BURST_SPREAD ][1]	= RGMWATER_N_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ READY_DUAL_STAND ][1]				= RGMWATER_DBLSHT;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ AIM_DUAL_STAND ][1]					= RGMWATER_DBLSHT;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ SHOOT_DUAL_STAND ][1]				= RGMWATER_DBLSHT;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ END_DUAL_STAND ][1]					= RGMWATER_DBLSHT;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ STANDING_SHOOT_UNJAM ][0]		= RGMWATER_R_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ STANDING_SHOOT_UNJAM ][1]		= RGMWATER_N_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ THROW_ITEM ][0]							= RGMWATERTHROW;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ THROW_ITEM ][1]							= RGMWATERTHROW;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ LOB_ITEM ][0]								= RGMWATERTHROW;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ LOB_ITEM ][1]								= RGMWATERTHROW;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ BURST_DUAL_STAND ][1]				= RGMWATER_DBLSHT;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ READY_ALTERNATIVE_STAND ][0]					= RGM_WATER_HIP_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ AIM_ALTERNATIVE_STAND ][0]						= RGM_WATER_HIP_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ SHOOT_ALTERNATIVE_STAND ][0]					= RGM_WATER_HIP_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ BURST_ALTERNATIVE_STAND ][0]					= RGM_WATER_HIP_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ UNREADY_ALTERNATIVE_STAND ][0]					= RGM_WATER_HIP_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGMALE ][ UNJAM_ALTERNATIVE_STAND ][0]					= RGM_WATER_HIP_AIM;

	//Setup some random stuff
	gRandomAnimDefs[ REGMALE ][ 0 ].ubHandRestriction		= RANDOM_ANIM_RIFLEINHAND;
	gRandomAnimDefs[ REGMALE ][ 0 ].sAnimID							= REG_SPIT;
	gRandomAnimDefs[ REGMALE ][ 0 ].ubStartRoll					= 0;
	gRandomAnimDefs[ REGMALE ][ 0 ].ubEndRoll						= 9;
	gRandomAnimDefs[ REGMALE ][ 0 ].ubFlags							= RANDOM_ANIM_CASUAL;
	gRandomAnimDefs[ REGMALE ][ 0 ].ubAnimHeight				= ANIM_STAND;

	gRandomAnimDefs[ REGMALE ][ 1 ].ubHandRestriction		= RANDOM_ANIM_NOTHINGINHAND;
	gRandomAnimDefs[ REGMALE ][ 1 ].sAnimID							= REG_SQUISH;
	gRandomAnimDefs[ REGMALE ][ 1 ].ubStartRoll					= 10;
	gRandomAnimDefs[ REGMALE ][ 1 ].ubEndRoll						= 19;
	gRandomAnimDefs[ REGMALE ][ 1 ].ubFlags							= RANDOM_ANIM_CASUAL;
	gRandomAnimDefs[ REGMALE ][ 1 ].ubAnimHeight				= ANIM_STAND;

	gRandomAnimDefs[ REGMALE ][ 2 ].ubHandRestriction		= RANDOM_ANIM_RIFLEINHAND;
	gRandomAnimDefs[ REGMALE ][ 2 ].sAnimID							= FEM_LOOK;
	gRandomAnimDefs[ REGMALE ][ 2 ].ubStartRoll					= 10;
	gRandomAnimDefs[ REGMALE ][ 2 ].ubEndRoll						= 29;
	gRandomAnimDefs[ REGMALE ][ 2 ].ubFlags							= RANDOM_ANIM_LOOKAROUND;
	gRandomAnimDefs[ REGMALE ][ 2 ].ubAnimHeight				= ANIM_STAND;

	gRandomAnimDefs[ REGMALE ][ 3 ].ubHandRestriction		= RANDOM_ANIM_NOTHINGINHAND;
	gRandomAnimDefs[ REGMALE ][ 3 ].sAnimID							= REG_PULL;
	gRandomAnimDefs[ REGMALE ][ 3 ].ubStartRoll					= 30;
	gRandomAnimDefs[ REGMALE ][ 3 ].ubEndRoll						= 39;
	gRandomAnimDefs[ REGMALE ][ 3 ].ubFlags							= 0;
	gRandomAnimDefs[ REGMALE ][ 3 ].ubAnimHeight				= ANIM_STAND;

	gRandomAnimDefs[ REGMALE ][ 4 ].ubHandRestriction		= RANDOM_ANIM_IRRELEVENTINHAND;
	gRandomAnimDefs[ REGMALE ][ 4 ].sAnimID							= MERC_HURT_IDLE_ANIM;
	gRandomAnimDefs[ REGMALE ][ 4 ].ubStartRoll					= 0;
	gRandomAnimDefs[ REGMALE ][ 4 ].ubEndRoll						= 60;
	gRandomAnimDefs[ REGMALE ][ 4 ].ubFlags							= RANDOM_ANIM_INJURED;
	gRandomAnimDefs[ REGMALE ][ 4 ].ubAnimHeight				= ANIM_STAND;

	gRandomAnimDefs[ REGMALE ][ 5 ].ubHandRestriction		= RANDOM_ANIM_IRRELEVENTINHAND;
	gRandomAnimDefs[ REGMALE ][ 5 ].sAnimID							= DRUNK_IDLE;
	gRandomAnimDefs[ REGMALE ][ 5 ].ubStartRoll					= 61;
	gRandomAnimDefs[ REGMALE ][ 5 ].ubEndRoll						= 100;
	gRandomAnimDefs[ REGMALE ][ 5 ].ubFlags							= RANDOM_ANIM_DRUNK;
	gRandomAnimDefs[ REGMALE ][ 5 ].ubAnimHeight				= ANIM_STAND;


	gubAnimSurfaceItemSubIndex[ REGMALE ][ STANDING ]									= RGMPISTOLBREATH;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ WALKING ]									= RGMNOTHING_WALK;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ RUNNING ]									= RGMNOTHING_RUN;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ SWATTING ]									= RGMNOTHING_SWAT;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ START_SWAT ]								= RGMNOTHING_SWAT;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ END_SWAT ]									= RGMNOTHING_SWAT;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ KNEEL_DOWN ]								= RGMNOTHING_CROUCH;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ CROUCHING ]								= RGMNOTHING_CROUCH;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ KNEEL_UP ]									= RGMNOTHING_CROUCH;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ READY_RIFLE_STAND ]				= RGMHANDGUN_S_SHOT;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ AIM_RIFLE_STAND ]					= RGMHANDGUN_S_SHOT;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ SHOOT_RIFLE_STAND ]				= RGMHANDGUN_S_SHOT;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ END_RIFLE_STAND ]					= RGMHANDGUN_S_SHOT;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ STANDING_BURST ]						= RGMHANDGUN_S_SHOT;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ FIRE_STAND_BURST_SPREAD ]	= RGMHANDGUN_S_SHOT;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ READY_RIFLE_CROUCH ]				= RGMHANDGUN_C_SHOT;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ AIM_RIFLE_CROUCH ]					= RGMHANDGUN_C_SHOT;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ SHOOT_RIFLE_CROUCH ]				= RGMHANDGUN_C_SHOT;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ END_RIFLE_CROUCH ]					= RGMHANDGUN_C_SHOT;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ PRONE_DOWN ]								= RGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ CRAWLING ]									= RGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ PRONE_UP ]									= RGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ PRONE ]										= RGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ READY_RIFLE_PRONE ]				= RGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ AIM_RIFLE_PRONE ]					= RGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ SHOOT_RIFLE_PRONE ]				= RGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ END_RIFLE_PRONE ]					= RGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ GETUP_FROM_ROLLOVER ]			= RGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ STANDING_SHOOT_UNJAM ]			= RGMHANDGUN_S_SHOT;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ CROUCH_SHOOT_UNJAM ]				= RGMHANDGUN_C_SHOT;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ PRONE_SHOOT_UNJAM ]				= RGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ FIRE_BURST_LOW_STAND ]			= RGMPISTOLSHOOTLOW;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ FIRE_LOW_STAND ]						= RGMPISTOLSHOOTLOW;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ CROUCHED_BURST ]						= RGMHANDGUN_C_SHOT;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ PRONE_BURST ]							= RGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ MERC_HURT_IDLE_ANIM ]			= RGMHURTSTANDINGN;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ END_HURT_WALKING ]					= RGMHURTSTANDINGN;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ WALK_BACKWARDS ]						= RGMNOTHING_WALK;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ DRUNK_IDLE ]								= RGMPISTOLDRUNK;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ RUNNING_W_PISTOL ]					= RGMPISTOL_RUN;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ SIDE_STEP_WEAPON_RDY ]				= RGMSIDESTEP_P_RDY;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ WALKING_WEAPON_RDY ]				= RGMWALK_P_RDY;
	
	gubAnimSurfaceItemSubIndex[ REGMALE ][ READY_ALTERNATIVE_STAND ]				= RGM_PFSHOT_AIM;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ AIM_ALTERNATIVE_STAND ]				= RGM_PFSHOT_AIM;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ SHOOT_ALTERNATIVE_STAND ]				= RGM_PFSHOT_AIM;	
	gubAnimSurfaceItemSubIndex[ REGMALE ][ BURST_ALTERNATIVE_STAND ]				= RGM_PFSHOT_AIM;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ LOW_SHOT_ALTERNATIVE_STAND ]				= RGMPISTOLSHOOTLOW;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ LOW_BURST_ALTERNATIVE_STAND ]			= RGMPISTOLSHOOTLOW;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ UNREADY_ALTERNATIVE_STAND ]			= RGM_PFSHOT_AIM;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ UNJAM_ALTERNATIVE_STAND ]				= RGM_PFSHOT_AIM;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ LOW_UNJAM_ALTERNATIVE_STAND ]			= RGMPISTOLSHOOTLOW;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ WALKING_ALTERNATIVE_RDY ]			= RGMWALK_P_RDY;
	gubAnimSurfaceItemSubIndex[ REGMALE ][ SIDE_STEP_ALTERNATIVE_RDY ]			= RGMSIDESTEP_P_RDY;


	gubAnimSurfaceCorpseID[ REGMALE ][ GENERIC_HIT_DEATH ]						= SMERC_FWD;
	gubAnimSurfaceCorpseID[ REGMALE ][ FALLBACK_HIT_DEATH ]						= SMERC_BCK;
	gubAnimSurfaceCorpseID[ REGMALE ][ PRONE_HIT_DEATH ]							= SMERC_PRN;
	gubAnimSurfaceCorpseID[ REGMALE ][ WATER_DIE ]										= SMERC_WTR;
	gubAnimSurfaceCorpseID[ REGMALE ][ FLYBACK_HIT_DEATH ]						= SMERC_DHD;
	gubAnimSurfaceCorpseID[ REGMALE ][ JFK_HITDEATH ]									= SMERC_JFK;
	gubAnimSurfaceCorpseID[ REGMALE ][ FALLOFF_DEATH ]								= SMERC_FALL;
	gubAnimSurfaceCorpseID[ REGMALE ][ FALLOFF_FORWARD_DEATH ]				= SMERC_FALLF;
	gubAnimSurfaceCorpseID[ REGMALE ][ FLYBACK_HIT ]									= SMERC_DHD;
	gubAnimSurfaceCorpseID[ REGMALE ][ GENERIC_HIT_DEATHTWITCHNB ]		= SMERC_FWD;
	gubAnimSurfaceCorpseID[ REGMALE ][ FALLFORWARD_FROMHIT_STAND ]		= SMERC_FWD;
	gubAnimSurfaceCorpseID[ REGMALE ][ ENDFALLFORWARD_FROMHIT_CROUCH ]= SMERC_FWD;
	gubAnimSurfaceCorpseID[ REGMALE ][ FALLBACK_HIT_STAND ]						= SMERC_BCK;
	gubAnimSurfaceCorpseID[ REGMALE ][ FALLBACK_HIT_DEATHTWITCHNB ]		= SMERC_BCK;
	gubAnimSurfaceCorpseID[ REGMALE ][ PRONE_HIT_DEATHTWITCHNB ]			= SMERC_PRN;
	gubAnimSurfaceCorpseID[ REGMALE ][ PRONE_LAY_FROMHIT ]						= SMERC_PRN;
	gubAnimSurfaceCorpseID[ REGMALE ][ FALLOFF ]											= SMERC_FALLF;
	gubAnimSurfaceCorpseID[ REGMALE ][ FALLFORWARD_ROOF ]							= SMERC_FALL;
	gubAnimSurfaceCorpseID[ REGMALE ][ FLYBACKHIT_STOP ]							= SMERC_DHD;
	gubAnimSurfaceCorpseID[ REGMALE ][ STAND_FALLFORWARD_STOP ]				= SMERC_FWD;
	gubAnimSurfaceCorpseID[ REGMALE ][ FALLBACKHIT_STOP ]							= SMERC_BCK;
	gubAnimSurfaceCorpseID[ REGMALE ][ PRONE_LAYFROMHIT_STOP ]				= SMERC_PRN;
	gubAnimSurfaceCorpseID[ REGMALE ][ CHARIOTS_OF_FIRE ]							= BURNT_DEAD;
	gubAnimSurfaceCorpseID[ REGMALE ][ BODYEXPLODING ]								= EXPLODE_DEAD;


	// BIG MALE GUY
	gubAnimSurfaceIndex[ BIGMALE ][ WALKING ]								= BGMWALKING;
	gubAnimSurfaceIndex[ BIGMALE ][ STANDING ]							= BGMSTANDING;
	gubAnimSurfaceIndex[ BIGMALE ][ KNEEL_DOWN ]						= BGMCROUCHING;
	gubAnimSurfaceIndex[ BIGMALE ][ CROUCHING ]							= BGMCROUCHING;
	gubAnimSurfaceIndex[ BIGMALE ][ KNEEL_UP ]							= BGMCROUCHING;
	gubAnimSurfaceIndex[ BIGMALE ][ SWATTING ]							= BGMSNEAKING;
	gubAnimSurfaceIndex[ BIGMALE ][ RUNNING ]								= BGMRUNNING;
	gubAnimSurfaceIndex[ BIGMALE ][ PRONE_DOWN ]						= BGMPRONE;
	gubAnimSurfaceIndex[ BIGMALE ][ CRAWLING ]							= BGMPRONE;
	gubAnimSurfaceIndex[ BIGMALE ][ PRONE_UP ]							= BGMPRONE;
	gubAnimSurfaceIndex[ BIGMALE ][ PRONE ]									= BGMPRONE;
	gubAnimSurfaceIndex[ BIGMALE ][ READY_RIFLE_STAND ]			= BGMSTANDAIM2;
	gubAnimSurfaceIndex[ BIGMALE ][ AIM_RIFLE_STAND ]				= BGMSTANDAIM2;
	gubAnimSurfaceIndex[ BIGMALE ][ SHOOT_RIFLE_STAND ]			= BGMSTANDAIM2;
	gubAnimSurfaceIndex[ BIGMALE ][ END_RIFLE_STAND ]				= BGMSTANDAIM2;
	gubAnimSurfaceIndex[ BIGMALE ][ START_SWAT ]						= BGMSNEAKING;
	gubAnimSurfaceIndex[ BIGMALE ][ END_SWAT ]							= BGMSNEAKING;
	gubAnimSurfaceIndex[ BIGMALE ][ FLYBACK_HIT ]						= BGMHITHARD;
	gubAnimSurfaceIndex[ BIGMALE ][ READY_RIFLE_PRONE ]			= BGMPRONE;
	gubAnimSurfaceIndex[ BIGMALE ][ AIM_RIFLE_PRONE ]				= BGMPRONE;
	gubAnimSurfaceIndex[ BIGMALE ][ SHOOT_RIFLE_PRONE ]			= BGMPRONE;
	gubAnimSurfaceIndex[ BIGMALE ][ END_RIFLE_PRONE ]				= BGMPRONE;
	gubAnimSurfaceIndex[ BIGMALE ][ FALLBACK_DEATHTWICH ]		= BGMHITHARD;
	gubAnimSurfaceIndex[ BIGMALE ][ GENERIC_HIT_STAND ]			= BGMHITSTAND;
	gubAnimSurfaceIndex[ BIGMALE ][ FLYBACK_HIT_BLOOD_STAND ]		= BGMHITHARDBLOOD;
	gubAnimSurfaceIndex[ BIGMALE ][ FLYBACK_HIT_DEATH ]			= BGMHITHARD;
	gubAnimSurfaceIndex[ BIGMALE ][ READY_RIFLE_CROUCH ]		= BGMCROUCHAIM;
	gubAnimSurfaceIndex[ BIGMALE ][ AIM_RIFLE_CROUCH ]			= BGMCROUCHAIM;
	gubAnimSurfaceIndex[ BIGMALE ][ SHOOT_RIFLE_CROUCH ]		= BGMCROUCHAIM;
	gubAnimSurfaceIndex[ BIGMALE ][ END_RIFLE_CROUCH ]			= BGMCROUCHAIM;
	gubAnimSurfaceIndex[ BIGMALE ][ FALLBACK_HIT_STAND ]		= BGMHITFALLBACK;
	gubAnimSurfaceIndex[ BIGMALE ][ ROLLOVER ]							= BGMROLLOVER;
	gubAnimSurfaceIndex[ BIGMALE ][ CLIMBUPROOF ]						= BGMCLIMBROOF;
	gubAnimSurfaceIndex[ BIGMALE ][ FALLOFF ]								= BGMFALL;
	gubAnimSurfaceIndex[ BIGMALE ][ GETUP_FROM_ROLLOVER ]		= BGMPRONE;
	gubAnimSurfaceIndex[ BIGMALE ][ CLIMBDOWNROOF ]					= BGMCLIMBROOF;
	gubAnimSurfaceIndex[ BIGMALE ][ FALLFORWARD_ROOF ]						= BGMFALLF;
	gubAnimSurfaceIndex[ BIGMALE ][ GENERIC_HIT_DEATHTWITCHNB ]		= BGMHITSTAND;
	gubAnimSurfaceIndex[ BIGMALE ][ GENERIC_HIT_DEATHTWITCHB ]		= BGMHITSTAND;
	gubAnimSurfaceIndex[ BIGMALE ][ FALLBACK_HIT_DEATHTWITCHNB ]	= BGMHITFALLBACK;
	gubAnimSurfaceIndex[ BIGMALE ][ FALLBACK_HIT_DEATHTWITCHB ]		= BGMHITFALLBACK;
	gubAnimSurfaceIndex[ BIGMALE ][ GENERIC_HIT_DEATH ]			= BGMHITSTAND;
	gubAnimSurfaceIndex[ BIGMALE ][ FALLBACK_HIT_DEATH ]		= BGMHITFALLBACK;
	gubAnimSurfaceIndex[ BIGMALE ][ GENERIC_HIT_CROUCH ]		= BGMHITCROUCH;
	gubAnimSurfaceIndex[ BIGMALE ][ STANDING_BURST ]				= BGMSTANDAIM2;
	gubAnimSurfaceIndex[ BIGMALE ][ STANDING_BURST_HIT ]		= BGMHITHARD;
	gubAnimSurfaceIndex[ BIGMALE ][ GENERIC_HIT_DEATH ]			= BGMHITSTAND;
	gubAnimSurfaceIndex[ BIGMALE ][ FALLFORWARD_FROMHIT_STAND ]		= BGMHITSTAND;
	gubAnimSurfaceIndex[ BIGMALE ][ FALLFORWARD_FROMHIT_STAND ]				= BGMHITSTAND;
	gubAnimSurfaceIndex[ BIGMALE ][ FALLFORWARD_FROMHIT_CROUCH ]			= BGMHITCROUCH;
	gubAnimSurfaceIndex[ BIGMALE ][ ENDFALLFORWARD_FROMHIT_CROUCH ]		= BGMHITSTAND;
	gubAnimSurfaceIndex[ BIGMALE ][ GENERIC_HIT_PRONE ]			= BGMHITPRONE;
	gubAnimSurfaceIndex[ BIGMALE ][ PRONE_HIT_DEATH ]				= BGMHITPRONE;
	gubAnimSurfaceIndex[ BIGMALE ][ PRONE_LAY_FROMHIT ]			= BGMHITPRONE;
	gubAnimSurfaceIndex[ BIGMALE ][ PRONE_HIT_DEATHTWITCHNB ]					= BGMHITPRONE;
	gubAnimSurfaceIndex[ BIGMALE ][ PRONE_HIT_DEATHTWITCHB ]					= BGMHITPRONE;
	gubAnimSurfaceIndex[ BIGMALE ][ FLYBACK_HITDEATH_STOP ]					= BGMHITHARD;
	gubAnimSurfaceIndex[ BIGMALE ][ FALLFORWARD_HITDEATH_STOP ]			= BGMHITSTAND;
	gubAnimSurfaceIndex[ BIGMALE ][ FALLBACK_HITDEATH_STOP ]				= BGMHITFALLBACK;
	gubAnimSurfaceIndex[ BIGMALE ][ PRONE_HITDEATH_STOP ]						= BGMHITPRONE;
	gubAnimSurfaceIndex[ BIGMALE ][ FLYBACKHIT_STOP ]								= BGMHITHARD;
	gubAnimSurfaceIndex[ BIGMALE ][ FALLBACKHIT_STOP ]							= BGMHITFALLBACK;
	gubAnimSurfaceIndex[ BIGMALE ][ FALLOFF_STOP ]									= BGMFALL;
	gubAnimSurfaceIndex[ BIGMALE ][ FALLOFF_FORWARD_STOP ]					= BGMFALLF;
	gubAnimSurfaceIndex[ BIGMALE ][ STAND_FALLFORWARD_STOP ]				= BGMHITSTAND;
	gubAnimSurfaceIndex[ BIGMALE ][ PRONE_LAYFROMHIT_STOP ]					= BGMHITPRONE;
	gubAnimSurfaceIndex[ BIGMALE ][ HOPFENCE ]											= BGMHOPFENCE;
	gubAnimSurfaceIndex[ BIGMALE ][ PUNCH_BREATH ]									= BGMPUNCH;
	gubAnimSurfaceIndex[ BIGMALE ][ PUNCH ]													= BGMPUNCH;
	gubAnimSurfaceIndex[ BIGMALE ][ NOTHING_STAND ]									= BGMNOTHING_STD;
	gubAnimSurfaceIndex[ BIGMALE ][ JFK_HITDEATH ]									= BGMDIE_JFK;
	gubAnimSurfaceIndex[ BIGMALE ][ JFK_HITDEATH_STOP ]							= BGMDIE_JFK;
	gubAnimSurfaceIndex[ BIGMALE ][ JFK_HITDEATH_TWITCHB ]					= BGMDIE_JFK;
	gubAnimSurfaceIndex[ BIGMALE ][ FIRE_STAND_BURST_SPREAD ]				= BGMSTANDAIM2;
	gubAnimSurfaceIndex[ BIGMALE ][ FALLOFF_DEATH ]									= BGMFALL;
	gubAnimSurfaceIndex[ BIGMALE ][ FALLOFF_DEATH_STOP ]						= BGMFALL;
	gubAnimSurfaceIndex[ BIGMALE ][ FALLOFF_TWITCHB ]								= BGMFALL;
	gubAnimSurfaceIndex[ BIGMALE ][ FALLOFF_TWITCHNB ]							= BGMFALL;
	gubAnimSurfaceIndex[ BIGMALE ][ FALLOFF_FORWARD_DEATH ]					= BGMFALLF;
	gubAnimSurfaceIndex[ BIGMALE ][ FALLOFF_FORWARD_DEATH_STOP ]		= BGMFALLF;
	gubAnimSurfaceIndex[ BIGMALE ][ FALLOFF_FORWARD_TWITCHB ]				= BGMFALLF;
	gubAnimSurfaceIndex[ BIGMALE ][ FALLOFF_FORWARD_TWITCHNB ]			= BGMFALLF;
	gubAnimSurfaceIndex[ BIGMALE ][ OPEN_STRUCT ]										= BGMOPEN;
	gubAnimSurfaceIndex[ BIGMALE ][ OPEN_DOOR ]											= BGMOPEN;
	gubAnimSurfaceIndex[ BIGMALE ][ PICKUP_ITEM ]										= BGMPICKUP;
	gubAnimSurfaceIndex[ BIGMALE ][ DROP_ITEM ]											= BGMPICKUP;
	gubAnimSurfaceIndex[ BIGMALE ][ SLICE ]													= BGMSLICE;
	gubAnimSurfaceIndex[ BIGMALE ][ STAB ]													= BGMSTAB;
	gubAnimSurfaceIndex[ BIGMALE ][ CROUCH_STAB ]										= BGMCSTAB;
	gubAnimSurfaceIndex[ BIGMALE ][ START_AID ]											= BGMMEDIC;
	gubAnimSurfaceIndex[ BIGMALE ][ GIVING_AID ]										= BGMMEDIC;
	gubAnimSurfaceIndex[ BIGMALE ][ END_AID ]												= BGMMEDIC;
	gubAnimSurfaceIndex[ BIGMALE ][ DODGE_ONE ]											= BGMDODGE;
	gubAnimSurfaceIndex[ BIGMALE ][ READY_DUAL_STAND ]							= BGMSTANDDWALAIM;
	gubAnimSurfaceIndex[ BIGMALE ][ AIM_DUAL_STAND ]								= BGMSTANDDWALAIM;
	gubAnimSurfaceIndex[ BIGMALE ][ SHOOT_DUAL_STAND ]							= BGMSTANDDWALAIM;
	gubAnimSurfaceIndex[ BIGMALE ][ END_DUAL_STAND ]								= BGMSTANDDWALAIM;
	gubAnimSurfaceIndex[ BIGMALE ][ RAISE_RIFLE ]										= BGMRAISE;
	gubAnimSurfaceIndex[ BIGMALE ][ LOWER_RIFLE ]										= BGMRAISE;
	gubAnimSurfaceIndex[ BIGMALE ][ THROW_ITEM ]										= BGMTHROW;
	gubAnimSurfaceIndex[ BIGMALE ][ LOB_ITEM ]											= BGMLOB;
	gubAnimSurfaceIndex[ BIGMALE ][ BODYEXPLODING ]									= BODYEXPLODE;
	gubAnimSurfaceIndex[ BIGMALE ][ CROUCHED_BURST ]								= BGMCROUCHAIM;
	gubAnimSurfaceIndex[ BIGMALE ][ PRONE_BURST ]										= BGMPRONE;
	gubAnimSurfaceIndex[ BIGMALE ][ BIGBUY_FLEX ]										= BGMFLEX;
	gubAnimSurfaceIndex[ BIGMALE ][ BIGBUY_STRECH ]									= BGMSTRECH;
	gubAnimSurfaceIndex[ BIGMALE ][ BIGBUY_SHOEDUST ]								= BGMSHOEDUST;
	gubAnimSurfaceIndex[ BIGMALE ][ BIGBUY_HEADTURN ]								= BGMHEADTURN;
	gubAnimSurfaceIndex[ BIGMALE ][ GIVE_ITEM ]											= BGMOPEN;
	gubAnimSurfaceIndex[ BIGMALE ][ WATER_HIT ]											= BGMWATER_DIE;
	gubAnimSurfaceIndex[ BIGMALE ][ WATER_DIE]											= BGMWATER_DIE;
	gubAnimSurfaceIndex[ BIGMALE ][ WATER_DIE_STOP ]								= BGMWATER_DIE;
	gubAnimSurfaceIndex[ BIGMALE ][ HELIDROP ]											= BGMHELIDROP;
	gubAnimSurfaceIndex[ BIGMALE ][ END_OPEN_DOOR ]									= BGMOPEN;
	gubAnimSurfaceIndex[ BIGMALE ][ END_OPEN_LOCKED_DOOR ]					= BGMOPEN;
	gubAnimSurfaceIndex[ BIGMALE ][ KICK_DOOR ]											= BGMKICKDOOR;
	gubAnimSurfaceIndex[ BIGMALE ][ CLOSE_DOOR ]										= BGMOPEN;
	gubAnimSurfaceIndex[ BIGMALE ][ RIFLE_STAND_HIT ]								= BGMRHIT;
	gubAnimSurfaceIndex[ BIGMALE ][ DEEP_WATER_TRED ]								= BGMDEEPWATER_TRED;
	gubAnimSurfaceIndex[ BIGMALE ][ DEEP_WATER_SWIM ]								= BGMDEEPWATER_SWIM;
	gubAnimSurfaceIndex[ BIGMALE ][ DEEP_WATER_HIT ]								= BGMDEEPWATER_DIE;
	gubAnimSurfaceIndex[ BIGMALE ][ DEEP_WATER_DIE]									= BGMDEEPWATER_DIE;
	gubAnimSurfaceIndex[ BIGMALE ][ DEEP_WATER_DIE_STOPPING ]				= BGMWATER_DIE;
	gubAnimSurfaceIndex[ BIGMALE ][ DEEP_WATER_DIE_STOP ]						= BGMWATER_DIE;
	gubAnimSurfaceIndex[ BIGMALE ][ LOW_TO_DEEP_WATER ]							= BGMWATER_TRANS;
	gubAnimSurfaceIndex[ BIGMALE ][ DEEP_TO_LOW_WATER ]							= BGMWATER_TRANS;
	gubAnimSurfaceIndex[ BIGMALE ][ GOTO_SLEEP ]										= BGMSLEEP;
	gubAnimSurfaceIndex[ BIGMALE ][ SLEEPING ]											= BGMSLEEP;
	gubAnimSurfaceIndex[ BIGMALE ][ WKAEUP_FROM_SLEEP ]							= BGMSLEEP;
	gubAnimSurfaceIndex[ BIGMALE ][ FIRE_LOW_STAND ]								= BGMSHOOT_LOW;
	gubAnimSurfaceIndex[ BIGMALE ][ FIRE_BURST_LOW_STAND ]					= BGMSHOOT_LOW;
	gubAnimSurfaceIndex[ BIGMALE ][ STANDING_SHOOT_UNJAM ]					= BGMSTANDAIM;
	gubAnimSurfaceIndex[ BIGMALE ][ CROUCH_SHOOT_UNJAM ]						= BGMCROUCHAIM;
	gubAnimSurfaceIndex[ BIGMALE ][ PRONE_SHOOT_UNJAM ]							= BGMPRONE;
	gubAnimSurfaceIndex[ BIGMALE ][ STANDING_SHOOT_DWEL_UNJAM ]		= BGMSTANDDWALAIM;
	gubAnimSurfaceIndex[ BIGMALE ][ STANDING_SHOOT_LOW_UNJAM ]		= BGMSHOOT_LOW;
	gubAnimSurfaceIndex[ BIGMALE ][ READY_DUAL_CROUCH ]							= BGMCDBLSHOT;
	gubAnimSurfaceIndex[ BIGMALE ][ AIM_DUAL_CROUCH ]								= BGMCDBLSHOT;
	gubAnimSurfaceIndex[ BIGMALE ][ SHOOT_DUAL_CROUCH ]							= BGMCDBLSHOT;
	gubAnimSurfaceIndex[ BIGMALE ][ END_DUAL_CROUCH ]								= BGMCDBLSHOT;
	gubAnimSurfaceIndex[ BIGMALE ][ CROUCH_SHOOT_DWEL_UNJAM ]				= BGMCDBLSHOT;
	gubAnimSurfaceIndex[ BIGMALE ][ ADJACENT_GET_ITEM ]							= BGMOPEN;
	gubAnimSurfaceIndex[ BIGMALE ][ CUTTING_FENCE ]									= BGMMEDIC;
	gubAnimSurfaceIndex[ BIGMALE ][ FROM_INJURED_TRANSITION ]				= BGMHURTTRANS;
	gubAnimSurfaceIndex[ BIGMALE ][ THROW_KNIFE ]										= BGMTHROWKNIFE;
	gubAnimSurfaceIndex[ BIGMALE ][ THROW_KNIFE_SP_BM ]										= BGMTHROWKNIFE2;
	gubAnimSurfaceIndex[ BIGMALE ][ KNIFE_BREATH ]									= BGMBREATHKNIFE;
	gubAnimSurfaceIndex[ BIGMALE ][ KNIFE_GOTOBREATH ]							= BGMBREATHKNIFE;
	gubAnimSurfaceIndex[ BIGMALE ][ KNIFE_ENDBREATH ]								= BGMBREATHKNIFE;
	gubAnimSurfaceIndex[ BIGMALE ][ CATCH_STANDING ]								= BGMOPEN;
	gubAnimSurfaceIndex[ BIGMALE ][ CATCH_CROUCHED ]								= BGMMEDIC;
	gubAnimSurfaceIndex[ BIGMALE ][ PLANT_BOMB ]										= BGMPICKUP;
	gubAnimSurfaceIndex[ BIGMALE ][ USE_REMOTE ]										= BGMUSEREMOTE;
	gubAnimSurfaceIndex[ BIGMALE ][ START_COWER ]										= BGMCOWER;
	gubAnimSurfaceIndex[ BIGMALE ][ COWERING ]											= BGMCOWER;
	gubAnimSurfaceIndex[ BIGMALE ][ END_COWER ]											= BGMCOWER;
	gubAnimSurfaceIndex[ BIGMALE ][ STEAL_ITEM ]										= BGMOPEN;
	gubAnimSurfaceIndex[ BIGMALE ][ SHOOT_ROCKET ]									= BGMROCKET;
	gubAnimSurfaceIndex[ BIGMALE ][ SHOOT_MORTAR ]									= BGMMORTAR;
	gubAnimSurfaceIndex[ BIGMALE ][ SIDE_STEP ]											= BGMSIDESTEP;
	gubAnimSurfaceIndex[ BIGMALE ][ WALK_BACKWARDS ]								= BGMWALKING;
	gubAnimSurfaceIndex[ BIGMALE ][ BEGIN_OPENSTRUCT ]							= BGMOPEN;
	gubAnimSurfaceIndex[ BIGMALE ][ END_OPENSTRUCT ]								= BGMOPEN;
	gubAnimSurfaceIndex[ BIGMALE ][ END_OPENSTRUCT_LOCKED ]					= BGMOPEN;
	gubAnimSurfaceIndex[ BIGMALE ][ PUNCH_LOW ]											= BGMPUNCHLOW;
	gubAnimSurfaceIndex[ BIGMALE ][ PISTOL_SHOOT_LOW ]							= BGMPISTOLSHOOTLOW;
	gubAnimSurfaceIndex[ BIGMALE ][ DECAPITATE ]										= BGMCSTAB;
	gubAnimSurfaceIndex[ BIGMALE ][ BIGMERC_IDLE_NECK ]							= BGMIDLENECK;
	gubAnimSurfaceIndex[ BIGMALE ][ BIGMERC_CROUCH_TRANS_INTO ]			= BGMCROUCHTRANS;
	gubAnimSurfaceIndex[ BIGMALE ][ BIGMERC_CROUCH_TRANS_OUTOF ]		= BGMCROUCHTRANS;
	gubAnimSurfaceIndex[ BIGMALE ][ GOTO_PATIENT ]									= BGMHITPRONE;
	gubAnimSurfaceIndex[ BIGMALE ][ BEING_PATIENT ]									= BGMHITPRONE;
	gubAnimSurfaceIndex[ BIGMALE ][ GOTO_DOCTOR ]										= BGMMEDIC;
	gubAnimSurfaceIndex[ BIGMALE ][ BEING_DOCTOR ]									= BGMMEDIC;
	gubAnimSurfaceIndex[ BIGMALE ][ END_DOCTOR ]										= BGMMEDIC;
	gubAnimSurfaceIndex[ BIGMALE ][ GOTO_REPAIRMAN ]								= BGMMEDIC;
	gubAnimSurfaceIndex[ BIGMALE ][ BEING_REPAIRMAN ]								= BGMMEDIC;
	gubAnimSurfaceIndex[ BIGMALE ][ END_REPAIRMAN ]									= BGMMEDIC;
	gubAnimSurfaceIndex[ BIGMALE ][ FALL_INTO_PIT ]									= BGMFALL;
	gubAnimSurfaceIndex[ BIGMALE ][ RELOAD_ROBOT ]									= BGMMEDIC;
	gubAnimSurfaceIndex[ BIGMALE ][ END_CATCH ]											= BGMOPEN;
	gubAnimSurfaceIndex[ BIGMALE ][ END_CROUCH_CATCH ]							= BGMMEDIC;
	gubAnimSurfaceIndex[ BIGMALE ][ AI_RADIO ]											= BGMRADIO;
	gubAnimSurfaceIndex[ BIGMALE ][ AI_CR_RADIO ]										= BGMCRRADIO;
	gubAnimSurfaceIndex[ BIGMALE ][ TAKE_BLOOD_FROM_CORPSE ]				= BGMMEDIC;
	gubAnimSurfaceIndex[ BIGMALE ][ CHARIOTS_OF_FIRE ]							= RGMBURN;
	gubAnimSurfaceIndex[ BIGMALE ][ AI_PULL_SWITCH ]								= BGMOPEN;
	gubAnimSurfaceIndex[ BIGMALE ][ MERC_HURT_IDLE_ANIM ]						= BGMHURTSTANDINGR;
	gubAnimSurfaceIndex[ BIGMALE ][ END_HURT_WALKING ]							= BGMHURTSTANDINGR;
	gubAnimSurfaceIndex[ BIGMALE ][ PASS_OBJECT ]										= BGMOPEN;
	gubAnimSurfaceIndex[ BIGMALE ][ DROP_ADJACENT_OBJECT ]					= BGMOPEN;
	gubAnimSurfaceIndex[ BIGMALE ][ READY_DUAL_PRONE ]							= BGMDWPRONE;
	gubAnimSurfaceIndex[ BIGMALE ][ AIM_DUAL_PRONE ]								= BGMDWPRONE;
	gubAnimSurfaceIndex[ BIGMALE ][ SHOOT_DUAL_PRONE ]							= BGMDWPRONE;
	gubAnimSurfaceIndex[ BIGMALE ][ END_DUAL_PRONE ]								= BGMDWPRONE;
	gubAnimSurfaceIndex[ BIGMALE ][ PRONE_SHOOT_DWEL_UNJAM ]			= BGMDWPRONE;
	gubAnimSurfaceIndex[ BIGMALE ][ PICK_LOCK ]										= BGMOPEN;
	gubAnimSurfaceIndex[ BIGMALE ][ OPEN_DOOR_CROUCHED ]						= BGMMEDIC;
	gubAnimSurfaceIndex[ BIGMALE ][ BEGIN_OPENSTRUCT_CROUCHED ]			= BGMMEDIC;
	gubAnimSurfaceIndex[ BIGMALE ][ CLOSE_DOOR_CROUCHED ]						= BGMMEDIC;
	gubAnimSurfaceIndex[ BIGMALE ][ OPEN_STRUCT_CROUCHED ]					= BGMMEDIC;
	gubAnimSurfaceIndex[ BIGMALE ][ END_OPEN_DOOR_CROUCHED ]				= BGMMEDIC;
	gubAnimSurfaceIndex[ BIGMALE ][ END_OPENSTRUCT_CROUCHED ]				= BGMMEDIC;
	gubAnimSurfaceIndex[ BIGMALE ][ END_OPEN_LOCKED_DOOR_CROUCHED ]	= BGMMEDIC;
	gubAnimSurfaceIndex[ BIGMALE ][ END_OPENSTRUCT_LOCKED_CROUCHED ]= BGMMEDIC;
	gubAnimSurfaceIndex[ BIGMALE ][ DRUNK_IDLE ]										= BGMDRUNK;
	gubAnimSurfaceIndex[ BIGMALE ][ CROWBAR_ATTACK ]								= BGMCROWBAR;
	gubAnimSurfaceIndex[ BIGMALE ][ ATTACH_CAN_TO_STRING ]					= BGMMEDIC;
	gubAnimSurfaceIndex[ BIGMALE ][ SWAT_BACKWARDS ]								= BGMSNEAKING;
	gubAnimSurfaceIndex[ BIGMALE ][ JUMP_OVER_BLOCKING_PERSON ]			= BGMJUMPOVER;
	gubAnimSurfaceIndex[ BIGMALE ][ REFUEL_VEHICLE ]								= BGMMEDIC;
	gubAnimSurfaceIndex[ BIGMALE ][ LOCKPICK_CROUCHED ]						= BGMMEDIC;

	//<SB> crouch throwing
	gubAnimSurfaceIndex[ BIGMALE ][ THROW_ITEM_CROUCHED ]					= BGMCRTHROW;
	//</SB> //dddd
	gubAnimSurfaceIndex[ BIGMALE ][ BIGGUY_STONE ]							= BGMWITHSTONE;
	gubAnimSurfaceIndex[ BIGMALE ][ SHOOT_ROCKET_CROUCHED ]					= BGMCRROCKET;
	gubAnimSurfaceIndex[ BIGMALE ][ SWATTING_WK ]							= BGMSWKNIFE;
	gubAnimSurfaceIndex[ BIGMALE ][ SWAT_BACKWARDS_WK ]						= BGMSWKNIFE;
	gubAnimSurfaceIndex[ BIGMALE ][ SWAT_BACKWARDS_NOTHING ]				= BGMNOTHING_SWAT;
	//Throwing Grenades
	gubAnimSurfaceIndex[ BIGMALE ][ THROW_GRENADE_STANCE ]				= BGMSTHRG;
	gubAnimSurfaceIndex[ BIGMALE ][ LOB_GRENADE_STANCE ]				= BGMSLOBG;
	//Rolling
	gubAnimSurfaceIndex[ BIGMALE ][ ROLL_PRONE_L ]					  	= BGMROLL_PR;
	gubAnimSurfaceIndex[ BIGMALE ][ ROLL_PRONE_R ]					  	= BGMROLL_PR;
	
	gubAnimSurfaceIndex[ BIGMALE ][ JUMPUPWALL ]						= BGMWALLJUMP;
	gubAnimSurfaceIndex[ BIGMALE ][ JUMPDOWNWALL ]					= BGMWALLJUMP;
	
	gubAnimSurfaceIndex[ BIGMALE ][ JUMPWINDOWS ]					= BGMJUMPWINDOWS;

	gubAnimSurfaceIndex[ BIGMALE ][ SIDE_STEP_WEAPON_RDY ]				= BGMSIDESTEP_R_RDY;
	gubAnimSurfaceIndex[ BIGMALE ][ SIDE_STEP_DUAL_RDY ]				= BGMSIDESTEP_D_RDY;
	
	gubAnimSurfaceIndex[ BIGMALE ][ WALKING_WEAPON_RDY ]					= BGMWALK_R_RDY;
	gubAnimSurfaceIndex[ BIGMALE ][ WALKING_DUAL_RDY ]					= BGMWALK_D_RDY;

	gubAnimSurfaceIndex[ BIGMALE ][ START_AID_PRN ]						= BGMMEDICPRN;
	gubAnimSurfaceIndex[ BIGMALE ][ GIVING_AID_PRN ]					= BGMMEDICPRN;
	gubAnimSurfaceIndex[ BIGMALE ][ END_AID_PRN ]						= BGMMEDICPRN;

	gubAnimSurfaceIndex[ BIGMALE ][ ADJACENT_GET_ITEM_CROUCHED ]		= BGMMEDIC;
	gubAnimSurfaceIndex[ BIGMALE ][ STEAL_ITEM_CROUCHED ]				= BGMMEDIC;

	gubAnimSurfaceIndex[ BIGMALE ][ BURST_DUAL_STAND ]					= BGMSTANDDWALAIM;
	gubAnimSurfaceIndex[ BIGMALE ][ BURST_DUAL_CROUCH ]					= BGMCDBLSHOT;
	gubAnimSurfaceIndex[ BIGMALE ][ BURST_DUAL_PRONE ]					= BGMDWPRONE;

	gubAnimSurfaceIndex[ BIGMALE ][ READY_ALTERNATIVE_STAND ]				= BGM_HIP_AIM;
	gubAnimSurfaceIndex[ BIGMALE ][ AIM_ALTERNATIVE_STAND ]				= BGM_HIP_AIM;
	gubAnimSurfaceIndex[ BIGMALE ][ SHOOT_ALTERNATIVE_STAND ]				= BGM_HIP_AIM;
	gubAnimSurfaceIndex[ BIGMALE ][ BURST_ALTERNATIVE_STAND ]				= BGM_HIP_AIM;
	gubAnimSurfaceIndex[ BIGMALE ][ LOW_SHOT_ALTERNATIVE_STAND ]				= BGMSHOOT_LOW;
	gubAnimSurfaceIndex[ BIGMALE ][ LOW_BURST_ALTERNATIVE_STAND ]			= BGMSHOOT_LOW;
	gubAnimSurfaceIndex[ BIGMALE ][ UNREADY_ALTERNATIVE_STAND ]			= BGM_HIP_AIM;
	gubAnimSurfaceIndex[ BIGMALE ][ UNJAM_ALTERNATIVE_STAND ]				= BGM_HIP_AIM;
	gubAnimSurfaceIndex[ BIGMALE ][ LOW_UNJAM_ALTERNATIVE_STAND ]			= BGMSHOOT_LOW;
	gubAnimSurfaceIndex[ BIGMALE ][ WALKING_ALTERNATIVE_RDY ]			= BGMWALKING;
	gubAnimSurfaceIndex[ BIGMALE ][ SIDE_STEP_ALTERNATIVE_RDY ]			= BGMSIDESTEP;

	gubAnimSurfaceIndex[ BIGMALE ][ START_COWER_CROUCHED ]			= BGMCOWER;
	gubAnimSurfaceIndex[ BIGMALE ][ END_COWER_CROUCHED ]			= BGMCOWER;
	gubAnimSurfaceIndex[ BIGMALE ][ START_COWER_PRONE ]				= BGM_COWER_PRONE;
	gubAnimSurfaceIndex[ BIGMALE ][ COWERING_PRONE ]					= BGM_COWER_PRONE;
	gubAnimSurfaceIndex[ BIGMALE ][ END_COWER_PRONE ]				= BGM_COWER_PRONE;
	
	gubAnimSurfaceIndex[ BIGMALE ][ BIGMERC_IDLE_NECK2 ]						= BGMIDLENECK2;
	
	gubAnimSurfaceIndex[ BIGMALE ][ FOCUSED_PUNCH ]					= BGMPUNCH;
	gubAnimSurfaceIndex[ BIGMALE ][ FOCUSED_STAB ]					= BGMSTAB;
	gubAnimSurfaceIndex[ BIGMALE ][ HTH_KICK ]						= BGMKICKDOOR;
	gubAnimSurfaceIndex[ BIGMALE ][ FOCUSED_HTH_KICK ]				= BGMKICKDOOR;
	
	gubAnimSurfaceIndex[ BIGMALE ][ LONG_JUMP ]			= BGMJUMPOVER;

	gubAnimSurfaceItemSubIndex[ BIGMALE ][ STANDING ]						= BGMPISTOLBREATH;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ WALKING ]							= BGMNOTHING_WALK;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ RUNNING ]							= BGMNOTHING_RUN;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ SWATTING ]						= BGMNOTHING_SWAT;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ START_SWAT ]					= BGMNOTHING_SWAT;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ END_SWAT ]						= BGMNOTHING_SWAT;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ KNEEL_DOWN ]					= BGMNOTHING_CROUCH;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ CROUCHING ]						= BGMNOTHING_CROUCH;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ KNEEL_UP ]						= BGMNOTHING_CROUCH;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ READY_RIFLE_STAND ]				= BGMHANDGUN_S_SHOT;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ AIM_RIFLE_STAND ]					= BGMHANDGUN_S_SHOT;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ SHOOT_RIFLE_STAND ]				= BGMHANDGUN_S_SHOT;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ END_RIFLE_STAND ]					= BGMHANDGUN_S_SHOT;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ STANDING_BURST ]						= BGMHANDGUN_S_SHOT;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ FIRE_STAND_BURST_SPREAD ]	= BGMHANDGUN_S_SHOT;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ READY_RIFLE_CROUCH ]				= BGMHANDGUN_C_SHOT;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ AIM_RIFLE_CROUCH ]					= BGMHANDGUN_C_SHOT;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ SHOOT_RIFLE_CROUCH ]				= BGMHANDGUN_C_SHOT;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ END_RIFLE_CROUCH ]					= BGMHANDGUN_C_SHOT;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ PRONE_DOWN ]								= BGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ CRAWLING ]									= BGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ PRONE_UP ]									= BGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ PRONE ]										= BGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ READY_RIFLE_PRONE ]				= BGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ AIM_RIFLE_PRONE ]					= BGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ SHOOT_RIFLE_PRONE ]				= BGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ END_RIFLE_PRONE ]					= BGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ GETUP_FROM_ROLLOVER ]			= BGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ STANDING_SHOOT_UNJAM ]			= BGMHANDGUN_S_SHOT;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ CROUCH_SHOOT_UNJAM ]				= BGMHANDGUN_C_SHOT;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ PRONE_SHOOT_UNJAM ]				= BGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ FIRE_BURST_LOW_STAND ]			= BGMPISTOLSHOOTLOW;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ FIRE_LOW_STAND ]						= BGMPISTOLSHOOTLOW;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ CROUCHED_BURST ]						= BGMHANDGUN_C_SHOT;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ PRONE_BURST ]							= BGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ MERC_HURT_IDLE_ANIM ]			= BGMHURTSTANDINGN;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ END_HURT_WALKING ]					= BGMHURTSTANDINGN;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ WALK_BACKWARDS ]						= BGMNOTHING_WALK;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ DRUNK_IDLE ]								= BGMPISTOLDRUNK;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ RUNNING_W_PISTOL ]					= BGMPISTOL_RUN;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ SIDE_STEP_WEAPON_RDY ]				= BGMSIDESTEP_P_RDY;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ WALKING_WEAPON_RDY ]					= BGMWALK_P_RDY;

	gubAnimSurfaceItemSubIndex[ BIGMALE ][ READY_ALTERNATIVE_STAND ]			= BGM_PFSHOT_AIM;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ AIM_ALTERNATIVE_STAND ]			= BGM_PFSHOT_AIM;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ SHOOT_ALTERNATIVE_STAND ]			= BGM_PFSHOT_AIM;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ BURST_ALTERNATIVE_STAND ]			= BGM_PFSHOT_AIM;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ LOW_SHOT_ALTERNATIVE_STAND ]			= BGMPISTOLSHOOTLOW;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ LOW_BURST_ALTERNATIVE_STAND ]		= BGMPISTOLSHOOTLOW;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ UNREADY_ALTERNATIVE_STAND ]		= BGM_PFSHOT_AIM;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ UNJAM_ALTERNATIVE_STAND ]			= BGM_PFSHOT_AIM;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ LOW_UNJAM_ALTERNATIVE_STAND ]		= BGMPISTOLSHOOTLOW;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ WALKING_ALTERNATIVE_RDY ]		= BGMWALK_P_RDY;
	gubAnimSurfaceItemSubIndex[ BIGMALE ][ SIDE_STEP_ALTERNATIVE_RDY ]		= BGMSIDESTEP_P_RDY;

	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ STANDING][0]									= BGMWATER_R_STD;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ WALKING ][0]									= BGMWATER_R_WALK;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ RUNNING ][0]									= BGMWATER_R_WALK;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ READY_RIFLE_STAND ][0]				= BGMWATER_R_AIM;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ AIM_RIFLE_STAND ][0]					= BGMWATER_R_AIM;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ SHOOT_RIFLE_STAND ][0]				= BGMWATER_R_AIM;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ END_RIFLE_STAND ][0]					= BGMWATER_R_AIM;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ STANDING_BURST ][0]					= BGMWATER_R_AIM;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ FIRE_STAND_BURST_SPREAD ][0]	= BGMWATER_R_AIM;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ STANDING][1]									= BGMWATER_N_STD;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ WALKING ][1]									= BGMWATER_N_WALK;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ RUNNING ][1]									= BGMWATER_N_WALK;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ READY_RIFLE_STAND ][1]				= BGMWATER_N_AIM;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ AIM_RIFLE_STAND ][1]					= BGMWATER_N_AIM;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ SHOOT_RIFLE_STAND ][1]				= BGMWATER_N_AIM;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ END_RIFLE_STAND ][1]					= BGMWATER_N_AIM;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ STANDING_BURST ][1]					= BGMWATER_N_AIM;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ FIRE_STAND_BURST_SPREAD ][1]	= BGMWATER_N_AIM;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ READY_DUAL_STAND ][1]				= BGMWATER_DBLSHT;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ AIM_DUAL_STAND ][1]					= BGMWATER_DBLSHT;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ SHOOT_DUAL_STAND ][1]				= BGMWATER_DBLSHT;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ END_DUAL_STAND ][1]					= BGMWATER_DBLSHT;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ STANDING_SHOOT_UNJAM ][0]		= BGMWATER_R_AIM;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ STANDING_SHOOT_UNJAM ][1]		= BGMWATER_N_AIM;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ THROW_ITEM ][0]							= BGMWATERTHROW;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ THROW_ITEM ][1]							= BGMWATERTHROW;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ LOB_ITEM ][0]								= BGMWATERTHROW;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ LOB_ITEM ][1]								= BGMWATERTHROW;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ BURST_DUAL_STAND ][1]					= BGMWATER_DBLSHT;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ READY_ALTERNATIVE_STAND ][0]					= BGM_WATER_HIP_AIM;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ AIM_ALTERNATIVE_STAND ][0]						= BGM_WATER_HIP_AIM;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ SHOOT_ALTERNATIVE_STAND ][0]					= BGM_WATER_HIP_AIM;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ BURST_ALTERNATIVE_STAND ][0]					= BGM_WATER_HIP_AIM;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ UNREADY_ALTERNATIVE_STAND ][0]					= BGM_WATER_HIP_AIM;
	gubAnimSurfaceMidWaterSubIndex[ BIGMALE ][ UNJAM_ALTERNATIVE_STAND ][0]					= BGM_WATER_HIP_AIM;

	//Setup some random stuff
	gRandomAnimDefs[ BIGMALE ][ 0 ].ubHandRestriction		= RANDOM_ANIM_NOTHINGINHAND;
	gRandomAnimDefs[ BIGMALE ][ 0 ].sAnimID							= BIGBUY_FLEX;
	gRandomAnimDefs[ BIGMALE ][ 0 ].ubStartRoll					= 0;
	gRandomAnimDefs[ BIGMALE ][ 0 ].ubEndRoll						= 9;
	gRandomAnimDefs[ BIGMALE ][ 0 ].ubFlags							= RANDOM_ANIM_CASUAL | RANDOM_ANIM_SHOWOFF;
	gRandomAnimDefs[ BIGMALE ][ 0 ].ubAnimHeight				= ANIM_STAND;

	gRandomAnimDefs[ BIGMALE ][ 1 ].ubHandRestriction		= RANDOM_ANIM_NOTHINGINHAND;
	gRandomAnimDefs[ BIGMALE ][ 1 ].sAnimID							= BIGBUY_STRECH;
	gRandomAnimDefs[ BIGMALE ][ 1 ].ubStartRoll					= 10;
	gRandomAnimDefs[ BIGMALE ][ 1 ].ubEndRoll						= 19;
	gRandomAnimDefs[ BIGMALE ][ 1 ].ubFlags							= RANDOM_ANIM_CASUAL;
	gRandomAnimDefs[ BIGMALE ][ 1 ].ubAnimHeight				= ANIM_STAND;

	gRandomAnimDefs[ BIGMALE ][ 2 ].ubHandRestriction		= RANDOM_ANIM_RIFLEINHAND;
	gRandomAnimDefs[ BIGMALE ][ 2 ].sAnimID							= BIGBUY_SHOEDUST;
	gRandomAnimDefs[ BIGMALE ][ 2 ].ubStartRoll					= 0; //20;
	gRandomAnimDefs[ BIGMALE ][ 2 ].ubEndRoll						= 0; //29;
	gRandomAnimDefs[ BIGMALE ][ 2 ].ubFlags							= RANDOM_ANIM_CASUAL | RANDOM_ANIM_FIRSTBIGMERC;
	gRandomAnimDefs[ BIGMALE ][ 2 ].ubAnimHeight				= ANIM_STAND;

	///ddd big guy with stone
	gRandomAnimDefs[ BIGMALE ][ 3 ].ubHandRestriction		= RANDOM_ANIM_NOTHINGINHAND;
	gRandomAnimDefs[ BIGMALE ][ 3 ].sAnimID							= BIGGUY_STONE;
	gRandomAnimDefs[ BIGMALE ][ 3 ].ubStartRoll					= 30;
	gRandomAnimDefs[ BIGMALE ][ 3 ].ubEndRoll						= 39;
	gRandomAnimDefs[ BIGMALE ][ 3 ].ubFlags							= RANDOM_ANIM_CASUAL ;
	gRandomAnimDefs[ BIGMALE ][ 3 ].ubAnimHeight				= ANIM_STAND;

	gRandomAnimDefs[ BIGMALE ][ 4 ].ubHandRestriction		= RANDOM_ANIM_RIFLEINHAND;
	gRandomAnimDefs[ BIGMALE ][ 4 ].sAnimID							= BIGBUY_HEADTURN;
	gRandomAnimDefs[ BIGMALE ][ 4 ].ubStartRoll					= 30;
	gRandomAnimDefs[ BIGMALE ][ 4 ].ubEndRoll						= 49;
	gRandomAnimDefs[ BIGMALE ][ 4 ].ubFlags							= RANDOM_ANIM_FIRSTBIGMERC | RANDOM_ANIM_LOOKAROUND;
	gRandomAnimDefs[ BIGMALE ][ 4 ].ubAnimHeight				= ANIM_STAND;
	
	gRandomAnimDefs[ BIGMALE ][ 5 ].ubHandRestriction		= RANDOM_ANIM_RIFLEINHAND;
	gRandomAnimDefs[ BIGMALE ][ 5 ].sAnimID							= BIGMERC_IDLE_NECK2;
	gRandomAnimDefs[ BIGMALE ][ 5 ].ubStartRoll					= 50;
	gRandomAnimDefs[ BIGMALE ][ 5 ].ubEndRoll						= 59;
	gRandomAnimDefs[ BIGMALE ][ 5 ].ubFlags							= RANDOM_ANIM_FIRSTBIGMERC;
	gRandomAnimDefs[ BIGMALE ][ 5 ].ubAnimHeight				= ANIM_STAND;
								
	gRandomAnimDefs[ BIGMALE ][ 6 ].ubHandRestriction		= RANDOM_ANIM_RIFLEINHAND;
	gRandomAnimDefs[ BIGMALE ][ 6 ].sAnimID							= BIGMERC_IDLE_NECK;
	gRandomAnimDefs[ BIGMALE ][ 6 ].ubStartRoll					= 50;
	gRandomAnimDefs[ BIGMALE ][ 6 ].ubEndRoll						= 59;
	gRandomAnimDefs[ BIGMALE ][ 6 ].ubFlags							= RANDOM_ANIM_SECONDBIGMERC;
	gRandomAnimDefs[ BIGMALE ][ 6 ].ubAnimHeight				= ANIM_STAND;
								
	gRandomAnimDefs[ BIGMALE ][ 7 ].ubHandRestriction		= RANDOM_ANIM_IRRELEVENTINHAND;
	gRandomAnimDefs[ BIGMALE ][ 7 ].sAnimID							= MERC_HURT_IDLE_ANIM;
	gRandomAnimDefs[ BIGMALE ][ 7 ].ubStartRoll					= 0;
	gRandomAnimDefs[ BIGMALE ][ 7 ].ubEndRoll						= 60;
	gRandomAnimDefs[ BIGMALE ][ 7 ].ubFlags							= RANDOM_ANIM_INJURED;
	gRandomAnimDefs[ BIGMALE ][ 7 ].ubAnimHeight				= ANIM_STAND;
								
	gRandomAnimDefs[ BIGMALE ][ 8 ].ubHandRestriction		= RANDOM_ANIM_IRRELEVENTINHAND;
	gRandomAnimDefs[ BIGMALE ][ 8 ].sAnimID							= DRUNK_IDLE;
	gRandomAnimDefs[ BIGMALE ][ 8 ].ubStartRoll					= 61;
	gRandomAnimDefs[ BIGMALE ][ 8 ].ubEndRoll						= 100;
	gRandomAnimDefs[ BIGMALE ][ 8 ].ubFlags							= RANDOM_ANIM_DRUNK;
	gRandomAnimDefs[ BIGMALE ][ 8 ].ubAnimHeight				= ANIM_STAND;


	gubAnimSurfaceCorpseID[ BIGMALE ][ GENERIC_HIT_DEATH ]						= MMERC_FWD;
	gubAnimSurfaceCorpseID[ BIGMALE ][ FALLBACK_HIT_DEATH ]						= MMERC_BCK;
	gubAnimSurfaceCorpseID[ BIGMALE ][ PRONE_HIT_DEATH ]							= MMERC_PRN;
	gubAnimSurfaceCorpseID[ BIGMALE ][ WATER_DIE ]										= MMERC_WTR;
	gubAnimSurfaceCorpseID[ BIGMALE ][ FLYBACK_HIT_DEATH ]						= MMERC_DHD;
	gubAnimSurfaceCorpseID[ BIGMALE ][ JFK_HITDEATH ]									= MMERC_JFK;
	gubAnimSurfaceCorpseID[ BIGMALE ][ FALLOFF_DEATH ]								= MMERC_FALL;
	gubAnimSurfaceCorpseID[ BIGMALE ][ FALLOFF_FORWARD_DEATH ]				= MMERC_FALLF;
	gubAnimSurfaceCorpseID[ BIGMALE ][ FLYBACK_HIT ]									= MMERC_DHD;
	gubAnimSurfaceCorpseID[ BIGMALE ][ GENERIC_HIT_DEATHTWITCHNB ]		= MMERC_FWD;
	gubAnimSurfaceCorpseID[ BIGMALE ][ FALLFORWARD_FROMHIT_STAND ]		= MMERC_FWD;
	gubAnimSurfaceCorpseID[ BIGMALE ][ ENDFALLFORWARD_FROMHIT_CROUCH ]= MMERC_FWD;
	gubAnimSurfaceCorpseID[ BIGMALE ][ FALLBACK_HIT_STAND ]						= MMERC_BCK;
	gubAnimSurfaceCorpseID[ BIGMALE ][ FALLBACK_HIT_DEATHTWITCHNB ]		= MMERC_BCK;
	gubAnimSurfaceCorpseID[ BIGMALE ][ PRONE_HIT_DEATHTWITCHNB ]			= MMERC_PRN;
	gubAnimSurfaceCorpseID[ BIGMALE ][ PRONE_LAY_FROMHIT ]						= MMERC_PRN;
	gubAnimSurfaceCorpseID[ BIGMALE ][ FALLOFF ]											= MMERC_FALLF;
	gubAnimSurfaceCorpseID[ BIGMALE ][ FALLFORWARD_ROOF ]							= MMERC_FALL;
	gubAnimSurfaceCorpseID[ BIGMALE ][ FLYBACKHIT_STOP ]							= MMERC_DHD;
	gubAnimSurfaceCorpseID[ BIGMALE ][ STAND_FALLFORWARD_STOP ]				= MMERC_FWD;
	gubAnimSurfaceCorpseID[ BIGMALE ][ FALLBACKHIT_STOP ]							= MMERC_BCK;
	gubAnimSurfaceCorpseID[ BIGMALE ][ PRONE_LAYFROMHIT_STOP ]				= MMERC_PRN;
	gubAnimSurfaceCorpseID[ BIGMALE ][ CHARIOTS_OF_FIRE ]							= BURNT_DEAD;
	gubAnimSurfaceCorpseID[ BIGMALE ][ BODYEXPLODING ]								= EXPLODE_DEAD;


	// STOCKY MALE GUY
	gubAnimSurfaceIndex[ STOCKYMALE ][ WALKING ]								= RGMBASICWALKING;
	gubAnimSurfaceIndex[ STOCKYMALE ][ STANDING ]							= RGMSTANDING;
	gubAnimSurfaceIndex[ STOCKYMALE ][ KNEEL_DOWN ]						= RGMCROUCHING;
	gubAnimSurfaceIndex[ STOCKYMALE ][ CROUCHING ]							= RGMCROUCHING;
	gubAnimSurfaceIndex[ STOCKYMALE ][ KNEEL_UP ]							= RGMCROUCHING;
	gubAnimSurfaceIndex[ STOCKYMALE ][ SWATTING ]							= RGMSNEAKING;
	gubAnimSurfaceIndex[ STOCKYMALE ][ RUNNING ]								= RGMRUNNING;
	gubAnimSurfaceIndex[ STOCKYMALE ][ PRONE_DOWN ]						= RGMPRONE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ CRAWLING ]							= RGMPRONE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ PRONE_UP ]							= RGMPRONE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ PRONE ]									= RGMPRONE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ READY_RIFLE_STAND ]			= RGMSTANDAIM;
	gubAnimSurfaceIndex[ STOCKYMALE ][ AIM_RIFLE_STAND ]				= RGMSTANDAIM;
	gubAnimSurfaceIndex[ STOCKYMALE ][ SHOOT_RIFLE_STAND ]			= RGMSTANDAIM;
	gubAnimSurfaceIndex[ STOCKYMALE ][ END_RIFLE_STAND ]				= RGMSTANDAIM;
	gubAnimSurfaceIndex[ STOCKYMALE ][ START_SWAT ]						= RGMSNEAKING;
	gubAnimSurfaceIndex[ STOCKYMALE ][ END_SWAT ]							= RGMSNEAKING;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FLYBACK_HIT ]						= RGMHITHARD;
	gubAnimSurfaceIndex[ STOCKYMALE ][ READY_RIFLE_PRONE ]			= RGMPRONE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ AIM_RIFLE_PRONE ]				= RGMPRONE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ SHOOT_RIFLE_PRONE ]			= RGMPRONE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ END_RIFLE_PRONE ]				= RGMPRONE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FALLBACK_DEATHTWICH ]		= RGMHITHARD;
	gubAnimSurfaceIndex[ STOCKYMALE ][ GENERIC_HIT_STAND ]			= RGMHITSTAND;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FLYBACK_HIT_BLOOD_STAND ]		= RGMHITHARDBLOOD;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FLYBACK_HIT_DEATH ]			= RGMHITHARD;
	gubAnimSurfaceIndex[ STOCKYMALE ][ READY_RIFLE_CROUCH ]		= RGMCROUCHAIM;
	gubAnimSurfaceIndex[ STOCKYMALE ][ AIM_RIFLE_CROUCH ]			= RGMCROUCHAIM;
	gubAnimSurfaceIndex[ STOCKYMALE ][ SHOOT_RIFLE_CROUCH ]		= RGMCROUCHAIM;
	gubAnimSurfaceIndex[ STOCKYMALE ][ END_RIFLE_CROUCH ]			= RGMCROUCHAIM;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FALLBACK_HIT_STAND ]		= RGMHITFALLBACK;
	gubAnimSurfaceIndex[ STOCKYMALE ][ ROLLOVER ]							= RGMROLLOVER;
	gubAnimSurfaceIndex[ STOCKYMALE ][ CLIMBUPROOF ]						= RGMCLIMBROOF;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FALLOFF ]								= RGMFALL;
	gubAnimSurfaceIndex[ STOCKYMALE ][ GETUP_FROM_ROLLOVER ]		= RGMPRONE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ CLIMBDOWNROOF ]					= RGMCLIMBROOF;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FALLFORWARD_ROOF ]						= RGMFALLF;
	gubAnimSurfaceIndex[ STOCKYMALE ][ GENERIC_HIT_DEATHTWITCHNB ]		= RGMHITSTAND;
	gubAnimSurfaceIndex[ STOCKYMALE ][ GENERIC_HIT_DEATHTWITCHB ]		= RGMHITSTAND;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FALLBACK_HIT_DEATHTWITCHNB ]	= RGMHITFALLBACK;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FALLBACK_HIT_DEATHTWITCHB ]		= RGMHITFALLBACK;
	gubAnimSurfaceIndex[ STOCKYMALE ][ GENERIC_HIT_DEATH ]			= RGMHITSTAND;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FALLBACK_HIT_DEATH ]		= RGMHITFALLBACK;
	gubAnimSurfaceIndex[ STOCKYMALE ][ GENERIC_HIT_CROUCH ]		= RGMHITCROUCH;
	gubAnimSurfaceIndex[ STOCKYMALE ][ STANDING_BURST ]				= RGMSTANDAIM;
	gubAnimSurfaceIndex[ STOCKYMALE ][ STANDING_BURST_HIT ]		= RGMHITHARD;
	gubAnimSurfaceIndex[ STOCKYMALE ][ GENERIC_HIT_DEATH ]			= RGMHITSTAND;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FALLFORWARD_FROMHIT_STAND ]		= RGMHITSTAND;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FALLFORWARD_FROMHIT_STAND ]				= RGMHITSTAND;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FALLFORWARD_FROMHIT_CROUCH ]			= RGMHITCROUCH;
	gubAnimSurfaceIndex[ STOCKYMALE ][ ENDFALLFORWARD_FROMHIT_CROUCH ]		= RGMHITSTAND;
	gubAnimSurfaceIndex[ STOCKYMALE ][ GENERIC_HIT_PRONE ]			= RGMHITPRONE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ PRONE_HIT_DEATH ]				= RGMHITPRONE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ PRONE_LAY_FROMHIT ]			= RGMHITPRONE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ PRONE_HIT_DEATHTWITCHNB ]					= RGMHITPRONE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ PRONE_HIT_DEATHTWITCHB ]					= RGMHITPRONE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FLYBACK_HITDEATH_STOP ]					= RGMHITHARD;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FALLFORWARD_HITDEATH_STOP ]			= RGMHITSTAND;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FALLBACK_HITDEATH_STOP ]				= RGMHITFALLBACK;
	gubAnimSurfaceIndex[ STOCKYMALE ][ PRONE_HITDEATH_STOP ]						= RGMHITPRONE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FLYBACKHIT_STOP ]								= RGMHITHARD;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FALLBACKHIT_STOP ]							= RGMHITFALLBACK;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FALLOFF_STOP ]									= RGMFALL;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FALLOFF_FORWARD_STOP ]					= RGMFALLF;
	gubAnimSurfaceIndex[ STOCKYMALE ][ STAND_FALLFORWARD_STOP ]				= RGMHITSTAND;
	gubAnimSurfaceIndex[ STOCKYMALE ][ PRONE_LAYFROMHIT_STOP ]					= RGMHITPRONE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ HOPFENCE ]											= RGMHOPFENCE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ PUNCH_BREATH ]									= RGMPUNCH;
	gubAnimSurfaceIndex[ STOCKYMALE ][ PUNCH ]												= RGMPUNCH;
	gubAnimSurfaceIndex[ STOCKYMALE ][ NOTHING_STAND ]								= RGMNOTHING_STD;
	gubAnimSurfaceIndex[ STOCKYMALE ][ JFK_HITDEATH ]									= RGMDIE_JFK;
	gubAnimSurfaceIndex[ STOCKYMALE ][ JFK_HITDEATH_STOP ]							= RGMDIE_JFK;
	gubAnimSurfaceIndex[ STOCKYMALE ][ JFK_HITDEATH_TWITCHB ]					= RGMDIE_JFK;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FIRE_STAND_BURST_SPREAD ]			= RGMSTANDAIM;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FALLOFF_DEATH ]								= RGMFALL;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FALLOFF_DEATH_STOP ]						= RGMFALL;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FALLOFF_TWITCHB ]							= RGMFALL;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FALLOFF_TWITCHNB ]							= RGMFALL;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FALLOFF_FORWARD_DEATH ]				= RGMFALLF;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FALLOFF_FORWARD_DEATH_STOP ]		= RGMFALLF;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FALLOFF_FORWARD_TWITCHB ]			= RGMFALLF;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FALLOFF_FORWARD_TWITCHNB ]			= RGMFALLF;
	gubAnimSurfaceIndex[ STOCKYMALE ][ OPEN_DOOR ]											= RGMOPEN;
	gubAnimSurfaceIndex[ STOCKYMALE ][ OPEN_STRUCT ]										= RGMOPEN;
	gubAnimSurfaceIndex[ STOCKYMALE ][ PICKUP_ITEM ]										= RGMPICKUP;
	gubAnimSurfaceIndex[ STOCKYMALE ][ DROP_ITEM ]											= RGMPICKUP;
	gubAnimSurfaceIndex[ STOCKYMALE ][ SLICE ]													= RGMSLICE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ STAB ]														= RGMSTAB;
	gubAnimSurfaceIndex[ STOCKYMALE ][ CROUCH_STAB ]										= RGMCSTAB;
	gubAnimSurfaceIndex[ STOCKYMALE ][ START_AID ]											= RGMMEDIC;
	gubAnimSurfaceIndex[ STOCKYMALE ][ GIVING_AID ]										= RGMMEDIC;
	gubAnimSurfaceIndex[ STOCKYMALE ][ END_AID ]												= RGMMEDIC;
	gubAnimSurfaceIndex[ STOCKYMALE ][ DODGE_ONE ]											= RGMDODGE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ READY_DUAL_STAND ]								= RGMSTANDDWALAIM;
	gubAnimSurfaceIndex[ STOCKYMALE ][ AIM_DUAL_STAND ]									= RGMSTANDDWALAIM;
	gubAnimSurfaceIndex[ STOCKYMALE ][ SHOOT_DUAL_STAND ]								= RGMSTANDDWALAIM;
	gubAnimSurfaceIndex[ STOCKYMALE ][ END_DUAL_STAND ]									= RGMSTANDDWALAIM;
	gubAnimSurfaceIndex[ STOCKYMALE ][ RAISE_RIFLE ]										= RGMRAISE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ LOWER_RIFLE ]										= RGMRAISE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ BODYEXPLODING ]									= BODYEXPLODE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ THROW_ITEM ]											= RGMTHROW;
	gubAnimSurfaceIndex[ STOCKYMALE ][ LOB_ITEM ]												= RGMLOB;
	gubAnimSurfaceIndex[ STOCKYMALE ][ CROUCHED_BURST ]									= RGMCROUCHAIM;
	gubAnimSurfaceIndex[ STOCKYMALE ][ PRONE_BURST ]										= RGMPRONE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ GIVE_ITEM ]											= RGMOPEN;
	gubAnimSurfaceIndex[ STOCKYMALE ][ WATER_HIT ]											= RGMWATER_DIE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ WATER_DIE]												= RGMWATER_DIE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ WATER_DIE_STOP ]									= RGMWATER_DIE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ HELIDROP ]												= RGMHELIDROP;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FEM_LOOK ]												= RGM_LOOK;
	gubAnimSurfaceIndex[ STOCKYMALE ][ REG_SQUISH ]											= RGM_SQUISH;
	gubAnimSurfaceIndex[ STOCKYMALE ][ REG_PULL ]												= RGM_PULL;
	gubAnimSurfaceIndex[ STOCKYMALE ][ REG_SPIT ]												= RGM_SPIT;
	gubAnimSurfaceIndex[ STOCKYMALE ][ NINJA_GOTOBREATH ]								= RGMLOWKICK;
	gubAnimSurfaceIndex[ STOCKYMALE ][ NINJA_BREATH ]										= RGMLOWKICK;
	gubAnimSurfaceIndex[ STOCKYMALE ][ NINJA_LOWKICK ]									= RGMLOWKICK;
	gubAnimSurfaceIndex[ STOCKYMALE ][ NINJA_PUNCH ]										= RGMNPUNCH;
	gubAnimSurfaceIndex[ STOCKYMALE ][ NINJA_SPINKICK ]									= RGMSPINKICK;
	gubAnimSurfaceIndex[ STOCKYMALE ][ END_OPEN_DOOR ]									= RGMOPEN;
	gubAnimSurfaceIndex[ STOCKYMALE ][ END_OPEN_LOCKED_DOOR ]						= RGMOPEN;
	gubAnimSurfaceIndex[ STOCKYMALE ][ KICK_DOOR ]											= RGMKICKDOOR;
	gubAnimSurfaceIndex[ STOCKYMALE ][ CLOSE_DOOR ]											= RGMOPEN;
	gubAnimSurfaceIndex[ STOCKYMALE ][ RIFLE_STAND_HIT ]								= RGMRHIT;
	gubAnimSurfaceIndex[ STOCKYMALE ][ DEEP_WATER_TRED ]								= RGMDEEPWATER_TRED;
	gubAnimSurfaceIndex[ STOCKYMALE ][ DEEP_WATER_SWIM ]								= RGMDEEPWATER_SWIM;
	gubAnimSurfaceIndex[ STOCKYMALE ][ DEEP_WATER_HIT ]									= RGMDEEPWATER_DIE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ DEEP_WATER_DIE]									= RGMDEEPWATER_DIE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ DEEP_WATER_DIE_STOPPING ]				= RGMWATER_DIE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ DEEP_WATER_DIE_STOP ]						= RGMWATER_DIE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ LOW_TO_DEEP_WATER ]							= RGMWATER_TRANS;
	gubAnimSurfaceIndex[ STOCKYMALE ][ DEEP_TO_LOW_WATER ]							= RGMWATER_TRANS;
	gubAnimSurfaceIndex[ STOCKYMALE ][ GOTO_SLEEP ]											= RGMSLEEP;
	gubAnimSurfaceIndex[ STOCKYMALE ][ SLEEPING ]												= RGMSLEEP;
	gubAnimSurfaceIndex[ STOCKYMALE ][ WKAEUP_FROM_SLEEP ]							= RGMSLEEP;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FIRE_LOW_STAND ]									= RGMSHOOT_LOW;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FIRE_BURST_LOW_STAND ]						= RGMSHOOT_LOW;
	gubAnimSurfaceIndex[ STOCKYMALE ][ STANDING_SHOOT_UNJAM ]						= RGMSTANDAIM;
	gubAnimSurfaceIndex[ STOCKYMALE ][ CROUCH_SHOOT_UNJAM ]							= RGMCROUCHAIM;
	gubAnimSurfaceIndex[ STOCKYMALE ][ PRONE_SHOOT_UNJAM ]							= RGMPRONE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ STANDING_SHOOT_DWEL_UNJAM ]		= RGMSTANDDWALAIM;
	gubAnimSurfaceIndex[ STOCKYMALE ][ STANDING_SHOOT_LOW_UNJAM ]				= RGMSHOOT_LOW;
	gubAnimSurfaceIndex[ STOCKYMALE ][ READY_DUAL_CROUCH ]							= RGMCDBLSHOT;
	gubAnimSurfaceIndex[ STOCKYMALE ][ AIM_DUAL_CROUCH ]								= RGMCDBLSHOT;
	gubAnimSurfaceIndex[ STOCKYMALE ][ SHOOT_DUAL_CROUCH ]							= RGMCDBLSHOT;
	gubAnimSurfaceIndex[ STOCKYMALE ][ END_DUAL_CROUCH ]								= RGMCDBLSHOT;
	gubAnimSurfaceIndex[ STOCKYMALE ][ CROUCH_SHOOT_DWEL_UNJAM ]				= RGMCDBLSHOT;
	gubAnimSurfaceIndex[ STOCKYMALE ][ ADJACENT_GET_ITEM ]							= RGMOPEN;
	gubAnimSurfaceIndex[ STOCKYMALE ][ CUTTING_FENCE ]									= RGMMEDIC;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FROM_INJURED_TRANSITION ]				= RGMHURTTRANS;
	gubAnimSurfaceIndex[ STOCKYMALE ][ THROW_KNIFE ]										= RGMTHROWKNIFE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ KNIFE_BREATH ]										= RGMBREATHKNIFE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ KNIFE_GOTOBREATH ]								= RGMBREATHKNIFE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ KNIFE_ENDBREATH ]								= RGMBREATHKNIFE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ CATCH_STANDING ]									= RGMOPEN;
	gubAnimSurfaceIndex[ STOCKYMALE ][ CATCH_CROUCHED ]									= RGMMEDIC;
	gubAnimSurfaceIndex[ STOCKYMALE ][ PLANT_BOMB ]											= RGMPICKUP;
	gubAnimSurfaceIndex[ STOCKYMALE ][ USE_REMOTE ]											= RGMUSEREMOTE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ START_COWER ]										= RGMCOWER;
	gubAnimSurfaceIndex[ STOCKYMALE ][ COWERING ]												= RGMCOWER;
	gubAnimSurfaceIndex[ STOCKYMALE ][ END_COWER ]											= RGMCOWER;
	gubAnimSurfaceIndex[ STOCKYMALE ][ STEAL_ITEM ]											= RGMOPEN;
	gubAnimSurfaceIndex[ STOCKYMALE ][ SHOOT_ROCKET ]										= RGMROCKET;
	gubAnimSurfaceIndex[ STOCKYMALE ][ SHOOT_MORTAR ]										= RGMMORTAR;
	gubAnimSurfaceIndex[ STOCKYMALE ][ SIDE_STEP ]											= RGMSIDESTEP;
	gubAnimSurfaceIndex[ STOCKYMALE ][ WALK_BACKWARDS ]									= RGMBASICWALKING;
	gubAnimSurfaceIndex[ STOCKYMALE ][ BEGIN_OPENSTRUCT ]								= RGMOPEN;
	gubAnimSurfaceIndex[ STOCKYMALE ][ END_OPENSTRUCT ]									= RGMOPEN;
	gubAnimSurfaceIndex[ STOCKYMALE ][ END_OPENSTRUCT_LOCKED ]					= RGMOPEN;
	gubAnimSurfaceIndex[ STOCKYMALE ][ PUNCH_LOW ]											= RGMPUNCHLOW;
	gubAnimSurfaceIndex[ STOCKYMALE ][ PISTOL_SHOOT_LOW ]								= RGMPISTOLSHOOTLOW;
	gubAnimSurfaceIndex[ STOCKYMALE ][ DECAPITATE ]											= RGMCSTAB;
	gubAnimSurfaceIndex[ STOCKYMALE ][ GOTO_PATIENT ]										= RGMHITPRONE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ BEING_PATIENT ]									= RGMHITPRONE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ GOTO_DOCTOR ]										= RGMMEDIC;
	gubAnimSurfaceIndex[ STOCKYMALE ][ BEING_DOCTOR ]										= RGMMEDIC;
	gubAnimSurfaceIndex[ STOCKYMALE ][ END_DOCTOR ]											= RGMMEDIC;
	gubAnimSurfaceIndex[ STOCKYMALE ][ GOTO_REPAIRMAN ]									= RGMMEDIC;
	gubAnimSurfaceIndex[ STOCKYMALE ][ BEING_REPAIRMAN ]								= RGMMEDIC;
	gubAnimSurfaceIndex[ STOCKYMALE ][ END_REPAIRMAN ]									= RGMMEDIC;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FALL_INTO_PIT ]									= RGMFALL;
	gubAnimSurfaceIndex[ STOCKYMALE ][ RELOAD_ROBOT ]										= RGMMEDIC;
	gubAnimSurfaceIndex[ STOCKYMALE ][ END_CATCH ]											= RGMOPEN;
	gubAnimSurfaceIndex[ STOCKYMALE ][ END_CROUCH_CATCH ]								= RGMMEDIC;
	gubAnimSurfaceIndex[ STOCKYMALE ][ AI_RADIO ]												= RGMRADIO;
	gubAnimSurfaceIndex[ STOCKYMALE ][ AI_CR_RADIO ]										= RGMCRRADIO;
	gubAnimSurfaceIndex[ STOCKYMALE ][ SLAP_HIT ]												= RGMHITSTAND;
	gubAnimSurfaceIndex[ STOCKYMALE ][ TAKE_BLOOD_FROM_CORPSE ]					= RGMMEDIC;
	gubAnimSurfaceIndex[ STOCKYMALE ][ CHARIOTS_OF_FIRE ]								= RGMBURN;
	gubAnimSurfaceIndex[ STOCKYMALE ][ AI_PULL_SWITCH ]									= RGMOPEN;
	gubAnimSurfaceIndex[ STOCKYMALE ][ MERC_HURT_IDLE_ANIM ]						= RGMHURTSTANDINGR;
	gubAnimSurfaceIndex[ STOCKYMALE ][ END_HURT_WALKING ]								= RGMHURTSTANDINGR;
	gubAnimSurfaceIndex[ STOCKYMALE ][ PASS_OBJECT ]										= RGMOPEN;
	gubAnimSurfaceIndex[ STOCKYMALE ][ DROP_ADJACENT_OBJECT ]						= RGMOPEN;
	gubAnimSurfaceIndex[ STOCKYMALE ][ READY_DUAL_PRONE ]								= RGMDWPRONE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ AIM_DUAL_PRONE ]									= RGMDWPRONE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ SHOOT_DUAL_PRONE ]								= RGMDWPRONE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ END_DUAL_PRONE ]									= RGMDWPRONE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ PRONE_SHOOT_DWEL_UNJAM ]				= RGMDWPRONE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ PICK_LOCK ]										= RGMOPEN;
	gubAnimSurfaceIndex[ STOCKYMALE ][ OPEN_DOOR_CROUCHED ]						= RGMMEDIC;
	gubAnimSurfaceIndex[ STOCKYMALE ][ BEGIN_OPENSTRUCT_CROUCHED ]			= RGMMEDIC;
	gubAnimSurfaceIndex[ STOCKYMALE ][ CLOSE_DOOR_CROUCHED ]						= RGMMEDIC;
	gubAnimSurfaceIndex[ STOCKYMALE ][ OPEN_STRUCT_CROUCHED ]					= RGMMEDIC;
	gubAnimSurfaceIndex[ STOCKYMALE ][ END_OPEN_DOOR_CROUCHED ]				= RGMMEDIC;
	gubAnimSurfaceIndex[ STOCKYMALE ][ END_OPENSTRUCT_CROUCHED ]				= RGMMEDIC;
	gubAnimSurfaceIndex[ STOCKYMALE ][ END_OPEN_LOCKED_DOOR_CROUCHED ]	= RGMMEDIC;
	gubAnimSurfaceIndex[ STOCKYMALE ][ END_OPENSTRUCT_LOCKED_CROUCHED ]= RGMMEDIC;
	gubAnimSurfaceIndex[ STOCKYMALE ][ DRUNK_IDLE ]											= RGMDRUNK;
	gubAnimSurfaceIndex[ STOCKYMALE ][ CROWBAR_ATTACK ]								= RGMCROWBAR;
	gubAnimSurfaceIndex[ STOCKYMALE ][ ATTACH_CAN_TO_STRING ]					= RGMMEDIC;
	gubAnimSurfaceIndex[ STOCKYMALE ][ SWAT_BACKWARDS ]								= RGMSNEAKING;
	gubAnimSurfaceIndex[ STOCKYMALE ][ JUMP_OVER_BLOCKING_PERSON ]		= RGMJUMPOVER;
	gubAnimSurfaceIndex[ STOCKYMALE ][ REFUEL_VEHICLE ]								= RGMMEDIC;
	gubAnimSurfaceIndex[ STOCKYMALE ][ LOCKPICK_CROUCHED ]					= RGMMEDIC;

	//<SB> crouch throwing
	gubAnimSurfaceIndex[ STOCKYMALE ][ THROW_ITEM_CROUCHED ]										= RGMCRTHROW;
	//</SB>
	//dddd
	gubAnimSurfaceIndex[ STOCKYMALE ][ SHOOT_ROCKET_CROUCHED ]							= RGMCRROCKET;
	gubAnimSurfaceIndex[ STOCKYMALE ][ SWATTING_WK ]							= RGMSWKNIFE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ SWAT_BACKWARDS_WK ]						= RGMSWKNIFE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ SWAT_BACKWARDS_NOTHING ]				= RGMNOTHING_SWAT;
		//Throwing Grenades
	gubAnimSurfaceIndex[ STOCKYMALE ][ THROW_GRENADE_STANCE ]				= RGMSTHRG;
	gubAnimSurfaceIndex[ STOCKYMALE ][ LOB_GRENADE_STANCE ]				= RGMSLOBG;
	//Rolling
	gubAnimSurfaceIndex[ STOCKYMALE ][ ROLL_PRONE_L ]					  	= RGMROLL_PR;
	gubAnimSurfaceIndex[ STOCKYMALE ][ ROLL_PRONE_R ]					  	= RGMROLL_PR;
	
	gubAnimSurfaceIndex[ STOCKYMALE ][ JUMPUPWALL ]						= RGMWALLJUMP;
	gubAnimSurfaceIndex[ STOCKYMALE ][ JUMPDOWNWALL ]					= RGMWALLJUMP;
	
	gubAnimSurfaceIndex[ STOCKYMALE ][ JUMPWINDOWS ]					= RGMJUMPWINDOWS;

	gubAnimSurfaceIndex[ STOCKYMALE ][ SIDE_STEP_WEAPON_RDY ]				= RGMSIDESTEP_R_RDY;
	gubAnimSurfaceIndex[ STOCKYMALE ][ SIDE_STEP_DUAL_RDY ]					= RGMSIDESTEP_D_RDY;
	
	gubAnimSurfaceIndex[ STOCKYMALE ][ WALKING_WEAPON_RDY ]					= RGMWALK_R_RDY;
	gubAnimSurfaceIndex[ STOCKYMALE ][ WALKING_DUAL_RDY ]					= RGMWALK_D_RDY;

	gubAnimSurfaceIndex[ STOCKYMALE ][ START_AID_PRN ]						= RGMMEDICPRN;
	gubAnimSurfaceIndex[ STOCKYMALE ][ GIVING_AID_PRN ]						= RGMMEDICPRN;
	gubAnimSurfaceIndex[ STOCKYMALE ][ END_AID_PRN ]						= RGMMEDICPRN;

	gubAnimSurfaceIndex[ STOCKYMALE ][ ADJACENT_GET_ITEM_CROUCHED ]			= RGMMEDIC;
	gubAnimSurfaceIndex[ STOCKYMALE ][ STEAL_ITEM_CROUCHED ]				= RGMMEDIC;

	gubAnimSurfaceIndex[ STOCKYMALE ][ BURST_DUAL_STAND ]					= RGMSTANDDWALAIM;
	gubAnimSurfaceIndex[ STOCKYMALE ][ BURST_DUAL_CROUCH ]					= RGMCDBLSHOT;
	gubAnimSurfaceIndex[ STOCKYMALE ][ BURST_DUAL_PRONE ]					= RGMDWPRONE;

	gubAnimSurfaceIndex[ STOCKYMALE ][ READY_ALTERNATIVE_STAND ]				= RGM_HIP_AIM;
	gubAnimSurfaceIndex[ STOCKYMALE ][ AIM_ALTERNATIVE_STAND ]				= RGM_HIP_AIM;
	gubAnimSurfaceIndex[ STOCKYMALE ][ SHOOT_ALTERNATIVE_STAND ]				= RGM_HIP_AIM;
	gubAnimSurfaceIndex[ STOCKYMALE ][ BURST_ALTERNATIVE_STAND ]				= RGM_HIP_AIM;
	gubAnimSurfaceIndex[ STOCKYMALE ][ LOW_SHOT_ALTERNATIVE_STAND ]				= RGM_HIP_LOW;
	gubAnimSurfaceIndex[ STOCKYMALE ][ LOW_BURST_ALTERNATIVE_STAND ]			= RGM_HIP_LOW;
	gubAnimSurfaceIndex[ STOCKYMALE ][ UNREADY_ALTERNATIVE_STAND ]			= RGM_HIP_AIM;
	gubAnimSurfaceIndex[ STOCKYMALE ][ UNJAM_ALTERNATIVE_STAND ]				= RGM_HIP_AIM;
	gubAnimSurfaceIndex[ STOCKYMALE ][ LOW_UNJAM_ALTERNATIVE_STAND ]			= RGM_HIP_LOW;
	gubAnimSurfaceIndex[ STOCKYMALE ][ WALKING_ALTERNATIVE_RDY ]			= RGMBASICWALKING;
	gubAnimSurfaceIndex[ STOCKYMALE ][ SIDE_STEP_ALTERNATIVE_RDY ]			= RGMSIDESTEP;
	
	gubAnimSurfaceIndex[ STOCKYMALE ][ START_COWER_CROUCHED ]			= RGMCOWER;
	gubAnimSurfaceIndex[ STOCKYMALE ][ END_COWER_CROUCHED ]			= RGMCOWER;
	gubAnimSurfaceIndex[ STOCKYMALE ][ START_COWER_PRONE ]				= RGM_COWER_PRONE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ COWERING_PRONE ]					= RGM_COWER_PRONE;
	gubAnimSurfaceIndex[ STOCKYMALE ][ END_COWER_PRONE ]				= RGM_COWER_PRONE;

	gubAnimSurfaceIndex[ STOCKYMALE ][ FOCUSED_PUNCH ]					= RGMPUNCH;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FOCUSED_STAB ]					= RGMSTAB;
	gubAnimSurfaceIndex[ STOCKYMALE ][ HTH_KICK ]						= RGMKICKDOOR;
	gubAnimSurfaceIndex[ STOCKYMALE ][ FOCUSED_HTH_KICK ]				= RGMKICKDOOR;
	
	gubAnimSurfaceIndex[ STOCKYMALE ][ LONG_JUMP ]						= RGMJUMPOVER;

	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ STANDING ]						= RGMPISTOLBREATH;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ WALKING ]						= RGMNOTHING_WALK;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ RUNNING]							= RGMNOTHING_RUN;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ SWATTING]						= RGMNOTHING_SWAT;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ START_SWAT ]					= RGMNOTHING_SWAT;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ END_SWAT]						= RGMNOTHING_SWAT;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ KNEEL_DOWN ]					= RGMNOTHING_CROUCH;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ CROUCHING ]					= RGMNOTHING_CROUCH;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ KNEEL_UP ]						= RGMNOTHING_CROUCH;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ READY_RIFLE_STAND ]				= RGMHANDGUN_S_SHOT;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ AIM_RIFLE_STAND ]					= RGMHANDGUN_S_SHOT;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ SHOOT_RIFLE_STAND ]				= RGMHANDGUN_S_SHOT;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ END_RIFLE_STAND ]					= RGMHANDGUN_S_SHOT;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ STANDING_BURST ]						= RGMHANDGUN_S_SHOT;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ FIRE_STAND_BURST_SPREAD ]	= RGMHANDGUN_S_SHOT;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ READY_RIFLE_CROUCH ]				= RGMHANDGUN_C_SHOT;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ AIM_RIFLE_CROUCH ]					= RGMHANDGUN_C_SHOT;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ SHOOT_RIFLE_CROUCH ]				= RGMHANDGUN_C_SHOT;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ END_RIFLE_CROUCH ]					= RGMHANDGUN_C_SHOT;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ PRONE_DOWN ]								= RGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ CRAWLING ]									= RGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ PRONE_UP ]									= RGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ PRONE ]										= RGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ READY_RIFLE_PRONE ]				= RGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ AIM_RIFLE_PRONE ]					= RGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ SHOOT_RIFLE_PRONE ]				= RGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ END_RIFLE_PRONE ]					= RGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ GETUP_FROM_ROLLOVER ]			= RGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ STANDING_SHOOT_UNJAM ]		= RGMHANDGUN_S_SHOT;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ CROUCH_SHOOT_UNJAM ]			= RGMHANDGUN_C_SHOT;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ PRONE_SHOOT_UNJAM ]				= RGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ FIRE_BURST_LOW_STAND ]		= RGMPISTOLSHOOTLOW;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ FIRE_LOW_STAND ]					= RGMPISTOLSHOOTLOW;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ CROUCHED_BURST ]					= RGMHANDGUN_C_SHOT;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ PRONE_BURST ]							= RGMHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ MERC_HURT_IDLE_ANIM ]			= RGMHURTSTANDINGN;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ END_HURT_WALKING ]				= RGMHURTSTANDINGN;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ WALK_BACKWARDS ]					= RGMNOTHING_WALK;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ DRUNK_IDLE ]							= RGMPISTOLDRUNK;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ RUNNING_W_PISTOL ]					= RGMPISTOL_RUN;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ SIDE_STEP_WEAPON_RDY ]				= RGMSIDESTEP_P_RDY;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ WALKING_WEAPON_RDY ]					= RGMWALK_P_RDY;

	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ READY_ALTERNATIVE_STAND ]					= RGM_PFSHOT_AIM;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ AIM_ALTERNATIVE_STAND ]						= RGM_PFSHOT_AIM;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ SHOOT_ALTERNATIVE_STAND ]					= RGM_PFSHOT_AIM;	
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ BURST_ALTERNATIVE_STAND ]					= RGM_PFSHOT_AIM;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ LOW_SHOT_ALTERNATIVE_STAND ]						= RGMPISTOLSHOOTLOW;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ LOW_BURST_ALTERNATIVE_STAND ]				= RGMPISTOLSHOOTLOW;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ UNREADY_ALTERNATIVE_STAND ]					= RGM_PFSHOT_AIM;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ UNJAM_ALTERNATIVE_STAND ]					= RGM_PFSHOT_AIM;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ LOW_UNJAM_ALTERNATIVE_STAND ]				= RGMPISTOLSHOOTLOW;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ WALKING_ALTERNATIVE_RDY ]					= RGMWALK_P_RDY;
	gubAnimSurfaceItemSubIndex[ STOCKYMALE ][ SIDE_STEP_ALTERNATIVE_RDY ]				= RGMSIDESTEP_P_RDY;


	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ STANDING][0]									= RGMWATER_R_STD;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ WALKING ][0]									= RGMWATER_R_WALK;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ RUNNING ][0]									= RGMWATER_R_WALK;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ READY_RIFLE_STAND ][0]				= RGMWATER_R_AIM;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ AIM_RIFLE_STAND ][0]					= RGMWATER_R_AIM;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ SHOOT_RIFLE_STAND ][0]				= RGMWATER_R_AIM;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ END_RIFLE_STAND ][0]					= RGMWATER_R_AIM;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ STANDING_BURST ][0]					= RGMWATER_R_AIM;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ FIRE_STAND_BURST_SPREAD ][0]	= RGMWATER_R_AIM;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ STANDING][1]									= RGMWATER_N_STD;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ WALKING ][1]									= RGMWATER_N_WALK;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ RUNNING ][1]									= RGMWATER_N_WALK;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ READY_RIFLE_STAND ][1]				= RGMWATER_N_AIM;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ AIM_RIFLE_STAND ][1]					= RGMWATER_N_AIM;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ SHOOT_RIFLE_STAND ][1]				= RGMWATER_N_AIM;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ END_RIFLE_STAND ][1]					= RGMWATER_N_AIM;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ STANDING_BURST ][1]					= RGMWATER_N_AIM;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ FIRE_STAND_BURST_SPREAD ][1]	= RGMWATER_N_AIM;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ READY_DUAL_STAND ][1]				= RGMWATER_DBLSHT;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ AIM_DUAL_STAND ][1]					= RGMWATER_DBLSHT;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ SHOOT_DUAL_STAND ][1]				= RGMWATER_DBLSHT;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ END_DUAL_STAND ][1]					= RGMWATER_DBLSHT;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ STANDING_SHOOT_UNJAM ][0]		= RGMWATER_R_AIM;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ STANDING_SHOOT_UNJAM ][1]		= RGMWATER_N_AIM;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ THROW_ITEM ][0]							= RGMWATERTHROW;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ THROW_ITEM ][1]							= RGMWATERTHROW;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ LOB_ITEM ][0]								= RGMWATERTHROW;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ LOB_ITEM ][1]								= RGMWATERTHROW;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ BURST_DUAL_STAND ][1]					= RGMWATER_DBLSHT;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ READY_ALTERNATIVE_STAND ][0]					= RGM_WATER_HIP_AIM;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ AIM_ALTERNATIVE_STAND ][0]						= RGM_WATER_HIP_AIM;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ SHOOT_ALTERNATIVE_STAND ][0]					= RGM_WATER_HIP_AIM;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ BURST_ALTERNATIVE_STAND ][0]					= RGM_WATER_HIP_AIM;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ UNREADY_ALTERNATIVE_STAND ][0]					= RGM_WATER_HIP_AIM;
	gubAnimSurfaceMidWaterSubIndex[ STOCKYMALE ][ UNJAM_ALTERNATIVE_STAND ][0]					= RGM_WATER_HIP_AIM;


	gubAnimSurfaceCorpseID[ STOCKYMALE ][ GENERIC_HIT_DEATH ]						= SMERC_FWD;
	gubAnimSurfaceCorpseID[ STOCKYMALE ][ FALLBACK_HIT_DEATH ]					= SMERC_BCK;
	gubAnimSurfaceCorpseID[ STOCKYMALE ][ PRONE_HIT_DEATH ]							= SMERC_PRN;
	gubAnimSurfaceCorpseID[ STOCKYMALE ][ WATER_DIE ]										= SMERC_WTR;
	gubAnimSurfaceCorpseID[ STOCKYMALE ][ FLYBACK_HIT_DEATH ]						= SMERC_DHD;
	gubAnimSurfaceCorpseID[ STOCKYMALE ][ JFK_HITDEATH ]								= SMERC_JFK;
	gubAnimSurfaceCorpseID[ STOCKYMALE ][ FALLOFF_DEATH ]								= SMERC_FALL;
	gubAnimSurfaceCorpseID[ STOCKYMALE ][ FALLOFF_FORWARD_DEATH ]				= SMERC_FALLF;
	gubAnimSurfaceCorpseID[ STOCKYMALE ][ FLYBACK_HIT ]									= SMERC_DHD;
	gubAnimSurfaceCorpseID[ STOCKYMALE ][ GENERIC_HIT_DEATHTWITCHNB ]		= SMERC_FWD;
	gubAnimSurfaceCorpseID[ STOCKYMALE ][ FALLFORWARD_FROMHIT_STAND ]		= SMERC_FWD;
	gubAnimSurfaceCorpseID[ STOCKYMALE ][ ENDFALLFORWARD_FROMHIT_CROUCH ]= SMERC_FWD;
	gubAnimSurfaceCorpseID[ STOCKYMALE ][ FALLBACK_HIT_STAND ]						= SMERC_BCK;
	gubAnimSurfaceCorpseID[ STOCKYMALE ][ FALLBACK_HIT_DEATHTWITCHNB ]		= SMERC_BCK;
	gubAnimSurfaceCorpseID[ STOCKYMALE ][ PRONE_HIT_DEATHTWITCHNB ]			= SMERC_PRN;
	gubAnimSurfaceCorpseID[ STOCKYMALE ][ PRONE_LAY_FROMHIT ]						= SMERC_PRN;
	gubAnimSurfaceCorpseID[ STOCKYMALE ][ FALLOFF ]											= SMERC_FALLF;
	gubAnimSurfaceCorpseID[ STOCKYMALE ][ FALLFORWARD_ROOF ]						= SMERC_FALL;
	gubAnimSurfaceCorpseID[ STOCKYMALE ][ FLYBACKHIT_STOP ]							= SMERC_DHD;
	gubAnimSurfaceCorpseID[ STOCKYMALE ][ STAND_FALLFORWARD_STOP ]			= SMERC_FWD;
	gubAnimSurfaceCorpseID[ STOCKYMALE ][ FALLBACKHIT_STOP ]						= SMERC_BCK;
	gubAnimSurfaceCorpseID[ STOCKYMALE ][ PRONE_LAYFROMHIT_STOP ]				= SMERC_PRN;
	gubAnimSurfaceCorpseID[ STOCKYMALE ][ CHARIOTS_OF_FIRE ]						= BURNT_DEAD;
	gubAnimSurfaceCorpseID[ STOCKYMALE ][ BODYEXPLODING ]								= EXPLODE_DEAD;


	//Setup some random stuff
	gRandomAnimDefs[ STOCKYMALE ][ 0 ].ubHandRestriction		= RANDOM_ANIM_RIFLEINHAND;
	gRandomAnimDefs[ STOCKYMALE ][ 0 ].sAnimID							= REG_SPIT;
	gRandomAnimDefs[ STOCKYMALE ][ 0 ].ubStartRoll					= 0;
	gRandomAnimDefs[ STOCKYMALE ][ 0 ].ubEndRoll						= 9;
	gRandomAnimDefs[ STOCKYMALE ][ 0 ].ubFlags							= RANDOM_ANIM_CASUAL;
	gRandomAnimDefs[ STOCKYMALE ][ 0 ].ubAnimHeight				= ANIM_STAND;

	gRandomAnimDefs[ STOCKYMALE ][ 1 ].ubHandRestriction		= RANDOM_ANIM_NOTHINGINHAND;
	gRandomAnimDefs[ STOCKYMALE ][ 1 ].sAnimID							= REG_SQUISH;
	gRandomAnimDefs[ STOCKYMALE ][ 1 ].ubStartRoll					= 10;
	gRandomAnimDefs[ STOCKYMALE ][ 1 ].ubEndRoll						= 19;
	gRandomAnimDefs[ STOCKYMALE ][ 1 ].ubFlags							= RANDOM_ANIM_CASUAL;
	gRandomAnimDefs[ STOCKYMALE ][ 1 ].ubAnimHeight				= ANIM_STAND;

	gRandomAnimDefs[ STOCKYMALE ][ 2 ].ubHandRestriction		= RANDOM_ANIM_RIFLEINHAND;
	gRandomAnimDefs[ STOCKYMALE ][ 2 ].sAnimID							= FEM_LOOK;
	gRandomAnimDefs[ STOCKYMALE ][ 2 ].ubStartRoll					= 10;
	gRandomAnimDefs[ STOCKYMALE ][ 2 ].ubEndRoll						= 29;
	gRandomAnimDefs[ STOCKYMALE ][ 2 ].ubFlags							= RANDOM_ANIM_LOOKAROUND;
	gRandomAnimDefs[ STOCKYMALE ][ 2 ].ubAnimHeight				= ANIM_STAND;

	gRandomAnimDefs[ STOCKYMALE ][ 3 ].ubHandRestriction		= RANDOM_ANIM_NOTHINGINHAND;
	gRandomAnimDefs[ STOCKYMALE ][ 3 ].sAnimID							= REG_PULL;
	gRandomAnimDefs[ STOCKYMALE ][ 3 ].ubStartRoll					= 30;
	gRandomAnimDefs[ STOCKYMALE ][ 3 ].ubEndRoll						= 39;
	gRandomAnimDefs[ STOCKYMALE ][ 3 ].ubFlags							= 0;
	gRandomAnimDefs[ STOCKYMALE ][ 3 ].ubAnimHeight				= ANIM_STAND;

	gRandomAnimDefs[ STOCKYMALE ][ 4 ].ubHandRestriction		= RANDOM_ANIM_IRRELEVENTINHAND;
	gRandomAnimDefs[ STOCKYMALE ][ 4 ].sAnimID							= MERC_HURT_IDLE_ANIM;
	gRandomAnimDefs[ STOCKYMALE ][ 4 ].ubStartRoll					= 0;
	gRandomAnimDefs[ STOCKYMALE ][ 4 ].ubEndRoll						= 60;
	gRandomAnimDefs[ STOCKYMALE ][ 4 ].ubFlags							= RANDOM_ANIM_INJURED;
	gRandomAnimDefs[ STOCKYMALE ][ 4 ].ubAnimHeight					= ANIM_STAND;

	gRandomAnimDefs[ STOCKYMALE ][ 5 ].ubHandRestriction		= RANDOM_ANIM_IRRELEVENTINHAND;
	gRandomAnimDefs[ STOCKYMALE ][ 5 ].sAnimID							= DRUNK_IDLE;
	gRandomAnimDefs[ STOCKYMALE ][ 5 ].ubStartRoll					= 61;
	gRandomAnimDefs[ STOCKYMALE ][ 5 ].ubEndRoll						= 100;
	gRandomAnimDefs[ STOCKYMALE ][ 5 ].ubFlags							= RANDOM_ANIM_DRUNK;
	gRandomAnimDefs[ STOCKYMALE ][ 5 ].ubAnimHeight					= ANIM_STAND;


	// REG FEMALE GUY
	gubAnimSurfaceIndex[ REGFEMALE ][ WALKING ]								= RGFWALKING;
	gubAnimSurfaceIndex[ REGFEMALE ][ STANDING ]							= RGFSTANDING;
	gubAnimSurfaceIndex[ REGFEMALE ][ KNEEL_DOWN ]						= RGFCROUCHING;
	gubAnimSurfaceIndex[ REGFEMALE ][ CROUCHING ]							= RGFCROUCHING;
	gubAnimSurfaceIndex[ REGFEMALE ][ KNEEL_UP ]							= RGFCROUCHING;
	gubAnimSurfaceIndex[ REGFEMALE ][ SWATTING ]							= RGFSNEAKING;
	gubAnimSurfaceIndex[ REGFEMALE ][ RUNNING ]								= RGFRUNNING;
	gubAnimSurfaceIndex[ REGFEMALE ][ PRONE_DOWN ]						= RGFPRONE;
	gubAnimSurfaceIndex[ REGFEMALE ][ CRAWLING ]							= RGFPRONE;
	gubAnimSurfaceIndex[ REGFEMALE ][ PRONE_UP ]							= RGFPRONE;
	gubAnimSurfaceIndex[ REGFEMALE ][ PRONE ]									= RGFPRONE;
	gubAnimSurfaceIndex[ REGFEMALE ][ READY_RIFLE_STAND ]			= RGFSTANDAIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ AIM_RIFLE_STAND ]				= RGFSTANDAIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ SHOOT_RIFLE_STAND ]			= RGFSTANDAIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ END_RIFLE_STAND ]				= RGFSTANDAIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ START_SWAT ]						= RGFSNEAKING;
	gubAnimSurfaceIndex[ REGFEMALE ][ END_SWAT ]							= RGFSNEAKING;
	gubAnimSurfaceIndex[ REGFEMALE ][ FLYBACK_HIT ]						= RGFHITHARD;
	gubAnimSurfaceIndex[ REGFEMALE ][ READY_RIFLE_PRONE ]			= RGFPRONE;
	gubAnimSurfaceIndex[ REGFEMALE ][ AIM_RIFLE_PRONE ]				= RGFPRONE;
	gubAnimSurfaceIndex[ REGFEMALE ][ SHOOT_RIFLE_PRONE ]			= RGFPRONE;
	gubAnimSurfaceIndex[ REGFEMALE ][ END_RIFLE_PRONE ]				= RGFPRONE;
	gubAnimSurfaceIndex[ REGFEMALE ][ FALLBACK_DEATHTWICH ]		= RGFHITHARD;
	gubAnimSurfaceIndex[ REGFEMALE ][ GENERIC_HIT_STAND ]			= RGFHITSTAND;
	gubAnimSurfaceIndex[ REGFEMALE ][ FLYBACK_HIT_BLOOD_STAND ]		= RGFHITHARDBLOOD;
	gubAnimSurfaceIndex[ REGFEMALE ][ FLYBACK_HIT_DEATH ]			= RGFHITHARD;
	gubAnimSurfaceIndex[ REGFEMALE ][ READY_RIFLE_CROUCH ]		= RGFCROUCHAIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ AIM_RIFLE_CROUCH ]			= RGFCROUCHAIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ SHOOT_RIFLE_CROUCH ]		= RGFCROUCHAIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ END_RIFLE_CROUCH ]			= RGFCROUCHAIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ FALLBACK_HIT_STAND ]		= RGFHITFALLBACK;
	gubAnimSurfaceIndex[ REGFEMALE ][ ROLLOVER ]							= RGFROLLOVER;
	gubAnimSurfaceIndex[ REGFEMALE ][ CLIMBUPROOF ]						= RGFCLIMBROOF;
	gubAnimSurfaceIndex[ REGFEMALE ][ FALLOFF ]								= RGFFALL;
	gubAnimSurfaceIndex[ REGFEMALE ][ GETUP_FROM_ROLLOVER ]		= RGFPRONE;
	gubAnimSurfaceIndex[ REGFEMALE ][ CLIMBDOWNROOF ]					= RGFCLIMBROOF;
	gubAnimSurfaceIndex[ REGFEMALE ][ FALLFORWARD_ROOF ]						= RGFFALLF;
	gubAnimSurfaceIndex[ REGFEMALE ][ GENERIC_HIT_DEATHTWITCHNB ]		= RGFHITSTAND;
	gubAnimSurfaceIndex[ REGFEMALE ][ GENERIC_HIT_DEATHTWITCHB ]		= RGFHITSTAND;
	gubAnimSurfaceIndex[ REGFEMALE ][ FALLBACK_HIT_DEATHTWITCHNB ]	= RGFHITFALLBACK;
	gubAnimSurfaceIndex[ REGFEMALE ][ FALLBACK_HIT_DEATHTWITCHB ]		= RGFHITFALLBACK;
	gubAnimSurfaceIndex[ REGFEMALE ][ GENERIC_HIT_DEATH ]			= RGFHITSTAND;
	gubAnimSurfaceIndex[ REGFEMALE ][ FALLBACK_HIT_DEATH ]		= RGFHITFALLBACK;
	gubAnimSurfaceIndex[ REGFEMALE ][ GENERIC_HIT_CROUCH ]		= RGFHITCROUCH;
	gubAnimSurfaceIndex[ REGFEMALE ][ STANDING_BURST ]				= RGFSTANDAIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ STANDING_BURST_HIT ]		= RGFHITHARD;
	gubAnimSurfaceIndex[ REGFEMALE ][ GENERIC_HIT_DEATH ]			= RGFHITSTAND;
	gubAnimSurfaceIndex[ REGFEMALE ][ FALLFORWARD_FROMHIT_STAND ]		= RGFHITSTAND;
	gubAnimSurfaceIndex[ REGFEMALE ][ FALLFORWARD_FROMHIT_STAND ]				= RGFHITSTAND;
	gubAnimSurfaceIndex[ REGFEMALE ][ FALLFORWARD_FROMHIT_CROUCH ]			= RGFHITCROUCH;
	gubAnimSurfaceIndex[ REGFEMALE ][ ENDFALLFORWARD_FROMHIT_CROUCH ]		= RGFHITSTAND;
	gubAnimSurfaceIndex[ REGFEMALE ][ GENERIC_HIT_PRONE ]			= RGFHITPRONE;
	gubAnimSurfaceIndex[ REGFEMALE ][ PRONE_HIT_DEATH ]				= RGFHITPRONE;
	gubAnimSurfaceIndex[ REGFEMALE ][ PRONE_LAY_FROMHIT ]			= RGFHITPRONE;
	gubAnimSurfaceIndex[ REGFEMALE ][ PRONE_HIT_DEATHTWITCHNB ]					= RGFHITPRONE;
	gubAnimSurfaceIndex[ REGFEMALE ][ PRONE_HIT_DEATHTWITCHB ]					= RGFHITPRONE;
	gubAnimSurfaceIndex[ REGFEMALE ][ FLYBACK_HITDEATH_STOP ]					= RGFHITHARD;
	gubAnimSurfaceIndex[ REGFEMALE ][ FALLFORWARD_HITDEATH_STOP ]			= RGFHITSTAND;
	gubAnimSurfaceIndex[ REGFEMALE ][ FALLBACK_HITDEATH_STOP ]				= RGFHITFALLBACK;
	gubAnimSurfaceIndex[ REGFEMALE ][ PRONE_HITDEATH_STOP ]						= RGFHITPRONE;
	gubAnimSurfaceIndex[ REGFEMALE ][ FLYBACKHIT_STOP ]								= RGFHITHARD;
	gubAnimSurfaceIndex[ REGFEMALE ][ FALLBACKHIT_STOP ]							= RGFHITFALLBACK;
	gubAnimSurfaceIndex[ REGFEMALE ][ FALLOFF_STOP ]									= RGFFALL;
	gubAnimSurfaceIndex[ REGFEMALE ][ FALLOFF_FORWARD_STOP ]					= RGFFALLF;
	gubAnimSurfaceIndex[ REGFEMALE ][ STAND_FALLFORWARD_STOP ]				= RGFHITSTAND;
	gubAnimSurfaceIndex[ REGFEMALE ][ PRONE_LAYFROMHIT_STOP ]					= RGFHITPRONE;
	gubAnimSurfaceIndex[ REGFEMALE ][ HOPFENCE ]											= RGFHOPFENCE;
	gubAnimSurfaceIndex[ REGFEMALE ][ PUNCH_BREATH ]									= RGFPUNCH;
	gubAnimSurfaceIndex[ REGFEMALE ][ PUNCH ]													= RGFPUNCH;
	gubAnimSurfaceIndex[ REGFEMALE ][ NOTHING_STAND ]									= RGFNOTHING_STD;
	gubAnimSurfaceIndex[ REGFEMALE ][ JFK_HITDEATH ]									= RGFDIE_JFK;
	gubAnimSurfaceIndex[ REGFEMALE ][ JFK_HITDEATH_STOP ]							= RGFDIE_JFK;
	gubAnimSurfaceIndex[ REGFEMALE ][ JFK_HITDEATH_TWITCHB ]					= RGFDIE_JFK;
	gubAnimSurfaceIndex[ REGFEMALE ][ FIRE_STAND_BURST_SPREAD ]				= RGFSTANDAIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ FALLOFF_DEATH ]									= RGFFALL;
	gubAnimSurfaceIndex[ REGFEMALE ][ FALLOFF_FORWARD_DEATH ]					= RGMFALLF;
	gubAnimSurfaceIndex[ REGFEMALE ][ FALLOFF_FORWARD_DEATH_STOP ]		= RGMFALLF;
	gubAnimSurfaceIndex[ REGFEMALE ][ FALLOFF_FORWARD_TWITCHB ]				= RGMFALLF;
	gubAnimSurfaceIndex[ REGFEMALE ][ FALLOFF_FORWARD_TWITCHNB ]			= RGMFALLF;
	gubAnimSurfaceIndex[ REGFEMALE ][ OPEN_DOOR ]											= RGFOPEN;
	gubAnimSurfaceIndex[ REGFEMALE ][ OPEN_STRUCT ]										= RGFOPEN;
	gubAnimSurfaceIndex[ REGFEMALE ][ PICKUP_ITEM ]										= RGFPICKUP;
	gubAnimSurfaceIndex[ REGFEMALE ][ DROP_ITEM ]											= RGFPICKUP;
	gubAnimSurfaceIndex[ REGFEMALE ][ SLICE ]													= RGFSLICE;
	gubAnimSurfaceIndex[ REGFEMALE ][ STAB ]													= RGFSTAB;
	gubAnimSurfaceIndex[ REGFEMALE ][ CROUCH_STAB ]										= RGFCSTAB;
	gubAnimSurfaceIndex[ REGFEMALE ][ START_AID ]											= RGFMEDIC;
	gubAnimSurfaceIndex[ REGFEMALE ][ GIVING_AID ]										= RGFMEDIC;
	gubAnimSurfaceIndex[ REGFEMALE ][ END_AID ]												= RGFMEDIC;
	gubAnimSurfaceIndex[ REGFEMALE ][ DODGE_ONE ]											= RGFDODGE;
	gubAnimSurfaceIndex[ REGFEMALE ][ READY_DUAL_STAND ]							= RGFSTANDDWALAIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ AIM_DUAL_STAND ]								= RGFSTANDDWALAIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ SHOOT_DUAL_STAND ]							= RGFSTANDDWALAIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ END_DUAL_STAND ]								= RGFSTANDDWALAIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ RAISE_RIFLE ]										= RGFRAISE;
	gubAnimSurfaceIndex[ REGFEMALE ][ LOWER_RIFLE ]										= RGFRAISE;
	gubAnimSurfaceIndex[ REGFEMALE ][ BODYEXPLODING ]									= BODYEXPLODE;
	gubAnimSurfaceIndex[ REGFEMALE ][ THROW_ITEM ]										= RGFTHROW;
	gubAnimSurfaceIndex[ REGFEMALE ][ LOB_ITEM ]											= RGFLOB;
	gubAnimSurfaceIndex[ REGFEMALE ][ CROUCHED_BURST ]								= RGFCROUCHAIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ PRONE_BURST ]										= RGFPRONE;
	gubAnimSurfaceIndex[ REGFEMALE ][ GIVE_ITEM ]											= RGFOPEN;
	gubAnimSurfaceIndex[ REGFEMALE ][ WATER_HIT ]											= RGFWATER_DIE;
	gubAnimSurfaceIndex[ REGFEMALE ][ WATER_DIE]											= RGFWATER_DIE;
	gubAnimSurfaceIndex[ REGFEMALE ][ WATER_DIE_STOP ]								= RGFWATER_DIE;
	gubAnimSurfaceIndex[ REGFEMALE ][ HELIDROP ]											= RGFHELIDROP;
	gubAnimSurfaceIndex[ REGFEMALE ][ FEM_CLEAN ]											= RGFCLEAN;
	gubAnimSurfaceIndex[ REGFEMALE ][ FEM_KICKSN ]										= RGFKICKSN;
	gubAnimSurfaceIndex[ REGFEMALE ][ FEM_LOOK ]											= RGFALOOK;
	gubAnimSurfaceIndex[ REGFEMALE ][ FEM_WIPE ]											= RGFWIPE;
	gubAnimSurfaceIndex[ REGFEMALE ][ END_OPEN_DOOR ]									= RGFOPEN;
	gubAnimSurfaceIndex[ REGFEMALE ][ END_OPEN_LOCKED_DOOR ]					= RGFOPEN;
	gubAnimSurfaceIndex[ REGFEMALE ][ KICK_DOOR ]											= RGFKICKDOOR;
	gubAnimSurfaceIndex[ REGFEMALE ][ CLOSE_DOOR ]										= RGFOPEN;
	gubAnimSurfaceIndex[ REGFEMALE ][ RIFLE_STAND_HIT ]								= RGFRHIT;
	gubAnimSurfaceIndex[ REGFEMALE ][ DEEP_WATER_TRED ]								= RGFDEEPWATER_TRED;
	gubAnimSurfaceIndex[ REGFEMALE ][ DEEP_WATER_SWIM ]								= RGFDEEPWATER_SWIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ DEEP_WATER_HIT ]								= RGFDEEPWATER_DIE;
	gubAnimSurfaceIndex[ REGFEMALE ][ DEEP_WATER_DIE]									= RGFDEEPWATER_DIE;
	gubAnimSurfaceIndex[ REGFEMALE ][ DEEP_WATER_DIE_STOPPING ]				= RGFWATER_DIE;
	gubAnimSurfaceIndex[ REGFEMALE ][ DEEP_WATER_DIE_STOP ]						= RGFWATER_DIE;
	gubAnimSurfaceIndex[ REGFEMALE ][ LOW_TO_DEEP_WATER ]							= RGFWATER_TRANS;
	gubAnimSurfaceIndex[ REGFEMALE ][ DEEP_TO_LOW_WATER ]							= RGFWATER_TRANS;
	gubAnimSurfaceIndex[ REGFEMALE ][ GOTO_SLEEP ]										= RGFSLEEP;
	gubAnimSurfaceIndex[ REGFEMALE ][ SLEEPING ]											= RGFSLEEP;
	gubAnimSurfaceIndex[ REGFEMALE ][ WKAEUP_FROM_SLEEP ]							= RGFSLEEP;
	gubAnimSurfaceIndex[ REGFEMALE ][ FIRE_LOW_STAND ]								= RGFSHOOT_LOW;
	gubAnimSurfaceIndex[ REGFEMALE ][ FIRE_BURST_LOW_STAND ]					= RGFSHOOT_LOW;
	gubAnimSurfaceIndex[ REGFEMALE ][ STANDING_SHOOT_UNJAM ]				= RGFSTANDAIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ CROUCH_SHOOT_UNJAM ]						= RGFCROUCHAIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ PRONE_SHOOT_UNJAM ]							= RGFPRONE;
	gubAnimSurfaceIndex[ REGFEMALE ][ STANDING_SHOOT_DWEL_UNJAM ]		= RGFSTANDDWALAIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ STANDING_SHOOT_LOW_UNJAM ]			= RGFSHOOT_LOW;
	gubAnimSurfaceIndex[ REGFEMALE ][ READY_DUAL_CROUCH ]							= RGFCDBLSHOT;
	gubAnimSurfaceIndex[ REGFEMALE ][ AIM_DUAL_CROUCH ]								= RGFCDBLSHOT;
	gubAnimSurfaceIndex[ REGFEMALE ][ SHOOT_DUAL_CROUCH ]							= RGFCDBLSHOT;
	gubAnimSurfaceIndex[ REGFEMALE ][ END_DUAL_CROUCH ]								= RGFCDBLSHOT;
	gubAnimSurfaceIndex[ REGFEMALE ][ CROUCH_SHOOT_DWEL_UNJAM ]				= RGFCDBLSHOT;
	gubAnimSurfaceIndex[ REGFEMALE ][ ADJACENT_GET_ITEM ]							= RGFOPEN;
	gubAnimSurfaceIndex[ REGFEMALE ][ CUTTING_FENCE ]									= RGFMEDIC;
	gubAnimSurfaceIndex[ REGFEMALE ][ FROM_INJURED_TRANSITION ]				= RGFHURTTRANS;
	gubAnimSurfaceIndex[ REGFEMALE ][ THROW_KNIFE ]										= RGFTHROWKNIFE;
	gubAnimSurfaceIndex[ REGFEMALE ][ KNIFE_BREATH ]									= RGFBREATHKNIFE;
	gubAnimSurfaceIndex[ REGFEMALE ][ KNIFE_GOTOBREATH ]							= RGFBREATHKNIFE;
	gubAnimSurfaceIndex[ REGFEMALE ][ KNIFE_ENDBREATH ]								= RGFBREATHKNIFE;
	gubAnimSurfaceIndex[ REGFEMALE ][ CATCH_STANDING ]								= RGFOPEN;
	gubAnimSurfaceIndex[ REGFEMALE ][ CATCH_CROUCHED ]								= RGFMEDIC;
	gubAnimSurfaceIndex[ REGFEMALE ][ PLANT_BOMB ]										= RGFPICKUP;
	gubAnimSurfaceIndex[ REGFEMALE ][ USE_REMOTE ]										= RGFUSEREMOTE;
	gubAnimSurfaceIndex[ REGFEMALE ][ START_COWER ]										= RGFCOWER;
	gubAnimSurfaceIndex[ REGFEMALE ][ COWERING ]											= RGFCOWER;
	gubAnimSurfaceIndex[ REGFEMALE ][ END_COWER ]											= RGFCOWER;
	gubAnimSurfaceIndex[ REGFEMALE ][ STEAL_ITEM ]										= RGFOPEN;
	gubAnimSurfaceIndex[ REGFEMALE ][ SHOOT_ROCKET ]									= RGFROCKET;
	gubAnimSurfaceIndex[ REGFEMALE ][ SHOOT_MORTAR ]									= RGFMORTAR;
	gubAnimSurfaceIndex[ REGFEMALE ][ SIDE_STEP ]											= RGFSIDESTEP;
	gubAnimSurfaceIndex[ REGFEMALE ][ WALK_BACKWARDS ]								= RGFWALKING;
	gubAnimSurfaceIndex[ REGFEMALE ][ BEGIN_OPENSTRUCT ]							= RGFOPEN;
	gubAnimSurfaceIndex[ REGFEMALE ][ END_OPENSTRUCT ]								= RGFOPEN;
	gubAnimSurfaceIndex[ REGFEMALE ][ END_OPENSTRUCT_LOCKED ]					= RGFOPEN;
	gubAnimSurfaceIndex[ REGFEMALE ][ PUNCH_LOW ]											= RGFPUNCHLOW;
	gubAnimSurfaceIndex[ REGFEMALE ][ PISTOL_SHOOT_LOW ]							= RGFPISTOLSHOOTLOW;
	gubAnimSurfaceIndex[ REGFEMALE ][ DECAPITATE ]										= RGFCSTAB;
	gubAnimSurfaceIndex[ REGFEMALE ][ GOTO_PATIENT ]									= RGFHITPRONE;
	gubAnimSurfaceIndex[ REGFEMALE ][ BEING_PATIENT ]									= RGFHITPRONE;
	gubAnimSurfaceIndex[ REGFEMALE ][ GOTO_DOCTOR ]										= RGFMEDIC;
	gubAnimSurfaceIndex[ REGFEMALE ][ BEING_DOCTOR ]									= RGFMEDIC;
	gubAnimSurfaceIndex[ REGFEMALE ][ END_DOCTOR ]										= RGFMEDIC;
	gubAnimSurfaceIndex[ REGFEMALE ][ GOTO_REPAIRMAN ]								= RGFMEDIC;
	gubAnimSurfaceIndex[ REGFEMALE ][ BEING_REPAIRMAN ]								= RGFMEDIC;
	gubAnimSurfaceIndex[ REGFEMALE ][ END_REPAIRMAN ]									= RGFMEDIC;
	gubAnimSurfaceIndex[ REGFEMALE ][ FALL_INTO_PIT ]									= RGFFALL;
	gubAnimSurfaceIndex[ REGFEMALE ][ RELOAD_ROBOT ]									= RGFMEDIC;
	gubAnimSurfaceIndex[ REGFEMALE ][ END_CATCH ]											= RGFOPEN;
	gubAnimSurfaceIndex[ REGFEMALE ][ END_CROUCH_CATCH ]							= RGFMEDIC;
	gubAnimSurfaceIndex[ REGFEMALE ][ AI_RADIO ]											= RGFRADIO;
	gubAnimSurfaceIndex[ REGFEMALE ][ AI_CR_RADIO ]										= RGFCRRADIO;
	gubAnimSurfaceIndex[ REGFEMALE ][ QUEEN_SLAP ]										= RGFSLAP;
	gubAnimSurfaceIndex[ REGFEMALE ][ TAKE_BLOOD_FROM_CORPSE ]				= RGFMEDIC;
	gubAnimSurfaceIndex[ REGFEMALE ][ QUEEN_FRUSTRATED_SLAP ]					= RGFSLAP;
	gubAnimSurfaceIndex[ REGFEMALE ][ CHARIOTS_OF_FIRE ]							= RGMBURN;
	gubAnimSurfaceIndex[ REGFEMALE ][ AI_PULL_SWITCH ]								= RGFOPEN;
	gubAnimSurfaceIndex[ REGFEMALE ][ MERC_HURT_IDLE_ANIM ]						= RGFHURTSTANDINGR;
	gubAnimSurfaceIndex[ REGFEMALE ][ END_HURT_WALKING ]							= RGFHURTSTANDINGR;
	gubAnimSurfaceIndex[ REGFEMALE ][ PASS_OBJECT ]										= RGFOPEN;
	gubAnimSurfaceIndex[ REGFEMALE ][ DROP_ADJACENT_OBJECT ]					= RGFOPEN;
	gubAnimSurfaceIndex[ REGFEMALE ][ READY_DUAL_PRONE ]							= RGFDWPRONE;
	gubAnimSurfaceIndex[ REGFEMALE ][ AIM_DUAL_PRONE ]								= RGFDWPRONE;
	gubAnimSurfaceIndex[ REGFEMALE ][ SHOOT_DUAL_PRONE ]							= RGFDWPRONE;
	gubAnimSurfaceIndex[ REGFEMALE ][ END_DUAL_PRONE ]								= RGFDWPRONE;
	gubAnimSurfaceIndex[ REGFEMALE ][ PRONE_SHOOT_DWEL_UNJAM ]				= RGFDWPRONE;
	gubAnimSurfaceIndex[ REGFEMALE ][ PICK_LOCK ]										= RGFOPEN;
	gubAnimSurfaceIndex[ REGFEMALE ][ OPEN_DOOR_CROUCHED ]						= RGFMEDIC;
	gubAnimSurfaceIndex[ REGFEMALE ][ BEGIN_OPENSTRUCT_CROUCHED ]			= RGFMEDIC;
	gubAnimSurfaceIndex[ REGFEMALE ][ CLOSE_DOOR_CROUCHED ]						= RGFMEDIC;
	gubAnimSurfaceIndex[ REGFEMALE ][ OPEN_STRUCT_CROUCHED ]					= RGFMEDIC;
	gubAnimSurfaceIndex[ REGFEMALE ][ END_OPEN_DOOR_CROUCHED ]				= RGFMEDIC;
	gubAnimSurfaceIndex[ REGFEMALE ][ END_OPENSTRUCT_CROUCHED ]				= RGFMEDIC;
	gubAnimSurfaceIndex[ REGFEMALE ][ END_OPEN_LOCKED_DOOR_CROUCHED ]	= RGFMEDIC;
	gubAnimSurfaceIndex[ REGFEMALE ][ END_OPENSTRUCT_LOCKED_CROUCHED ]= RGFMEDIC;
	gubAnimSurfaceIndex[ REGFEMALE ][ DRUNK_IDLE ]										= RGFDRUNK;
	gubAnimSurfaceIndex[ REGFEMALE ][ CROWBAR_ATTACK ]								= RGFCROWBAR;
	gubAnimSurfaceIndex[ REGFEMALE ][ ATTACH_CAN_TO_STRING ]					= RGFMEDIC;
	gubAnimSurfaceIndex[ REGFEMALE ][ SWAT_BACKWARDS ]								= RGFSNEAKING;
	gubAnimSurfaceIndex[ REGFEMALE ][ JUMP_OVER_BLOCKING_PERSON ]			= RGFJUMPOVER;
	gubAnimSurfaceIndex[ REGFEMALE ][ REFUEL_VEHICLE ]								= RGFMEDIC;
	gubAnimSurfaceIndex[ REGFEMALE ][ LOCKPICK_CROUCHED ]					 = RGFMEDIC;

	//<SB> crouch throwing
	gubAnimSurfaceIndex[ REGFEMALE ][ THROW_ITEM_CROUCHED ]										= RGFCRTHROW;
	//</SB>
	//ddd
	gubAnimSurfaceIndex[ REGFEMALE ][ SHOOT_ROCKET_CROUCHED ]							= RGFCRROCKET;
	gubAnimSurfaceIndex[ REGFEMALE ][ SWAT_BACKWARDS_NOTHING ]				= RGFNOTHING_SWAT;
	gubAnimSurfaceIndex[ REGFEMALE ][ SWATTING_WK ]							= RGFSWKNIFE;
	gubAnimSurfaceIndex[ REGFEMALE ][ SWAT_BACKWARDS_WK ]					= RGFSWKNIFE;
		//Throwing Grenades
	gubAnimSurfaceIndex[ REGFEMALE ][ THROW_GRENADE_STANCE ]				= RGFSTHRG;
	gubAnimSurfaceIndex[ REGFEMALE ][ LOB_GRENADE_STANCE ]				= RGFSLOBG;
	//Rolling
	gubAnimSurfaceIndex[ REGFEMALE ][ ROLL_PRONE_L ]					= RGFROLL_PR;
	gubAnimSurfaceIndex[ REGFEMALE ][ ROLL_PRONE_R ]					= RGFROLL_PR;

	gubAnimSurfaceIndex[ REGFEMALE ][ JUMPUPWALL ]						= RGFWALLJUMP;
	gubAnimSurfaceIndex[ REGFEMALE ][ JUMPDOWNWALL ]					= RGFWALLJUMP;
	
	gubAnimSurfaceIndex[ REGFEMALE ][ JUMPWINDOWS ]					= RGFJUMPWINDOWS;

	gubAnimSurfaceIndex[ REGFEMALE ][ SIDE_STEP_WEAPON_RDY ]					= RGFSIDESTEP_R_RDY;
	gubAnimSurfaceIndex[ REGFEMALE ][ SIDE_STEP_DUAL_RDY ]					= RGFSIDESTEP_D_RDY;
	
	gubAnimSurfaceIndex[ REGFEMALE ][ WALKING_WEAPON_RDY ]					= RGFWALK_R_RDY;
	gubAnimSurfaceIndex[ REGFEMALE ][ WALKING_DUAL_RDY ]					= RGFWALK_D_RDY;

	gubAnimSurfaceIndex[ REGFEMALE ][ START_AID_PRN ]							= RGFMEDICPRN;
	gubAnimSurfaceIndex[ REGFEMALE ][ GIVING_AID_PRN ]							= RGFMEDICPRN;
	gubAnimSurfaceIndex[ REGFEMALE ][ END_AID_PRN ]								= RGFMEDICPRN;

	gubAnimSurfaceIndex[ REGFEMALE ][ ADJACENT_GET_ITEM_CROUCHED ]			= RGFMEDIC;
	gubAnimSurfaceIndex[ REGFEMALE ][ STEAL_ITEM_CROUCHED ]					= RGFMEDIC;

	gubAnimSurfaceIndex[ REGFEMALE ][ BURST_DUAL_STAND ]					= RGFSTANDDWALAIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ BURST_DUAL_CROUCH ]					= RGFCDBLSHOT;
	gubAnimSurfaceIndex[ REGFEMALE ][ BURST_DUAL_PRONE ]					= RGFDWPRONE;

	gubAnimSurfaceIndex[ REGFEMALE ][ READY_ALTERNATIVE_STAND ]				= RGF_HIP_AIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ AIM_ALTERNATIVE_STAND ]					= RGF_HIP_AIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ SHOOT_ALTERNATIVE_STAND ]				= RGF_HIP_AIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ BURST_ALTERNATIVE_STAND ]				= RGF_HIP_AIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ LOW_SHOT_ALTERNATIVE_STAND ]					= RGF_HIP_AIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ LOW_BURST_ALTERNATIVE_STAND ]			= RGF_HIP_AIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ UNREADY_ALTERNATIVE_STAND ]				= RGF_HIP_AIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ UNJAM_ALTERNATIVE_STAND ]				= RGF_HIP_AIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ LOW_UNJAM_ALTERNATIVE_STAND ]			= RGF_HIP_AIM;
	gubAnimSurfaceIndex[ REGFEMALE ][ WALKING_ALTERNATIVE_RDY ]				= RGFWALKING;
	gubAnimSurfaceIndex[ REGFEMALE ][ SIDE_STEP_ALTERNATIVE_RDY ]			= RGFSIDESTEP;
	
	gubAnimSurfaceIndex[ REGFEMALE ][ START_COWER_CROUCHED ]		= RGFCOWER;
	gubAnimSurfaceIndex[ REGFEMALE ][ END_COWER_CROUCHED ]			= RGFCOWER;
	gubAnimSurfaceIndex[ REGFEMALE ][ START_COWER_PRONE ]			= RGF_COWER_PRONE;
	gubAnimSurfaceIndex[ REGFEMALE ][ COWERING_PRONE ]					= RGF_COWER_PRONE;
	gubAnimSurfaceIndex[ REGFEMALE ][ END_COWER_PRONE ]				= RGF_COWER_PRONE;
	
	gubAnimSurfaceIndex[ REGFEMALE ][ FOCUSED_PUNCH ]					= RGFPUNCH;
	gubAnimSurfaceIndex[ REGFEMALE ][ FOCUSED_STAB ]					= RGFSTAB;
	gubAnimSurfaceIndex[ REGFEMALE ][ HTH_KICK ]						= RGFKICKDOOR;
	gubAnimSurfaceIndex[ REGFEMALE ][ FOCUSED_HTH_KICK ]				= RGFKICKDOOR;
	
	gubAnimSurfaceIndex[ REGFEMALE ][ LONG_JUMP ]					= RGFJUMPOVER;

	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ STANDING ]						= RGFPISTOLBREATH;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ WALKING ]							= RGFNOTHING_WALK;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ RUNNING ]							= RGFNOTHING_RUN;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ SWATTING ]						= RGFNOTHING_SWAT;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ START_SWAT ]					= RGFNOTHING_SWAT;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ END_SWAT ]						= RGFNOTHING_SWAT;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ KNEEL_DOWN ]					= RGFNOTHING_CROUCH;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ CROUCHING ]						= RGFNOTHING_CROUCH;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ KNEEL_UP ]						= RGFNOTHING_CROUCH;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ READY_RIFLE_STAND ]				= RGFHANDGUN_S_SHOT;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ AIM_RIFLE_STAND ]					= RGFHANDGUN_S_SHOT;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ SHOOT_RIFLE_STAND ]				= RGFHANDGUN_S_SHOT;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ END_RIFLE_STAND ]					= RGFHANDGUN_S_SHOT;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ STANDING_BURST ]						= RGFHANDGUN_S_SHOT;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ FIRE_STAND_BURST_SPREAD ]	= RGFHANDGUN_S_SHOT;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ READY_RIFLE_CROUCH ]				= RGFHANDGUN_C_SHOT;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ AIM_RIFLE_CROUCH ]					= RGFHANDGUN_C_SHOT;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ SHOOT_RIFLE_CROUCH ]				= RGFHANDGUN_C_SHOT;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ END_RIFLE_CROUCH ]					= RGFHANDGUN_C_SHOT;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ PRONE_DOWN ]								= RGFHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ CRAWLING ]									= RGFHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ PRONE_UP ]									= RGFHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ PRONE ]										= RGFHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ READY_RIFLE_PRONE ]				= RGFHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ AIM_RIFLE_PRONE ]					= RGFHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ SHOOT_RIFLE_PRONE ]				= RGFHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ END_RIFLE_PRONE ]					= RGFHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ GETUP_FROM_ROLLOVER ]			= RGFHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ STANDING_SHOOT_UNJAM ]			= RGFHANDGUN_S_SHOT;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ CROUCH_SHOOT_UNJAM ]				= RGFHANDGUN_C_SHOT;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ PRONE_SHOOT_UNJAM ]				= RGFHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ FIRE_BURST_LOW_STAND ]			= RGFPISTOLSHOOTLOW;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ FIRE_LOW_STAND ]						= RGFPISTOLSHOOTLOW;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ CROUCHED_BURST ]						= RGFHANDGUN_C_SHOT;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ PRONE_BURST ]							= RGFHANDGUN_PRONE;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ MERC_HURT_IDLE_ANIM ]			= RGFHURTSTANDINGN;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ END_HURT_WALKING ]					= RGFHURTSTANDINGN;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ WALK_BACKWARDS ]						= RGFNOTHING_WALK;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ DRUNK_IDLE ]								= RGMPISTOLDRUNK;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ RUNNING_W_PISTOL ]							= RGFPISTOL_RUN;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ SIDE_STEP_WEAPON_RDY ]				= RGFSIDESTEP_P_RDY;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ WALKING_WEAPON_RDY ]					= RGFWALK_P_RDY;

	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ READY_ALTERNATIVE_STAND ]			= RGF_PFSHOT_AIM;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ AIM_ALTERNATIVE_STAND ]				= RGF_PFSHOT_AIM;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ SHOOT_ALTERNATIVE_STAND ]			= RGF_PFSHOT_AIM;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ BURST_ALTERNATIVE_STAND ]			= RGF_PFSHOT_AIM;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ LOW_SHOT_ALTERNATIVE_STAND ]				= RGFPISTOLSHOOTLOW;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ LOW_BURST_ALTERNATIVE_STAND ]		= RGFPISTOLSHOOTLOW;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ UNREADY_ALTERNATIVE_STAND ]			= RGF_PFSHOT_AIM;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ UNJAM_ALTERNATIVE_STAND ]			= RGF_PFSHOT_AIM;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ LOW_UNJAM_ALTERNATIVE_STAND ]		= RGFPISTOLSHOOTLOW;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ WALKING_ALTERNATIVE_RDY ]			= RGFWALK_P_RDY;
	gubAnimSurfaceItemSubIndex[ REGFEMALE ][ SIDE_STEP_ALTERNATIVE_RDY ]		= RGFSIDESTEP_P_RDY;

	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ STANDING][0]									= RGFWATER_R_STD;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ WALKING ][0]									= RGFWATER_R_WALK;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ RUNNING ][0]									= RGFWATER_R_WALK;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ READY_RIFLE_STAND ][0]				= RGFWATER_R_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ AIM_RIFLE_STAND ][0]					= RGFWATER_R_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ SHOOT_RIFLE_STAND ][0]				= RGFWATER_R_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ END_RIFLE_STAND ][0]					= RGFWATER_R_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ STANDING_BURST ][0]					= RGFWATER_R_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ FIRE_STAND_BURST_SPREAD ][0]	= RGFWATER_R_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ STANDING][1]									= RGFWATER_N_STD;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ WALKING ][1]									= RGFWATER_N_WALK;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ RUNNING ][1]									= RGFWATER_N_WALK;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ READY_RIFLE_STAND ][1]				= RGFWATER_N_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ AIM_RIFLE_STAND ][1]					= RGFWATER_N_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ SHOOT_RIFLE_STAND ][1]				= RGFWATER_N_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ END_RIFLE_STAND ][1]					= RGFWATER_N_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ STANDING_BURST ][1]					= RGFWATER_N_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ FIRE_STAND_BURST_SPREAD ][1]	= RGFWATER_N_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ READY_DUAL_STAND ][1]				= RGFWATER_DBLSHT;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ AIM_DUAL_STAND ][1]					= RGFWATER_DBLSHT;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ SHOOT_DUAL_STAND ][1]				= RGFWATER_DBLSHT;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ END_DUAL_STAND ][1]					= RGFWATER_DBLSHT;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ STANDING_SHOOT_UNJAM ][0]		= RGFWATER_R_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ STANDING_SHOOT_UNJAM ][1]		= RGFWATER_N_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ THROW_ITEM ][0]							= RGFWATERTHROW;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ THROW_ITEM ][1]							= RGFWATERTHROW;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ LOB_ITEM ][0]								= RGFWATERTHROW;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ LOB_ITEM ][1]								= RGFWATERTHROW;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ BURST_DUAL_STAND ][1]				= RGFWATER_DBLSHT;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ READY_ALTERNATIVE_STAND ][0]					= RGF_WATER_HIP_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ AIM_ALTERNATIVE_STAND ][0]					= RGF_WATER_HIP_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ SHOOT_ALTERNATIVE_STAND ][0]					= RGF_WATER_HIP_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ BURST_ALTERNATIVE_STAND ][0]					= RGF_WATER_HIP_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ UNREADY_ALTERNATIVE_STAND ][0]				= RGF_WATER_HIP_AIM;
	gubAnimSurfaceMidWaterSubIndex[ REGFEMALE ][ UNJAM_ALTERNATIVE_STAND ][0]					= RGF_WATER_HIP_AIM;

	gubAnimSurfaceCorpseID[ REGFEMALE ][ GENERIC_HIT_DEATH ]						= FMERC_FWD;
	gubAnimSurfaceCorpseID[ REGFEMALE ][ FALLBACK_HIT_DEATH ]						= FMERC_BCK;
	gubAnimSurfaceCorpseID[ REGFEMALE ][ PRONE_HIT_DEATH ]							= FMERC_PRN;
	gubAnimSurfaceCorpseID[ REGFEMALE ][ WATER_DIE ]										= FMERC_WTR;
	gubAnimSurfaceCorpseID[ REGFEMALE ][ FLYBACK_HIT_DEATH ]						= FMERC_DHD;
	gubAnimSurfaceCorpseID[ REGFEMALE ][ JFK_HITDEATH ]									= FMERC_JFK;
	gubAnimSurfaceCorpseID[ REGFEMALE ][ FALLOFF_DEATH ]								= FMERC_FALL;
	gubAnimSurfaceCorpseID[ REGFEMALE ][ FALLOFF_FORWARD_DEATH ]				= FMERC_FALLF;
	gubAnimSurfaceCorpseID[ REGFEMALE ][ FLYBACK_HIT ]									= FMERC_DHD;
	gubAnimSurfaceCorpseID[ REGFEMALE ][ GENERIC_HIT_DEATHTWITCHNB ]		= FMERC_FWD;
	gubAnimSurfaceCorpseID[ REGFEMALE ][ FALLFORWARD_FROMHIT_STAND ]		= FMERC_FWD;
	gubAnimSurfaceCorpseID[ REGFEMALE ][ ENDFALLFORWARD_FROMHIT_CROUCH ]= FMERC_FWD;
	gubAnimSurfaceCorpseID[ REGFEMALE ][ FALLBACK_HIT_STAND ]						= FMERC_BCK;
	gubAnimSurfaceCorpseID[ REGFEMALE ][ FALLBACK_HIT_DEATHTWITCHNB ]		= FMERC_BCK;
	gubAnimSurfaceCorpseID[ REGFEMALE ][ PRONE_HIT_DEATHTWITCHNB ]			= FMERC_PRN;
	gubAnimSurfaceCorpseID[ REGFEMALE ][ PRONE_LAY_FROMHIT ]						= FMERC_PRN;
	gubAnimSurfaceCorpseID[ REGFEMALE ][ FALLOFF ]											= FMERC_FALLF;
	gubAnimSurfaceCorpseID[ REGFEMALE ][ FALLFORWARD_ROOF ]							= FMERC_FALL;
	gubAnimSurfaceCorpseID[ REGFEMALE ][ FLYBACKHIT_STOP ]							= FMERC_DHD;
	gubAnimSurfaceCorpseID[ REGFEMALE ][ STAND_FALLFORWARD_STOP ]				= FMERC_FWD;
	gubAnimSurfaceCorpseID[ REGFEMALE ][ FALLBACKHIT_STOP ]							= FMERC_BCK;
	gubAnimSurfaceCorpseID[ REGFEMALE ][ PRONE_LAYFROMHIT_STOP ]				= FMERC_PRN;
	gubAnimSurfaceCorpseID[ REGFEMALE ][ CHARIOTS_OF_FIRE ]							= BURNT_DEAD;
	gubAnimSurfaceCorpseID[ REGFEMALE ][ BODYEXPLODING ]								= EXPLODE_DEAD;


	//Setup some random stuff
	gRandomAnimDefs[ REGFEMALE ][ 0 ].ubHandRestriction		= RANDOM_ANIM_RIFLEINHAND;
	gRandomAnimDefs[ REGFEMALE ][ 0 ].sAnimID							= FEM_CLEAN;
	gRandomAnimDefs[ REGFEMALE ][ 0 ].ubStartRoll					= 0;
	gRandomAnimDefs[ REGFEMALE ][ 0 ].ubEndRoll						= 9;
	gRandomAnimDefs[ REGFEMALE ][ 0 ].ubFlags							= RANDOM_ANIM_CASUAL;
	gRandomAnimDefs[ REGFEMALE ][ 0 ].ubAnimHeight				= ANIM_STAND;

	gRandomAnimDefs[ REGFEMALE ][ 1 ].ubHandRestriction		= RANDOM_ANIM_NOTHINGINHAND;
	gRandomAnimDefs[ REGFEMALE ][ 1 ].sAnimID							= FEM_KICKSN;
	gRandomAnimDefs[ REGFEMALE ][ 1 ].ubStartRoll					= 10;
	gRandomAnimDefs[ REGFEMALE ][ 1 ].ubEndRoll						= 19;
	gRandomAnimDefs[ REGFEMALE ][ 1 ].ubFlags							= RANDOM_ANIM_CASUAL;
	gRandomAnimDefs[ REGFEMALE ][ 1 ].ubAnimHeight				= ANIM_STAND;

	gRandomAnimDefs[ REGFEMALE ][ 2 ].ubHandRestriction		= RANDOM_ANIM_RIFLEINHAND;
	gRandomAnimDefs[ REGFEMALE ][ 2 ].sAnimID							= FEM_LOOK;
	gRandomAnimDefs[ REGFEMALE ][ 2 ].ubStartRoll					= 10;
	gRandomAnimDefs[ REGFEMALE ][ 2 ].ubEndRoll						= 29;
	gRandomAnimDefs[ REGFEMALE ][ 2 ].ubFlags							= RANDOM_ANIM_LOOKAROUND;
	gRandomAnimDefs[ REGFEMALE ][ 2 ].ubAnimHeight				= ANIM_STAND;

	gRandomAnimDefs[ REGFEMALE ][ 3 ].ubHandRestriction		= RANDOM_ANIM_NOTHINGINHAND;
	gRandomAnimDefs[ REGFEMALE ][ 3 ].sAnimID							= FEM_WIPE;
	gRandomAnimDefs[ REGFEMALE ][ 3 ].ubStartRoll					= 30;
	gRandomAnimDefs[ REGFEMALE ][ 3 ].ubEndRoll						= 39;
	gRandomAnimDefs[ REGFEMALE ][ 3 ].ubFlags							= 0;
	gRandomAnimDefs[ REGFEMALE ][ 3 ].ubAnimHeight				= ANIM_STAND;

	gRandomAnimDefs[ REGFEMALE ][ 4 ].ubHandRestriction		= RANDOM_ANIM_IRRELEVENTINHAND;
	gRandomAnimDefs[ REGFEMALE ][ 4 ].sAnimID							= MERC_HURT_IDLE_ANIM;
	gRandomAnimDefs[ REGFEMALE ][ 4 ].ubStartRoll					= 0;
	gRandomAnimDefs[ REGFEMALE ][ 4 ].ubEndRoll						= 60;
	gRandomAnimDefs[ REGFEMALE ][ 4 ].ubFlags							= RANDOM_ANIM_INJURED;
	gRandomAnimDefs[ REGFEMALE ][ 4 ].ubAnimHeight				= ANIM_STAND;

	gRandomAnimDefs[ REGFEMALE ][ 5 ].ubHandRestriction		= RANDOM_ANIM_IRRELEVENTINHAND;
	gRandomAnimDefs[ REGFEMALE ][ 5 ].sAnimID							= DRUNK_IDLE;
	gRandomAnimDefs[ REGFEMALE ][ 5 ].ubStartRoll					= 61;
	gRandomAnimDefs[ REGFEMALE ][ 5 ].ubEndRoll						= 100;
	gRandomAnimDefs[ REGFEMALE ][ 5 ].ubFlags							= RANDOM_ANIM_DRUNK;
	gRandomAnimDefs[ REGFEMALE ][ 5 ].ubAnimHeight					= ANIM_STAND;

	////////////////////////////////////////////////////
	// MONSTERS

	gubAnimSurfaceIndex[ ADULTFEMALEMONSTER ][ STANDING ]													= AFMONSTERSTANDING;
	gubAnimSurfaceIndex[ ADULTFEMALEMONSTER ][ RUNNING ]													= AFMONSTERSTANDING;
	gubAnimSurfaceIndex[ ADULTFEMALEMONSTER ][ WALKING ]													= AFMONSTERSTANDING;
	gubAnimSurfaceIndex[ ADULTFEMALEMONSTER ][ ADULTMONSTER_BREATHING ]						= AFMONSTERSTANDING;
	gubAnimSurfaceIndex[ ADULTFEMALEMONSTER ][ ADULTMONSTER_WALKING ]							= AFMONSTERWALKING;
	gubAnimSurfaceIndex[ ADULTFEMALEMONSTER ][ ADULTMONSTER_ATTACKING ]						= AFMONSTERATTACK;
	gubAnimSurfaceIndex[ ADULTFEMALEMONSTER ][ ADULTMONSTER_HIT ]									= AFMONSTERDIE;
	gubAnimSurfaceIndex[ ADULTFEMALEMONSTER ][ ADULTMONSTER_DYING ]								= AFMONSTERDIE;
	gubAnimSurfaceIndex[ ADULTFEMALEMONSTER ][ ADULTMONSTER_DYING_STOP ]					= AFMONSTERDIE;
	gubAnimSurfaceIndex[ ADULTFEMALEMONSTER ][ MONSTER_CLOSE_ATTACK ]						= AFMONSTERCLOSEATTACK;
	gubAnimSurfaceIndex[ ADULTFEMALEMONSTER ][ MONSTER_SPIT_ATTACK ]						= AFMONSTERSPITATTACK;
	gubAnimSurfaceIndex[ ADULTFEMALEMONSTER ][ MONSTER_BEGIN_EATTING_FLESH ]		= AFMONSTEREATING;
	gubAnimSurfaceIndex[ ADULTFEMALEMONSTER ][ MONSTER_EATTING_FLESH ]						= AFMONSTEREATING;
	gubAnimSurfaceIndex[ ADULTFEMALEMONSTER ][ MONSTER_END_EATTING_FLESH ]				= AFMONSTEREATING;
	gubAnimSurfaceIndex[ ADULTFEMALEMONSTER ][ MONSTER_UP ]												= AFMUP;
	gubAnimSurfaceIndex[ ADULTFEMALEMONSTER ][ MONSTER_JUMP ]											= AFMJUMP;
	gubAnimSurfaceIndex[ ADULTFEMALEMONSTER ][ MONSTER_MELT ]											= AFMMELT;
	gubAnimSurfaceIndex[ ADULTFEMALEMONSTER ][ MONSTER_WALK_BACKWARDS ]						= AFMONSTERWALKING;

	gubAnimSurfaceCorpseID[ ADULTFEMALEMONSTER ][ MONSTER_MELT ]									= ADULTMONSTER_DEAD;

	// Adult male
	gubAnimSurfaceIndex[ AM_MONSTER ][ STANDING ]																	= AFMONSTERSTANDING;
	gubAnimSurfaceIndex[ AM_MONSTER ][ RUNNING ]																	= AFMONSTERSTANDING;
	gubAnimSurfaceIndex[ AM_MONSTER ][ WALKING ]																	= AFMONSTERSTANDING;
	gubAnimSurfaceIndex[ AM_MONSTER ][ ADULTMONSTER_BREATHING ]										= AFMONSTERSTANDING;
	gubAnimSurfaceIndex[ AM_MONSTER ][ ADULTMONSTER_WALKING ]											= AFMONSTERWALKING;
	gubAnimSurfaceIndex[ AM_MONSTER ][ ADULTMONSTER_ATTACKING ]										= AFMONSTERATTACK;
	gubAnimSurfaceIndex[ AM_MONSTER ][ ADULTMONSTER_HIT ]													= AFMONSTERDIE;
	gubAnimSurfaceIndex[ AM_MONSTER ][ ADULTMONSTER_DYING ]												= AFMONSTERDIE;
	gubAnimSurfaceIndex[ AM_MONSTER ][ ADULTMONSTER_DYING_STOP ]									= AFMONSTERDIE;
	gubAnimSurfaceIndex[ AM_MONSTER ][ MONSTER_CLOSE_ATTACK ]											= AFMONSTERCLOSEATTACK;
	gubAnimSurfaceIndex[ AM_MONSTER ][ MONSTER_SPIT_ATTACK ]											= AFMONSTERSPITATTACK;
	gubAnimSurfaceIndex[ AM_MONSTER ][ MONSTER_BEGIN_EATTING_FLESH ]							= AFMONSTEREATING;
	gubAnimSurfaceIndex[ AM_MONSTER ][ MONSTER_EATTING_FLESH ]										= AFMONSTEREATING;
	gubAnimSurfaceIndex[ AM_MONSTER ][ MONSTER_END_EATTING_FLESH ]								= AFMONSTEREATING;
	gubAnimSurfaceIndex[ AM_MONSTER ][ MONSTER_UP ]																= AFMUP;
	gubAnimSurfaceIndex[ AM_MONSTER ][ MONSTER_JUMP ]															= AFMJUMP;
	gubAnimSurfaceIndex[ AM_MONSTER ][ MONSTER_MELT ]															= AFMMELT;
	gubAnimSurfaceIndex[ AM_MONSTER ][ MONSTER_WALK_BACKWARDS ]										= AFMONSTERWALKING;

	gubAnimSurfaceCorpseID[ AM_MONSTER ][ MONSTER_MELT ]													= ADULTMONSTER_DEAD;

	// Young adult female
	gubAnimSurfaceIndex[ YAF_MONSTER ][ STANDING ]																	= AFMONSTERSTANDING;
	gubAnimSurfaceIndex[ YAF_MONSTER ][ RUNNING ]																	= AFMONSTERSTANDING;
	gubAnimSurfaceIndex[ YAF_MONSTER ][ WALKING ]																	= AFMONSTERSTANDING;
	gubAnimSurfaceIndex[ YAF_MONSTER ][ ADULTMONSTER_BREATHING ]										= AFMONSTERSTANDING;
	gubAnimSurfaceIndex[ YAF_MONSTER ][ ADULTMONSTER_WALKING ]											= AFMONSTERWALKING;
	gubAnimSurfaceIndex[ YAF_MONSTER ][ ADULTMONSTER_ATTACKING ]										= AFMONSTERATTACK;
	gubAnimSurfaceIndex[ YAF_MONSTER ][ ADULTMONSTER_HIT ]													= AFMONSTERDIE;
	gubAnimSurfaceIndex[ YAF_MONSTER ][ ADULTMONSTER_DYING ]												= AFMONSTERDIE;
	gubAnimSurfaceIndex[ YAF_MONSTER ][ ADULTMONSTER_DYING_STOP ]									= AFMONSTERDIE;
	gubAnimSurfaceIndex[ YAF_MONSTER ][ MONSTER_CLOSE_ATTACK ]											= AFMONSTERCLOSEATTACK;
	gubAnimSurfaceIndex[ YAF_MONSTER ][ MONSTER_SPIT_ATTACK ]											= AFMONSTERSPITATTACK;
	gubAnimSurfaceIndex[ YAF_MONSTER ][ MONSTER_BEGIN_EATTING_FLESH ]							= AFMONSTEREATING;
	gubAnimSurfaceIndex[ YAF_MONSTER ][ MONSTER_EATTING_FLESH ]										= AFMONSTEREATING;
	gubAnimSurfaceIndex[ YAF_MONSTER ][ MONSTER_END_EATTING_FLESH ]								= AFMONSTEREATING;
	gubAnimSurfaceIndex[ YAF_MONSTER ][ MONSTER_UP ]															= AFMUP;
	gubAnimSurfaceIndex[ YAF_MONSTER ][ MONSTER_JUMP ]														= AFMJUMP;
	gubAnimSurfaceIndex[ YAF_MONSTER ][ MONSTER_MELT]												= AFMMELT;
	gubAnimSurfaceIndex[ YAF_MONSTER ][ MONSTER_WALK_BACKWARDS ]									= AFMONSTERWALKING;

	gubAnimSurfaceCorpseID[ YAF_MONSTER ][ MONSTER_MELT ]										= ADULTMONSTER_DEAD;


	// Young adult male
	gubAnimSurfaceIndex[ YAM_MONSTER ][ STANDING ]																	= AFMONSTERSTANDING;
	gubAnimSurfaceIndex[ YAM_MONSTER ][ RUNNING ]																	= AFMONSTERSTANDING;
	gubAnimSurfaceIndex[ YAM_MONSTER ][ WALKING ]																	= AFMONSTERSTANDING;
	gubAnimSurfaceIndex[ YAM_MONSTER ][ ADULTMONSTER_BREATHING ]										= AFMONSTERSTANDING;
	gubAnimSurfaceIndex[ YAM_MONSTER ][ ADULTMONSTER_WALKING ]											= AFMONSTERWALKING;
	gubAnimSurfaceIndex[ YAM_MONSTER ][ ADULTMONSTER_ATTACKING ]										= AFMONSTERATTACK;
	gubAnimSurfaceIndex[ YAM_MONSTER ][ ADULTMONSTER_HIT ]													= AFMONSTERDIE;
	gubAnimSurfaceIndex[ YAM_MONSTER ][ ADULTMONSTER_DYING ]												= AFMONSTERDIE;
	gubAnimSurfaceIndex[ YAM_MONSTER ][ ADULTMONSTER_DYING_STOP ]									= AFMONSTERDIE;
	gubAnimSurfaceIndex[ YAM_MONSTER ][ MONSTER_CLOSE_ATTACK ]											= AFMONSTERCLOSEATTACK;
	gubAnimSurfaceIndex[ YAM_MONSTER ][ MONSTER_SPIT_ATTACK ]											= AFMONSTERSPITATTACK;
	gubAnimSurfaceIndex[ YAM_MONSTER ][ MONSTER_BEGIN_EATTING_FLESH ]							= AFMONSTEREATING;
	gubAnimSurfaceIndex[ YAM_MONSTER ][ MONSTER_EATTING_FLESH ]										= AFMONSTEREATING;
	gubAnimSurfaceIndex[ YAM_MONSTER ][ MONSTER_END_EATTING_FLESH ]								= AFMONSTEREATING;
	gubAnimSurfaceIndex[ YAM_MONSTER ][ MONSTER_UP ]															= AFMUP;
	gubAnimSurfaceIndex[ YAM_MONSTER ][ MONSTER_JUMP ]														= AFMJUMP;
	gubAnimSurfaceIndex[ YAM_MONSTER ][ MONSTER_MELT ]											= AFMMELT;
	gubAnimSurfaceIndex[ YAM_MONSTER ][ MONSTER_WALK_BACKWARDS ]									= AFMONSTERWALKING;

	gubAnimSurfaceCorpseID[ YAM_MONSTER ][ MONSTER_MELT ]										= ADULTMONSTER_DEAD;


	gubAnimSurfaceIndex[ LARVAE_MONSTER ][ LARVAE_BREATH ]												= LVBREATH;
	gubAnimSurfaceIndex[ LARVAE_MONSTER ][ LARVAE_HIT ]														= LVDIE;
	gubAnimSurfaceIndex[ LARVAE_MONSTER ][ LARVAE_DIE ]														= LVDIE;
	gubAnimSurfaceIndex[ LARVAE_MONSTER ][ LARVAE_DIE_STOP ]											= LVDIE;
	gubAnimSurfaceIndex[ LARVAE_MONSTER ][ LARVAE_WALK ]													= LVWALK;

	gubAnimSurfaceCorpseID[ LARVAE_MONSTER ][ LARVAE_DIE ]												= LARVAEMONSTER_DEAD;

	gubAnimSurfaceIndex[ INFANT_MONSTER ][ STANDING ]															= IBREATH;
	gubAnimSurfaceIndex[ INFANT_MONSTER ][ RUNNING ]															= IWALK;
	gubAnimSurfaceIndex[ INFANT_MONSTER ][ WALKING ]															= IWALK;
	gubAnimSurfaceIndex[ INFANT_MONSTER ][ INFANT_HIT ]														= IDIE;
	gubAnimSurfaceIndex[ INFANT_MONSTER ][ INFANT_DIE ]														= IDIE;
	gubAnimSurfaceIndex[ INFANT_MONSTER ][ INFANT_DIE_STOP ]											= IDIE;
	gubAnimSurfaceIndex[ INFANT_MONSTER ][ INFANT_ATTACK ]												= IATTACK;
	gubAnimSurfaceIndex[ INFANT_MONSTER ][ INFANT_BEGIN_EATTING_FLESH ]						= IEAT;
	gubAnimSurfaceIndex[ INFANT_MONSTER ][ INFANT_EATTING_FLESH ]									= IEAT;
	gubAnimSurfaceIndex[ INFANT_MONSTER ][ INFANT_END_EATTING_FLESH ]							= IEAT;
	gubAnimSurfaceIndex[ INFANT_MONSTER ][ WALK_BACKWARDS ]									= IWALK;


	gubAnimSurfaceCorpseID[ INFANT_MONSTER ][ INFANT_DIE ]												= INFANTMONSTER_DEAD;


	gubAnimSurfaceIndex[ QUEENMONSTER ][ QUEEN_MONSTER_BREATHING ]								= QUEENMONSTERSTANDING;
	gubAnimSurfaceIndex[ QUEENMONSTER ][ QUEEN_HIT ]															= QUEENMONSTERDEATH;
	gubAnimSurfaceIndex[ QUEENMONSTER ][ QUEEN_DIE ]															= QUEENMONSTERDEATH;
	gubAnimSurfaceIndex[ QUEENMONSTER ][ QUEEN_DIE_STOP ]													= QUEENMONSTERDEATH;
	gubAnimSurfaceIndex[ QUEENMONSTER ][ QUEEN_INTO_READY ]												= QUEENMONSTERREADY;
	gubAnimSurfaceIndex[ QUEENMONSTER ][ QUEEN_READY ]														= QUEENMONSTERREADY;
	gubAnimSurfaceIndex[ QUEENMONSTER ][ QUEEN_CALL ]															= QUEENMONSTERREADY;
	gubAnimSurfaceIndex[ QUEENMONSTER ][ QUEEN_END_READY ]												= QUEENMONSTERREADY;
	gubAnimSurfaceIndex[ QUEENMONSTER ][ QUEEN_SPIT ]															= QUEENMONSTERSPIT_SW;
	gubAnimSurfaceIndex[ QUEENMONSTER ][ QUEEN_SWIPE ]														= QUEENMONSTERSWIPE;

	gubAnimSurfaceCorpseID[ QUEENMONSTER ][ QUEEN_DIE ]		 										= QUEEN_MONSTER_DEAD;


	//////
	// FAT GUY
	gubAnimSurfaceIndex[ FATCIV ][ STANDING ]																			= FATMANSTANDING;
	gubAnimSurfaceIndex[ FATCIV ][ WALKING ]																			= FATMANWALKING;
	gubAnimSurfaceIndex[ FATCIV ][ RUNNING ]																			= FATMANRUNNING;
	gubAnimSurfaceIndex[ FATCIV ][ GENERIC_HIT_STAND ]														= FATMANDIE;
	gubAnimSurfaceIndex[ FATCIV ][ GENERIC_HIT_DEATHTWITCHNB ]										= FATMANDIE;
	gubAnimSurfaceIndex[ FATCIV ][ GENERIC_HIT_DEATHTWITCHB ]											= FATMANDIE;
	gubAnimSurfaceIndex[ FATCIV ][ FALLFORWARD_FROMHIT_STAND ]										= FATMANDIE;
	gubAnimSurfaceIndex[ FATCIV ][ FALLFORWARD_FROMHIT_CROUCH ]										= FATMANDIE;
	gubAnimSurfaceIndex[ FATCIV ][ ENDFALLFORWARD_FROMHIT_CROUCH ]										= FATMANDIE;
	gubAnimSurfaceIndex[ FATCIV ][ FALLFORWARD_HITDEATH_STOP ]										= FATMANDIE;
	gubAnimSurfaceIndex[ FATCIV ][ STAND_FALLFORWARD_STOP ]												= FATMANDIE;
	gubAnimSurfaceIndex[ FATCIV ][ GENERIC_HIT_DEATH ]														= FATMANDIE;
	gubAnimSurfaceIndex[ FATCIV ][ FATCIV_ASS_SCRATCH ]														= FATMANASS;
	gubAnimSurfaceIndex[ FATCIV ][ OPEN_DOOR ]																		= FATMANACT;
	gubAnimSurfaceIndex[ FATCIV ][ OPEN_STRUCT ]																	= FATMANACT;
	gubAnimSurfaceIndex[ FATCIV ][ GIVE_ITEM ]																		= FATMANACT;
	gubAnimSurfaceIndex[ FATCIV ][ END_OPEN_DOOR ]																= FATMANACT;
	gubAnimSurfaceIndex[ FATCIV ][ END_OPEN_LOCKED_DOOR ]													= FATMANACT;
	gubAnimSurfaceIndex[ FATCIV ][ CLOSE_DOOR ]																		= FATMANACT;
	gubAnimSurfaceIndex[ FATCIV ][ ADJACENT_GET_ITEM ]														= FATMANACT;
	gubAnimSurfaceIndex[ FATCIV ][ START_COWER ]																	= FATMANCOWER;
	gubAnimSurfaceIndex[ FATCIV ][ COWERING ]																			= FATMANCOWER;
	gubAnimSurfaceIndex[ FATCIV ][ END_COWER ]																		= FATMANCOWER;
	gubAnimSurfaceIndex[ FATCIV ][ CIV_DIE2 ]																			= FATMANDIE2;
	gubAnimSurfaceIndex[ FATCIV ][ CIV_COWER_HIT ]																= FATMANCOWERHIT;

	gubAnimSurfaceCorpseID[ FATCIV ][ GENERIC_HIT_DEATH ]													= FT_DEAD1;
	gubAnimSurfaceCorpseID[ FATCIV ][ CIV_DIE2 ]																	= FT_DEAD2;

	gRandomAnimDefs[ FATCIV ][ 0 ].ubHandRestriction		= RANDOM_ANIM_IRRELEVENTINHAND;
	gRandomAnimDefs[ FATCIV ][ 0 ].sAnimID							= FATCIV_ASS_SCRATCH;
	gRandomAnimDefs[ FATCIV ][ 0 ].ubStartRoll					= 0;
	gRandomAnimDefs[ FATCIV ][ 0 ].ubEndRoll						= 10;
	gRandomAnimDefs[ FATCIV ][ 0 ].ubFlags							= RANDOM_ANIM_CASUAL;
	gRandomAnimDefs[ FATCIV ][ 0 ].ubAnimHeight					= ANIM_STAND;


	// Common civ
	gubAnimSurfaceIndex[ MANCIV ][ STANDING ]																			= MANCIVSTANDING;
	gubAnimSurfaceIndex[ MANCIV ][ WALKING ]																			= MANCIVWALKING;
	gubAnimSurfaceIndex[ MANCIV ][ RUNNING ]																			= MANCIVRUNNING;
	gubAnimSurfaceIndex[ MANCIV ][ GENERIC_HIT_STAND ]														= MANCIVDIE;
	gubAnimSurfaceIndex[ MANCIV ][ GENERIC_HIT_DEATHTWITCHNB ]										= MANCIVDIE;
	gubAnimSurfaceIndex[ MANCIV ][ GENERIC_HIT_DEATHTWITCHB ]											= MANCIVDIE;
	gubAnimSurfaceIndex[ MANCIV ][ FALLFORWARD_FROMHIT_STAND ]										= MANCIVDIE;
	gubAnimSurfaceIndex[ MANCIV ][ FALLFORWARD_FROMHIT_CROUCH ]										= MANCIVDIE;
	gubAnimSurfaceIndex[ MANCIV ][ ENDFALLFORWARD_FROMHIT_CROUCH ]										= MANCIVDIE;
	gubAnimSurfaceIndex[ MANCIV ][ FALLFORWARD_HITDEATH_STOP ]										= MANCIVDIE;
	gubAnimSurfaceIndex[ MANCIV ][ STAND_FALLFORWARD_STOP ]												= MANCIVDIE;
	gubAnimSurfaceIndex[ MANCIV ][ GENERIC_HIT_DEATH ]														= MANCIVDIE;
	gubAnimSurfaceIndex[ MANCIV ][ OPEN_DOOR ]																		= MANCIVACT;
	gubAnimSurfaceIndex[ MANCIV ][ OPEN_STRUCT ]																	= MANCIVACT;
	gubAnimSurfaceIndex[ MANCIV ][ GIVE_ITEM ]																		= MANCIVACT;
	gubAnimSurfaceIndex[ MANCIV ][ END_OPEN_DOOR ]																= MANCIVACT;
	gubAnimSurfaceIndex[ MANCIV ][ END_OPEN_LOCKED_DOOR ]													= MANCIVACT;
	gubAnimSurfaceIndex[ MANCIV ][ CLOSE_DOOR ]																		= MANCIVACT;
	gubAnimSurfaceIndex[ MANCIV ][ ADJACENT_GET_ITEM ]														= MANCIVACT;
	gubAnimSurfaceIndex[ MANCIV ][ START_COWER ]																	= MANCIVCOWER;
	gubAnimSurfaceIndex[ MANCIV ][ COWERING ]																			= MANCIVCOWER;
	gubAnimSurfaceIndex[ MANCIV ][ END_COWER ]																		= MANCIVCOWER;
	gubAnimSurfaceIndex[ MANCIV ][ CIV_DIE2 ]																			= MANCIVDIE2;
	gubAnimSurfaceIndex[ MANCIV ][ SLAP_HIT ]																			= MANCIVSMACKED;
	gubAnimSurfaceIndex[ MANCIV ][ PUNCH ]																				= MANCIVPUNCH;
	gubAnimSurfaceIndex[ MANCIV ][ PUNCH_BREATH ]																	= MANCIVPUNCH;
	gubAnimSurfaceIndex[ MANCIV ][ BEGIN_OPENSTRUCT ]															= MANCIVACT;
	gubAnimSurfaceIndex[ MANCIV ][ END_OPENSTRUCT ]																= MANCIVACT;
	gubAnimSurfaceIndex[ MANCIV ][ END_OPENSTRUCT_LOCKED ]												= MANCIVACT;
	gubAnimSurfaceIndex[ MANCIV ][ CIV_COWER_HIT ]																= MANCIVCOWERHIT;


	gubAnimSurfaceCorpseID[ MANCIV ][ GENERIC_HIT_DEATH ]													= M_DEAD1;
	gubAnimSurfaceCorpseID[ MANCIV ][ CIV_DIE2 ]																	= M_DEAD2;


	// mini skirt civ
	gubAnimSurfaceIndex[ MINICIV ][ STANDING ]																		= MINICIVSTANDING;
	gubAnimSurfaceIndex[ MINICIV ][ WALKING ]																			= MINICIVWALKING;
	gubAnimSurfaceIndex[ MINICIV ][ RUNNING ]																			= MINICIVRUNNING;
	gubAnimSurfaceIndex[ MINICIV ][ GENERIC_HIT_STAND ]														= MINICIVDIE;
	gubAnimSurfaceIndex[ MINICIV ][ GENERIC_HIT_DEATHTWITCHNB ]										= MINICIVDIE;
	gubAnimSurfaceIndex[ MINICIV ][ GENERIC_HIT_DEATHTWITCHB ]										= MINICIVDIE;
	gubAnimSurfaceIndex[ MINICIV ][ FALLFORWARD_FROMHIT_STAND ]										= MINICIVDIE;
	gubAnimSurfaceIndex[ MINICIV ][ FALLFORWARD_FROMHIT_CROUCH ]									= MINICIVDIE;
	gubAnimSurfaceIndex[ MINICIV ][ ENDFALLFORWARD_FROMHIT_CROUCH ]									= MINICIVDIE;
	gubAnimSurfaceIndex[ MINICIV ][ FALLFORWARD_HITDEATH_STOP ]										= MINICIVDIE;
	gubAnimSurfaceIndex[ MINICIV ][ STAND_FALLFORWARD_STOP ]											= MINICIVDIE;
	gubAnimSurfaceIndex[ MINICIV ][ GENERIC_HIT_DEATH ]														= MINICIVDIE;
	gubAnimSurfaceIndex[ MINICIV ][ MINIGIRL_STOCKING ]														= MINISTOCKING;
	gubAnimSurfaceIndex[ MINICIV ][ OPEN_DOOR ]																		= MINIACT;
	gubAnimSurfaceIndex[ MINICIV ][ OPEN_STRUCT ]																	= MINIACT;
	gubAnimSurfaceIndex[ MINICIV ][ GIVE_ITEM ]																		= MINIACT;
	gubAnimSurfaceIndex[ MINICIV ][ END_OPEN_DOOR ]																= MINIACT;
	gubAnimSurfaceIndex[ MINICIV ][ END_OPEN_LOCKED_DOOR ]												= MINIACT;
	gubAnimSurfaceIndex[ MINICIV ][ CLOSE_DOOR ]																	= MINIACT;
	gubAnimSurfaceIndex[ MINICIV ][ ADJACENT_GET_ITEM ]														= MINIACT;
	gubAnimSurfaceIndex[ MINICIV ][ START_COWER ]																	= MINICOWER;
	gubAnimSurfaceIndex[ MINICIV ][ COWERING ]																		= MINICOWER;
	gubAnimSurfaceIndex[ MINICIV ][ END_COWER ]																		= MINICOWER;
	gubAnimSurfaceIndex[ MINICIV ][ CIV_DIE2 ]																		= MINIDIE2;
	gubAnimSurfaceIndex[ MINICIV ][ CIV_COWER_HIT ]																= MINICOWERHIT;

	gubAnimSurfaceCorpseID[ MINICIV ][ GENERIC_HIT_DEATH ]												= S_DEAD1;
	gubAnimSurfaceCorpseID[ MINICIV ][ CIV_DIE2 ]																	= S_DEAD2;


	gRandomAnimDefs[ MINICIV ][ 0 ].ubHandRestriction		= RANDOM_ANIM_IRRELEVENTINHAND;
	gRandomAnimDefs[ MINICIV ][ 0 ].sAnimID							= MINIGIRL_STOCKING;
	gRandomAnimDefs[ MINICIV ][ 0 ].ubStartRoll					= 0;
	gRandomAnimDefs[ MINICIV ][ 0 ].ubEndRoll						= 10;
	gRandomAnimDefs[ MINICIV ][ 0 ].ubFlags							= RANDOM_ANIM_CASUAL;
	gRandomAnimDefs[ MINICIV ][ 0 ].ubAnimHeight				= ANIM_STAND;


	// dress skirt civ
	gubAnimSurfaceIndex[ DRESSCIV ][ STANDING ]																		= DRESSCIVSTANDING;
	gubAnimSurfaceIndex[ DRESSCIV ][ WALKING ]																		= DRESSCIVWALKING;
	gubAnimSurfaceIndex[ DRESSCIV ][ RUNNING ]																		= DRESSCIVRUNNING;
	gubAnimSurfaceIndex[ DRESSCIV ][ GENERIC_HIT_STAND ]													= DRESSCIVDIE;
	gubAnimSurfaceIndex[ DRESSCIV ][ GENERIC_HIT_DEATHTWITCHNB ]									= DRESSCIVDIE;
	gubAnimSurfaceIndex[ DRESSCIV ][ GENERIC_HIT_DEATHTWITCHB ]										= DRESSCIVDIE;
	gubAnimSurfaceIndex[ DRESSCIV ][ FALLFORWARD_FROMHIT_STAND ]									= DRESSCIVDIE;
	gubAnimSurfaceIndex[ DRESSCIV ][ FALLFORWARD_FROMHIT_CROUCH ]									= DRESSCIVDIE;
	gubAnimSurfaceIndex[ DRESSCIV ][ ENDFALLFORWARD_FROMHIT_CROUCH ]									= DRESSCIVDIE;
	gubAnimSurfaceIndex[ DRESSCIV ][ FALLFORWARD_HITDEATH_STOP ]									= DRESSCIVDIE;
	gubAnimSurfaceIndex[ DRESSCIV ][ STAND_FALLFORWARD_STOP ]											= DRESSCIVDIE;
	gubAnimSurfaceIndex[ DRESSCIV ][ GENERIC_HIT_DEATH ]													= DRESSCIVDIE;
	gubAnimSurfaceIndex[ DRESSCIV ][ OPEN_DOOR ]																	= DRESSCIVACT;
	gubAnimSurfaceIndex[ DRESSCIV ][ OPEN_STRUCT ]																= DRESSCIVACT;
	gubAnimSurfaceIndex[ DRESSCIV ][ GIVE_ITEM ]																	= DRESSCIVACT;
	gubAnimSurfaceIndex[ DRESSCIV ][ END_OPEN_DOOR ]															= DRESSCIVACT;
	gubAnimSurfaceIndex[ DRESSCIV ][ END_OPEN_LOCKED_DOOR ]												= DRESSCIVACT;
	gubAnimSurfaceIndex[ DRESSCIV ][ CLOSE_DOOR ]																	= DRESSCIVACT;
	gubAnimSurfaceIndex[ DRESSCIV ][ ADJACENT_GET_ITEM ]													= DRESSCIVACT;
	gubAnimSurfaceIndex[ DRESSCIV ][ START_COWER ]																= DRESSCIVCOWER;
	gubAnimSurfaceIndex[ DRESSCIV ][ COWERING ]																		= DRESSCIVCOWER;
	gubAnimSurfaceIndex[ DRESSCIV ][ END_COWER ]																	= DRESSCIVCOWER;
	gubAnimSurfaceIndex[ DRESSCIV ][ CIV_DIE2 ]																		= DRESSCIVDIE2;
	gubAnimSurfaceIndex[ DRESSCIV ][ CIV_COWER_HIT ]															= DRESSCIVCOWERHIT;

	gubAnimSurfaceCorpseID[ DRESSCIV ][ GENERIC_HIT_DEATH ]												= W_DEAD1;
	gubAnimSurfaceCorpseID[ DRESSCIV ][ CIV_DIE2 ]																= W_DEAD2;

	// HATKID civ
	gubAnimSurfaceIndex[ HATKIDCIV ][ STANDING ]																	= HATKIDCIVSTANDING;
	gubAnimSurfaceIndex[ HATKIDCIV ][ WALKING ]																		= HATKIDCIVWALKING;
	gubAnimSurfaceIndex[ HATKIDCIV ][ RUNNING ]																		= HATKIDCIVRUNNING;
	gubAnimSurfaceIndex[ HATKIDCIV ][ GENERIC_HIT_STAND ]													= HATKIDCIVDIE;
	gubAnimSurfaceIndex[ HATKIDCIV ][ GENERIC_HIT_DEATHTWITCHNB ]									= HATKIDCIVDIE;
	gubAnimSurfaceIndex[ HATKIDCIV ][ GENERIC_HIT_DEATHTWITCHB ]									= HATKIDCIVDIE;
	gubAnimSurfaceIndex[ HATKIDCIV ][ FALLFORWARD_FROMHIT_STAND ]									= HATKIDCIVDIE;
	gubAnimSurfaceIndex[ HATKIDCIV ][ FALLFORWARD_FROMHIT_CROUCH ]									= HATKIDCIVDIE;
	gubAnimSurfaceIndex[ HATKIDCIV ][ ENDFALLFORWARD_FROMHIT_CROUCH ]									= HATKIDCIVDIE;
	gubAnimSurfaceIndex[ HATKIDCIV ][ FALLFORWARD_HITDEATH_STOP ]									= HATKIDCIVDIE;
	gubAnimSurfaceIndex[ HATKIDCIV ][ STAND_FALLFORWARD_STOP ]										= HATKIDCIVDIE;
	gubAnimSurfaceIndex[ HATKIDCIV ][ GENERIC_HIT_DEATH ]													= HATKIDCIVDIE;
	gubAnimSurfaceIndex[ HATKIDCIV ][ JFK_HITDEATH ]															= HATKIDCIVJFK;
	gubAnimSurfaceIndex[ HATKIDCIV ][ JFK_HITDEATH_STOP ]													= HATKIDCIVJFK;
	gubAnimSurfaceIndex[ HATKIDCIV ][ JFK_HITDEATH_TWITCHB ]											= HATKIDCIVJFK;
	gubAnimSurfaceIndex[ HATKIDCIV ][ HATKID_YOYO ]																= HATKIDCIVYOYO;
	gubAnimSurfaceIndex[ HATKIDCIV ][ OPEN_DOOR ]																	= HATKIDCIVACT;
	gubAnimSurfaceIndex[ HATKIDCIV ][ OPEN_STRUCT ]																= HATKIDCIVACT;
	gubAnimSurfaceIndex[ HATKIDCIV ][ GIVE_ITEM ]																	= HATKIDCIVACT;
	gubAnimSurfaceIndex[ HATKIDCIV ][ END_OPEN_DOOR ]															= HATKIDCIVACT;
	gubAnimSurfaceIndex[ HATKIDCIV ][ END_OPEN_LOCKED_DOOR ]											= HATKIDCIVACT;
	gubAnimSurfaceIndex[ HATKIDCIV ][ CLOSE_DOOR ]																= HATKIDCIVACT;
	gubAnimSurfaceIndex[ HATKIDCIV ][ ADJACENT_GET_ITEM ]													= HATKIDCIVACT;
	gubAnimSurfaceIndex[ HATKIDCIV ][ START_COWER ]																= HATKIDCIVCOWER;
	gubAnimSurfaceIndex[ HATKIDCIV ][ COWERING ]																	= HATKIDCIVCOWER;
	gubAnimSurfaceIndex[ HATKIDCIV ][ END_COWER ]																	= HATKIDCIVCOWER;
	gubAnimSurfaceIndex[ HATKIDCIV ][ CIV_DIE2 ]																	= HATKIDCIVDIE2;
	gubAnimSurfaceIndex[ HATKIDCIV ][ CIV_COWER_HIT ]															= HATKIDCIVCOWERHIT;
	gubAnimSurfaceIndex[ HATKIDCIV ][ KID_SKIPPING ]															= HATKIDCIVSKIP;


	gubAnimSurfaceCorpseID[ HATKIDCIV ][ GENERIC_HIT_DEATH ]											= H_DEAD1;
	gubAnimSurfaceCorpseID[ HATKIDCIV ][ CIV_DIE2 ]																= H_DEAD2;

	gRandomAnimDefs[ HATKIDCIV ][ 0 ].ubHandRestriction		= RANDOM_ANIM_IRRELEVENTINHAND;
	gRandomAnimDefs[ HATKIDCIV ][ 0 ].sAnimID							= HATKID_YOYO;
	gRandomAnimDefs[ HATKIDCIV ][ 0 ].ubStartRoll					= 0;
	gRandomAnimDefs[ HATKIDCIV ][ 0 ].ubEndRoll						= 10;
	gRandomAnimDefs[ HATKIDCIV ][ 0 ].ubFlags							= RANDOM_ANIM_CASUAL;
	gRandomAnimDefs[ HATKIDCIV ][ 0 ].ubAnimHeight				= ANIM_STAND;


	// KID civ
	gubAnimSurfaceIndex[ KIDCIV ][ STANDING ]																			= KIDCIVSTANDING;
	gubAnimSurfaceIndex[ KIDCIV ][ WALKING ]																			= KIDCIVWALKING;
	gubAnimSurfaceIndex[ KIDCIV ][ RUNNING ]																			= KIDCIVRUNNING;
	gubAnimSurfaceIndex[ KIDCIV ][ GENERIC_HIT_STAND ]														= KIDCIVDIE;
	gubAnimSurfaceIndex[ KIDCIV ][ GENERIC_HIT_DEATHTWITCHNB ]										= KIDCIVDIE;
	gubAnimSurfaceIndex[ KIDCIV ][ GENERIC_HIT_DEATHTWITCHB ]											= KIDCIVDIE;
	gubAnimSurfaceIndex[ KIDCIV ][ FALLFORWARD_FROMHIT_STAND ]										= KIDCIVDIE;
	gubAnimSurfaceIndex[ KIDCIV ][ FALLFORWARD_FROMHIT_CROUCH ]										= KIDCIVDIE;
	gubAnimSurfaceIndex[ KIDCIV ][ ENDFALLFORWARD_FROMHIT_CROUCH ]										= KIDCIVDIE;
	gubAnimSurfaceIndex[ KIDCIV ][ FALLFORWARD_HITDEATH_STOP ]										= KIDCIVDIE;
	gubAnimSurfaceIndex[ KIDCIV ][ STAND_FALLFORWARD_STOP ]												= KIDCIVDIE;
	gubAnimSurfaceIndex[ KIDCIV ][ GENERIC_HIT_DEATH ]														= KIDCIVDIE;
	gubAnimSurfaceIndex[ KIDCIV ][ JFK_HITDEATH ]																	=	KIDCIVJFK;
	gubAnimSurfaceIndex[ KIDCIV ][ JFK_HITDEATH_STOP ]														= KIDCIVJFK;
	gubAnimSurfaceIndex[ KIDCIV ][ JFK_HITDEATH_TWITCHB ]													= KIDCIVJFK;
	gubAnimSurfaceIndex[ KIDCIV ][ KID_ARMPIT ]																		= KIDCIVARMPIT;
	gubAnimSurfaceIndex[ KIDCIV ][ OPEN_DOOR ]																		= KIDCIVACT;
	gubAnimSurfaceIndex[ KIDCIV ][ OPEN_STRUCT ]																	= KIDCIVACT;
	gubAnimSurfaceIndex[ KIDCIV ][ GIVE_ITEM ]																		= KIDCIVACT;
	gubAnimSurfaceIndex[ KIDCIV ][ END_OPEN_DOOR ]																= KIDCIVACT;
	gubAnimSurfaceIndex[ KIDCIV ][ END_OPEN_LOCKED_DOOR ]													= KIDCIVACT;
	gubAnimSurfaceIndex[ KIDCIV ][ CLOSE_DOOR ]																		= KIDCIVACT;
	gubAnimSurfaceIndex[ KIDCIV ][ ADJACENT_GET_ITEM ]														= KIDCIVACT;
	gubAnimSurfaceIndex[ KIDCIV ][ START_COWER ]																	= KIDCIVCOWER;
	gubAnimSurfaceIndex[ KIDCIV ][ COWERING ]																			= KIDCIVCOWER;
	gubAnimSurfaceIndex[ KIDCIV ][ END_COWER ]																		= KIDCIVCOWER;
	gubAnimSurfaceIndex[ KIDCIV ][ CIV_DIE2 ]																			= KIDCIVDIE2;
	gubAnimSurfaceIndex[ KIDCIV ][ CIV_COWER_HIT ]																= KIDCIVCOWERHIT;
	gubAnimSurfaceIndex[ KIDCIV ][ KID_SKIPPING ]																	= KIDCIVSKIP;

	gubAnimSurfaceCorpseID[ KIDCIV ][ GENERIC_HIT_DEATH ]													= K_DEAD1;
	gubAnimSurfaceCorpseID[ KIDCIV ][ CIV_DIE2 ]																	= K_DEAD2;


	gRandomAnimDefs[ KIDCIV ][ 0 ].ubHandRestriction		= RANDOM_ANIM_IRRELEVENTINHAND;
	gRandomAnimDefs[ KIDCIV ][ 0 ].sAnimID							= KID_ARMPIT;
	gRandomAnimDefs[ KIDCIV ][ 0 ].ubStartRoll					= 0;
	gRandomAnimDefs[ KIDCIV ][ 0 ].ubEndRoll						= 10;
	gRandomAnimDefs[ KIDCIV ][ 0 ].ubFlags							= RANDOM_ANIM_CASUAL;
	gRandomAnimDefs[ KIDCIV ][ 0 ].ubAnimHeight					= ANIM_STAND;

	//CRIPPLE
	gubAnimSurfaceIndex[ CRIPPLECIV ][ STANDING ]																	= CRIPCIVSTANDING;
	gubAnimSurfaceIndex[ CRIPPLECIV ][ WALKING ]																	= CRIPCIVWALKING;
	gubAnimSurfaceIndex[ CRIPPLECIV ][ RUNNING ]																	= CRIPCIVRUNNING;
	gubAnimSurfaceIndex[ CRIPPLECIV ][ CRIPPLE_BEG ]															= CRIPCIVBEG;
	gubAnimSurfaceIndex[ CRIPPLECIV ][ CRIPPLE_HIT ]															= CRIPCIVDIE;
	gubAnimSurfaceIndex[ CRIPPLECIV ][ CRIPPLE_DIE ]															= CRIPCIVDIE;
	gubAnimSurfaceIndex[ CRIPPLECIV ][ CRIPPLE_DIE_STOP ]													= CRIPCIVDIE;
	gubAnimSurfaceIndex[ CRIPPLECIV ][ CRIPPLE_DIE_FLYBACK ]											= CRIPCIVDIE2;
	gubAnimSurfaceIndex[ CRIPPLECIV ][ CRIPPLE_DIE_FLYBACK_STOP ]									= CRIPCIVDIE2;
	gubAnimSurfaceIndex[ CRIPPLECIV ][ CRIPPLE_KICKOUT ]													= CRIPCIVKICK;
	gubAnimSurfaceIndex[ CRIPPLECIV ][ CRIPPLE_OPEN_DOOR ]											= CRIPCIVBEG;
	gubAnimSurfaceIndex[ CRIPPLECIV ][ CRIPPLE_CLOSE_DOOR ]											= CRIPCIVBEG;
	gubAnimSurfaceIndex[ CRIPPLECIV ][ CRIPPLE_END_OPEN_DOOR ]									= CRIPCIVBEG;
	gubAnimSurfaceIndex[ CRIPPLECIV ][ CRIPPLE_END_OPEN_LOCKED_DOOR ]						= CRIPCIVBEG;

	gubAnimSurfaceCorpseID[ CRIPPLECIV ][ CRIPPLE_DIE ]														= SMERC_BCK;

	gRandomAnimDefs[ CRIPPLECIV ][ 0 ].ubHandRestriction		= RANDOM_ANIM_IRRELEVENTINHAND;
	gRandomAnimDefs[ CRIPPLECIV ][ 0 ].sAnimID							= CRIPPLE_BEG;
	gRandomAnimDefs[ CRIPPLECIV ][ 0 ].ubStartRoll					= 30;
	gRandomAnimDefs[ CRIPPLECIV ][ 0 ].ubEndRoll						= 70;
	gRandomAnimDefs[ CRIPPLECIV ][ 0 ].ubFlags							= RANDOM_ANIM_CASUAL;
	gRandomAnimDefs[ CRIPPLECIV ][ 0 ].ubAnimHeight					= ANIM_STAND;


	// COW
	gubAnimSurfaceIndex[ COW ][ STANDING ]																				= COWSTANDING;
	gubAnimSurfaceIndex[ COW ][ WALKING ]																					= COWWALKING;
	gubAnimSurfaceIndex[ COW ][ COW_EATING ]																			= COWEAT;
	gubAnimSurfaceIndex[ COW ][ COW_HIT ]																					= COWDIE;
	gubAnimSurfaceIndex[ COW ][ COW_DYING ]																				= COWDIE;
	gubAnimSurfaceIndex[ COW ][ COW_DYING_STOP ]																	= COWDIE;

	gubAnimSurfaceCorpseID[ COW ][ COW_DYING ]																		= COW_DEAD;


	gRandomAnimDefs[ COW ][ 0 ].ubHandRestriction		= RANDOM_ANIM_IRRELEVENTINHAND;
	gRandomAnimDefs[ COW ][ 0 ].sAnimID							= COW_EATING;
	gRandomAnimDefs[ COW ][ 0 ].ubStartRoll					= 30;
	gRandomAnimDefs[ COW ][ 0 ].ubEndRoll						= 100;
	gRandomAnimDefs[ COW ][ 0 ].ubFlags							= RANDOM_ANIM_CASUAL;
	gRandomAnimDefs[ COW ][ 0 ].ubAnimHeight				= ANIM_STAND;

	gRandomAnimDefs[ COW ][ 1 ].ubHandRestriction		= RANDOM_ANIM_IRRELEVENTINHAND;
	gRandomAnimDefs[ COW ][ 1 ].sAnimID							= RANDOM_ANIM_SOUND;
	gRandomAnimDefs[ COW ][ 1 ].ubStartRoll					= 0;
	gRandomAnimDefs[ COW ][ 1 ].ubEndRoll						= 1;
	gRandomAnimDefs[ COW ][ 1 ].ubAnimHeight				= ANIM_STAND;
	strcpy( gRandomAnimDefs[ COW ][ 1 ].zSoundFile, "SOUNDS\\COWMOO1.WAV" );

	gRandomAnimDefs[ COW ][ 2 ].ubHandRestriction		= RANDOM_ANIM_IRRELEVENTINHAND;
	gRandomAnimDefs[ COW ][ 2 ].sAnimID							= RANDOM_ANIM_SOUND;
	gRandomAnimDefs[ COW ][ 2 ].ubStartRoll					= 2;
	gRandomAnimDefs[ COW ][ 2 ].ubEndRoll						= 3;
	gRandomAnimDefs[ COW ][ 2 ].ubAnimHeight				= ANIM_STAND;
	strcpy( gRandomAnimDefs[ COW ][ 2 ].zSoundFile, "SOUNDS\\COWMOO2.WAV" );

	gRandomAnimDefs[ COW ][ 3 ].ubHandRestriction		= RANDOM_ANIM_IRRELEVENTINHAND;
	gRandomAnimDefs[ COW ][ 3 ].sAnimID							= RANDOM_ANIM_SOUND;
	gRandomAnimDefs[ COW ][ 3 ].ubStartRoll					= 4;
	gRandomAnimDefs[ COW ][ 3 ].ubEndRoll						= 5;
	gRandomAnimDefs[ COW ][ 3 ].ubAnimHeight				= ANIM_STAND;
	strcpy( gRandomAnimDefs[ COW ][ 3 ].zSoundFile, "SOUNDS\\COWMOO3.WAV" );


	gubAnimSurfaceIndex[ CROW ][ STANDING ]																				= CROWWALKING;
	gubAnimSurfaceIndex[ CROW ][ WALKING ]																				= CROWWALKING;
	gubAnimSurfaceIndex[ CROW ][ CROW_WALK ]																			= CROWWALKING;
	gubAnimSurfaceIndex[ CROW ][ CROW_FLY ]																				= CROWFLYING;
	gubAnimSurfaceIndex[ CROW ][ CROW_EAT ]																				= CROWEATING;
	gubAnimSurfaceIndex[ CROW ][ CROW_TAKEOFF ]																		= CROWFLYING;
	gubAnimSurfaceIndex[ CROW ][ CROW_LAND ]																			= CROWFLYING;
	gubAnimSurfaceIndex[ CROW ][ CROW_DIE ]																				= CROWDYING;

	gRandomAnimDefs[ CROW ][ 0 ].ubHandRestriction		= RANDOM_ANIM_IRRELEVENTINHAND;
	gRandomAnimDefs[ CROW ][ 0 ].sAnimID							= RANDOM_ANIM_SOUND;
	gRandomAnimDefs[ CROW ][ 0 ].ubStartRoll					= 0;
	gRandomAnimDefs[ CROW ][ 0 ].ubEndRoll						= 50;
	gRandomAnimDefs[ CROW ][ 0 ].ubAnimHeight					= ANIM_STAND;
	strcpy( gRandomAnimDefs[ CROW ][ 0 ].zSoundFile,	"SOUNDS\\CROW3.WAV" );

	gRandomAnimDefs[ CROW ][ 1 ].ubHandRestriction		= RANDOM_ANIM_IRRELEVENTINHAND;
	gRandomAnimDefs[ CROW ][ 1 ].sAnimID							= RANDOM_ANIM_SOUND;
	gRandomAnimDefs[ CROW ][ 1 ].ubStartRoll					= 51;
	gRandomAnimDefs[ CROW ][ 1 ].ubEndRoll						= 70;
	gRandomAnimDefs[ CROW ][ 1 ].ubAnimHeight					= ANIM_STAND;
	strcpy( gRandomAnimDefs[ CROW ][ 1 ].zSoundFile,	"SOUNDS\\CROW2.WAV" );

	// BLOOD CAT
	gubAnimSurfaceIndex[ BLOODCAT ][ STANDING ]																		= CATBREATH;
	gubAnimSurfaceIndex[ BLOODCAT ][ WALKING ]																		= CATWALK;
	gubAnimSurfaceIndex[ BLOODCAT ][ BLOODCAT_RUN ]																= CATRUN;
	gubAnimSurfaceIndex[ BLOODCAT ][ BLOODCAT_STARTREADY ]												= CATREADY;
	gubAnimSurfaceIndex[ BLOODCAT ][ BLOODCAT_READY ]															= CATREADY;
	gubAnimSurfaceIndex[ BLOODCAT ][ BLOODCAT_ENDREADY ]													= CATREADY;
	gubAnimSurfaceIndex[ BLOODCAT ][ BLOODCAT_HIT ]																= CATHIT;
	gubAnimSurfaceIndex[ BLOODCAT ][ BLOODCAT_DYING ]															= CATDIE;
	gubAnimSurfaceIndex[ BLOODCAT ][ BLOODCAT_DYING_STOP ]												= CATDIE;
	gubAnimSurfaceIndex[ BLOODCAT ][ BLOODCAT_SWIPE ]															= CATSWIPE;
	gubAnimSurfaceIndex[ BLOODCAT ][ BLOODCAT_BITE_ANIM ]													= CATBITE;
	gubAnimSurfaceIndex[ BLOODCAT ][ BLOODCAT_WALK_BACKWARDS ]										= CATWALK;

	gubAnimSurfaceCorpseID[ BLOODCAT ][ BLOODCAT_DYING ]													= BLOODCAT_DEAD;

	// ROBOT
	gubAnimSurfaceIndex[ ROBOTNOWEAPON ][ STANDING ]															= ROBOTNWBREATH;
	gubAnimSurfaceIndex[ ROBOTNOWEAPON ][ WALKING ]																= ROBOTNWBREATH;
	gubAnimSurfaceIndex[ ROBOTNOWEAPON ][ ROBOTNW_HIT ]														= ROBOTNWHIT;
	gubAnimSurfaceIndex[ ROBOTNOWEAPON ][ ROBOTNW_DIE ]														= ROBOTNWDIE;
	gubAnimSurfaceIndex[ ROBOTNOWEAPON ][ ROBOTNW_DIE_STOP ]											= ROBOTNWDIE;
	gubAnimSurfaceIndex[ ROBOTNOWEAPON ][ ROBOT_WALK ]														= ROBOTNWWALK;
	gubAnimSurfaceIndex[ ROBOTNOWEAPON ][ ROBOT_SHOOT ]														= ROBOTNWSHOOT;
	gubAnimSurfaceIndex[ ROBOTNOWEAPON ][ ROBOT_BURST_SHOOT ]											= ROBOTNWSHOOT;
	gubAnimSurfaceIndex[ ROBOTNOWEAPON ][ ROBOT_CAMERA_NOT_MOVING ]								= ROBOTNWBREATH;
	gubAnimSurfaceCorpseID[ ROBOTNOWEAPON ][ ROBOTNW_DIE ]										= ROBOT_DEAD;



	// HUMVEE
	gubAnimSurfaceIndex[ HUMVEE ][ STANDING ]																		= HUMVEE_BASIC;
	gubAnimSurfaceIndex[ HUMVEE ][ WALKING ]																		= HUMVEE_BASIC;
	gubAnimSurfaceIndex[ HUMVEE ][ VEHICLE_DIE ]																= HUMVEE_DIE;
	gubAnimSurfaceCorpseID[ HUMVEE ][ STANDING ]													= HUMMER_DEAD;

	// TANK
	gubAnimSurfaceIndex[ TANK_NW ][ STANDING ]																	= TANKNW_READY;
	gubAnimSurfaceIndex[ TANK_NW ][ WALKING ]																		= TANKNW_READY;
	gubAnimSurfaceIndex[ TANK_NW ][ TANK_SHOOT ]																= TANKNW_SHOOT;
	gubAnimSurfaceIndex[ TANK_NW ][ TANK_BURST ]																= TANKNW_SHOOT;
	gubAnimSurfaceIndex[ TANK_NW ][ VEHICLE_DIE ]																= TANKNW_DIE;
	gubAnimSurfaceCorpseID[ TANK_NW ][ STANDING ]																= TANK1_DEAD;

	// TANK
	gubAnimSurfaceIndex[ TANK_NE ][ STANDING ]																	= TANKNE_READY;
	gubAnimSurfaceIndex[ TANK_NE ][ WALKING ]																		= TANKNE_READY;
	gubAnimSurfaceIndex[ TANK_NE ][ TANK_SHOOT ]																= TANKNE_SHOOT;
	gubAnimSurfaceIndex[ TANK_NE ][ TANK_BURST ]																= TANKNE_SHOOT;
	gubAnimSurfaceIndex[ TANK_NE ][ VEHICLE_DIE ]																= TANKNE_DIE;
	gubAnimSurfaceCorpseID[ TANK_NE ][ STANDING ]																= TANK2_DEAD;

	// ELDORADO
	gubAnimSurfaceIndex[ ELDORADO ][ STANDING ]																	= ELDORADO_BASIC;
	gubAnimSurfaceIndex[ ELDORADO ][ WALKING ]																	= ELDORADO_BASIC;
	gubAnimSurfaceIndex[ ELDORADO ][ VEHICLE_DIE ]															= ELDORADO_DIE;

	// ICECREAMTRUCK
	gubAnimSurfaceIndex[ ICECREAMTRUCK ][ STANDING ]														= ICECREAMTRUCK_BASIC;
	gubAnimSurfaceIndex[ ICECREAMTRUCK ][ WALKING ]															= ICECREAMTRUCK_BASIC;
	gubAnimSurfaceIndex[ ICECREAMTRUCK ][ VEHICLE_DIE ]													= HUMVEE_DIE;
	gubAnimSurfaceCorpseID[ ICECREAMTRUCK ][ STANDING ]												= ICECREAM_DEAD;

	// JEEP
	gubAnimSurfaceIndex[ JEEP ][ STANDING ]																			= JEEP_BASIC;
	gubAnimSurfaceIndex[ JEEP ][ WALKING ]																			= JEEP_BASIC;
	gubAnimSurfaceIndex[ JEEP ][ VEHICLE_DIE ]																	= JEEP_DIE;
}

BOOLEAN LoadAnimationStateInstructions( )
{
	HWFILE		hFile;
	UINT32		uiBytesRead;

	// Open ani file
	hFile = FileOpen( ANIMFILENAME, FILE_ACCESS_READ, FALSE );

	if ( !hFile )
	{
		return( FALSE );
	}

	//ddd Trick for loading more than 320 animation files (?)
	UINT16 fuckTheBoundz[320][100];

	//Read in block
	//if ( !FileRead( hFile, gusAnimInst, sizeof( gusAnimInst ), &uiBytesRead ) ) //commentet by ddd
	if ( !FileRead( hFile, fuckTheBoundz, sizeof( fuckTheBoundz ), &uiBytesRead ) )
	{
		return( FALSE );
	}

	FileClose( hFile );

	//memcpy(gusAnimInst, fuckTheBoundz, sizeof(gusAnimInst)); 
	for(int i=0;i<320;i++)
		memcpy(gusAnimInst[i],fuckTheBoundz[i],sizeof(fuckTheBoundz[i]));
		//gusAnimInst[i][0] = fuckTheBoundz[i][0];

	// SANDRO - changes to standard animations frame read
	memcpy(gusAnimInst[ FEM_KICKSN ],F_IDLE_ANIM_KICKSN_AnimationScript,sizeof(F_IDLE_ANIM_KICKSN_AnimationScript));	
	memcpy(gusAnimInst[ FEM_LOOK ],F_IDLE_ANIM_LOOK_AnimationScript,sizeof(F_IDLE_ANIM_LOOK_AnimationScript));
	memcpy(gusAnimInst[ NINJA_SPINKICK ],NINJA_SPINKICK_AnimationScript,sizeof(NINJA_SPINKICK_AnimationScript));

	// NEW ANIMATION SCRIPTS 

	//<SB> crouch throwing
	memcpy(gusAnimInst[ THROW_ITEM_CROUCHED ],CrouchedThrowAnimationScript,sizeof(CrouchedThrowAnimationScript));
	//<SB> crouch throwing
	//ddd
	memcpy(gusAnimInst[ BIGGUY_STONE ],StoneAnimationScript,sizeof(StoneAnimationScript));
	memcpy(gusAnimInst[ SHOOT_ROCKET_CROUCHED ],CrouchedShootRocketScript,sizeof(CrouchedShootRocketScript));
	memcpy(gusAnimInst[ SWATTING_WK ],SwatWithKnifeScript,sizeof(SwatWithKnifeScript));
	memcpy(gusAnimInst[ SWAT_BACKWARDS_WK ],SwatBackWithKnifeScript,sizeof(SwatBackWithKnifeScript));
	memcpy(gusAnimInst[ SWAT_BACKWARDS_NOTHING ],SwatBackWithNothingScript,sizeof(SwatBackWithNothingScript));

	memcpy(gusAnimInst[ THROW_GRENADE_STANCE ],ThrowGrenadeStanceAnimationScript,sizeof(ThrowGrenadeStanceAnimationScript));
	memcpy(gusAnimInst[ LOB_GRENADE_STANCE ],LobGrenadeStanceAnimationScript,sizeof(LobGrenadeStanceAnimationScript));

	memcpy(gusAnimInst[ ROLL_PRONE_L ],ROLL_L_AnimationScript,sizeof(ROLL_L_AnimationScript));
	memcpy(gusAnimInst[ ROLL_PRONE_R ],ROLL_R_AnimationScript,sizeof(ROLL_R_AnimationScript));
	
	memcpy(gusAnimInst[JUMPUPWALL],fuckTheBoundz[32],sizeof(fuckTheBoundz[32])); // copy CLIMBROOF to JUMPUPWALL
	
	memcpy(gusAnimInst[JUMPDOWNWALL],fuckTheBoundz[35],sizeof(fuckTheBoundz[35])); // copy CLIMBDOWNROOF to JUMPDOWNWALL
	
	memcpy(gusAnimInst[JUMPWINDOWS],fuckTheBoundz[HOPFENCE],sizeof(fuckTheBoundz[HOPFENCE])); // copy HOPFENCE to JUMPDOWNWALL
	
	//memcpy(gusAnimInst[ JUMPUPWALL ],JUMP_WALL_UP_AnimationScript,sizeof(JUMP_WALL_UP_AnimationScript));
	//memcpy(gusAnimInst[ JUMPDOWNWALL ],JUMP_WALL_DOWN_AnimationScript,sizeof(JUMP_WALL_DOWN_AnimationScript));
	
	memcpy(gusAnimInst[USE_REMOTE],REMOTE_DET_AnimationScript,sizeof(REMOTE_DET_AnimationScript));  // SANDRO - new animation of remote detonator by PasHancock

	memcpy(gusAnimInst[THROW_KNIFE_SP_BM],THROW_KNIFE_SP_BM_AnimationScript,sizeof(THROW_KNIFE_SP_BM_AnimationScript));  // SANDRO - new animation of remote detonator by PasHancock
	
	memcpy(gusAnimInst[RUNNING_W_PISTOL],fuckTheBoundz[RUNNING],sizeof(fuckTheBoundz[RUNNING]));

	memcpy(gusAnimInst[SIDE_STEP_WEAPON_RDY],fuckTheBoundz[SIDE_STEP],sizeof(fuckTheBoundz[SIDE_STEP]));
	memcpy(gusAnimInst[SIDE_STEP_DUAL_RDY],fuckTheBoundz[SIDE_STEP],sizeof(fuckTheBoundz[SIDE_STEP]));
	
	memcpy(gusAnimInst[WALKING_WEAPON_RDY],fuckTheBoundz[WALKING],sizeof(fuckTheBoundz[WALKING]));
	memcpy(gusAnimInst[WALKING_DUAL_RDY],fuckTheBoundz[WALKING],sizeof(fuckTheBoundz[WALKING]));

	memcpy(gusAnimInst[START_AID_PRN],PRONE_START_FIRST_AID_AnimationScript,sizeof(PRONE_START_FIRST_AID_AnimationScript));
	memcpy(gusAnimInst[GIVING_AID_PRN],PRONE_GIVE_FIRST_AID_AnimationScript,sizeof(PRONE_GIVE_FIRST_AID_AnimationScript));
	memcpy(gusAnimInst[END_AID_PRN],fuckTheBoundz[END_AID],sizeof(fuckTheBoundz[END_AID]));

	memcpy(gusAnimInst[ADJACENT_GET_ITEM_CROUCHED],fuckTheBoundz[ADJACENT_GET_ITEM],sizeof(fuckTheBoundz[ADJACENT_GET_ITEM]));
	memcpy(gusAnimInst[STEAL_ITEM_CROUCHED],fuckTheBoundz[STEAL_ITEM],sizeof(fuckTheBoundz[STEAL_ITEM]));

	memcpy(gusAnimInst[BURST_DUAL_STAND],DUAL_BURST_ST_CR_AnimationScript,sizeof(DUAL_BURST_ST_CR_AnimationScript));
	memcpy(gusAnimInst[BURST_DUAL_CROUCH],DUAL_BURST_ST_CR_AnimationScript,sizeof(DUAL_BURST_ST_CR_AnimationScript));		
	memcpy(gusAnimInst[BURST_DUAL_PRONE],DUAL_BURST_PRONE_AnimationScript,sizeof(DUAL_BURST_PRONE_AnimationScript));

	memcpy(gusAnimInst[READY_ALTERNATIVE_STAND],fuckTheBoundz[READY_RIFLE_STAND],sizeof(fuckTheBoundz[READY_RIFLE_STAND]));
	memcpy(gusAnimInst[AIM_ALTERNATIVE_STAND],fuckTheBoundz[AIM_RIFLE_STAND],sizeof(fuckTheBoundz[AIM_RIFLE_STAND]));
	memcpy(gusAnimInst[SHOOT_ALTERNATIVE_STAND],fuckTheBoundz[SHOOT_RIFLE_STAND],sizeof(fuckTheBoundz[SHOOT_RIFLE_STAND]));
	memcpy(gusAnimInst[BURST_ALTERNATIVE_STAND],fuckTheBoundz[STANDING_BURST],sizeof(fuckTheBoundz[STANDING_BURST]));
	memcpy(gusAnimInst[LOW_SHOT_ALTERNATIVE_STAND],fuckTheBoundz[FIRE_LOW_STAND],sizeof(fuckTheBoundz[FIRE_LOW_STAND]));
	memcpy(gusAnimInst[LOW_BURST_ALTERNATIVE_STAND],fuckTheBoundz[FIRE_BURST_LOW_STAND],sizeof(fuckTheBoundz[FIRE_BURST_LOW_STAND]));
	memcpy(gusAnimInst[UNREADY_ALTERNATIVE_STAND],fuckTheBoundz[END_RIFLE_STAND],sizeof(fuckTheBoundz[END_RIFLE_STAND]));
	memcpy(gusAnimInst[UNJAM_ALTERNATIVE_STAND],fuckTheBoundz[STANDING_SHOOT_UNJAM],sizeof(fuckTheBoundz[STANDING_SHOOT_UNJAM]));
	memcpy(gusAnimInst[LOW_UNJAM_ALTERNATIVE_STAND],fuckTheBoundz[STANDING_SHOOT_LOW_UNJAM],sizeof(fuckTheBoundz[STANDING_SHOOT_LOW_UNJAM]));
	memcpy(gusAnimInst[WALKING_ALTERNATIVE_RDY],fuckTheBoundz[WALKING],sizeof(fuckTheBoundz[WALKING]));
	memcpy(gusAnimInst[SIDE_STEP_ALTERNATIVE_RDY],fuckTheBoundz[SIDE_STEP],sizeof(fuckTheBoundz[SIDE_STEP]));

	memcpy(gusAnimInst[START_COWER_CROUCHED],START_COWER_CROUCHED_AnimationScript,sizeof(START_COWER_CROUCHED_AnimationScript));
	memcpy(gusAnimInst[END_COWER_CROUCHED],END_COWER_CROUCHED_AnimationScript,sizeof(END_COWER_CROUCHED_AnimationScript));
	memcpy(gusAnimInst[START_COWER_PRONE],START_COWER_PRONE_AnimationScript,sizeof(START_COWER_PRONE_AnimationScript));
	memcpy(gusAnimInst[COWERING_PRONE],COWER_PRONE_AnimationScript,sizeof(COWER_PRONE_AnimationScript));
	memcpy(gusAnimInst[END_COWER_PRONE],END_COWER_PRONE_AnimationScript,sizeof(END_COWER_PRONE_AnimationScript));
	
	memcpy(gusAnimInst[BIGMERC_IDLE_NECK2],fuckTheBoundz[BIGMERC_IDLE_NECK],sizeof(fuckTheBoundz[BIGMERC_IDLE_NECK]));
	
	memcpy(gusAnimInst[FOCUSED_PUNCH],FOCUSED_PUNCH_AnimationScript,sizeof(FOCUSED_PUNCH_AnimationScript));
	memcpy(gusAnimInst[FOCUSED_STAB],FOCUSED_STAB_AnimationScript,sizeof(FOCUSED_STAB_AnimationScript));
	memcpy(gusAnimInst[HTH_KICK],HTH_KICK_AnimationScript,sizeof(HTH_KICK_AnimationScript));
	memcpy(gusAnimInst[FOCUSED_HTH_KICK],FOCUSED_HTH_KICK_AnimationScript,sizeof(FOCUSED_HTH_KICK_AnimationScript));

	memcpy(gusAnimInst[LONG_JUMP],LONG_JUMP_AnimationScript,sizeof(LONG_JUMP_AnimationScript));

	// NOTE: Careful here... keep in mind you have to increase MAX_ANIMATIONS whenever you would go over 399(currently) animation numbers 

	return( TRUE );
}

BOOLEAN IsAnimationValidForBodyType( SOLDIERTYPE *pSoldier, UINT16 usNewState )
{
	UINT16		usAnimSurface;

	// From animation control, get surface

	// First Save value
	usAnimSurface = DetermineSoldierAnimationSurface( pSoldier, usNewState );

	if ( usAnimSurface == INVALID_ANIMATION_SURFACE )
	{
		return( FALSE );
	}

	return( TRUE );
}

BOOLEAN SubstituteBodyTypeAnimation( SOLDIERTYPE *pSoldier, UINT16 usTestState, UINT16 *pusSubState )
{
	BOOLEAN fSubFound = FALSE;

	*pusSubState = usTestState;


	if ( pSoldier->ubBodyType == QUEENMONSTER )
	{
		switch( usTestState )
		{
		case STANDING:
		case WALKING:
		case RUNNING:

			*pusSubState = QUEEN_MONSTER_BREATHING;
			fSubFound = TRUE;
			break;
		}
	}

	if ( pSoldier->ubBodyType == LARVAE_MONSTER )
	{
		switch( usTestState )
		{
		case STANDING:

			*pusSubState = LARVAE_BREATH;
			fSubFound = TRUE;
			break;

		case WALKING:
		case RUNNING:

			*pusSubState = LARVAE_WALK;
			fSubFound = TRUE;
			break;

		}
	}

	if ( pSoldier->ubBodyType == CROW )
	{
		switch( usTestState )
		{
		case WALKING:

			*pusSubState = CROW_WALK;
			fSubFound = TRUE;
			break;

		case STANDING:

			*pusSubState = CROW_EAT;
			fSubFound = TRUE;
			break;

		}
	}

	if ( pSoldier->ubBodyType == BLOODCAT )
	{
		switch( usTestState )
		{
		case RUNNING:
			*pusSubState = BLOODCAT_RUN;
			fSubFound = TRUE;
			break;

		}

	}


	if ( pSoldier->ubBodyType == ADULTFEMALEMONSTER || pSoldier->ubBodyType == AM_MONSTER ||
		pSoldier->ubBodyType == YAF_MONSTER || pSoldier->ubBodyType == YAM_MONSTER )
	{
		switch( usTestState )
		{
		case WALKING:
			*pusSubState = ADULTMONSTER_WALKING;
			fSubFound = TRUE;
			break;

		case RUNNING:
			*pusSubState = ADULTMONSTER_WALKING;
			fSubFound = TRUE;
			break;

		}
	}

	if ( pSoldier->ubBodyType == ROBOTNOWEAPON )
	{
		switch( usTestState )
		{
		case STANDING:

			// OK, if they are on the CIV_TEAM, sub for no camera moving
			if ( pSoldier->bTeam == CIV_TEAM )
			{
				*pusSubState = ROBOT_CAMERA_NOT_MOVING;
				fSubFound = TRUE;
			}
			break;

		case WALKING:
			*pusSubState = ROBOT_WALK;
			fSubFound = TRUE;
			break;

		case RUNNING:
			*pusSubState = ROBOT_WALK;
			fSubFound = TRUE;
			break;

		}
	}

	if ( IS_CIV_BODY_TYPE( pSoldier ) )
	{
		switch( usTestState )
		{
		case KNEEL_UP:
			*pusSubState = END_COWER;
			fSubFound = TRUE;
			break;
		case KNEEL_DOWN:
			*pusSubState = START_COWER;
			fSubFound = TRUE;
			break;

		case WKAEUP_FROM_SLEEP:
		case GOTO_SLEEP:
		case SLEEPING:
			*pusSubState = STANDING;
			fSubFound = TRUE;
			break;
		}
	}

	return( fSubFound );
}


INT8	GetBodyTypePaletteSubstitutionCode( SOLDIERTYPE *pSoldier, UINT8 ubBodyType, CHAR8 *zColFilename )
{
	switch( ubBodyType )
	{
	case REGMALE:
	case BIGMALE:
	case STOCKYMALE:
	case REGFEMALE:

		if ( pSoldier != NULL )
		{
			// Are we on fire?
			if ( pSoldier->usAnimState == CHARIOTS_OF_FIRE || pSoldier->usAnimState == BODYEXPLODING )
			{
				return( 0 );
			}


			// Check for camo...

			//stealth has priority
			if ( GetWornStealth(pSoldier) >= 50 )
			{
				strcpy( zColFilename, "ANIMS\\stealth.col" );
				return( 1 );
			}

			int urban = pSoldier->urbanCamo + pSoldier->wornUrbanCamo;
			int jungle = pSoldier->bCamo + pSoldier->wornCamo;
			int desert = pSoldier->desertCamo + pSoldier->wornDesertCamo;
			int snow = pSoldier->snowCamo + pSoldier->wornSnowCamo;
			int total = urban + jungle + desert + snow;

			// display camo depending on which is higher
			if ( total >= 50 )
			{
				if ( jungle >= urban && jungle >= desert && jungle >= snow )
					strcpy( zColFilename, "ANIMS\\camo.COL" );
				else if ( urban >= jungle && urban >= desert && urban >= snow )
					strcpy( zColFilename, "ANIMS\\urban.col" );
				else if ( desert >= urban && desert >= jungle && desert >= snow )
					strcpy( zColFilename, "ANIMS\\desert.col" );
				else if ( snow >= urban && snow >= desert && snow >= jungle )
					strcpy( zColFilename, "ANIMS\\snow.col" );

				return( 1 );
			}
		}
		return( -1 );


	case YAF_MONSTER:

		strcpy( zColFilename, "ANIMS\\MONSTERS\\fm_brite.COL" );
		return( 1 );

	case YAM_MONSTER:

		strcpy( zColFilename, "ANIMS\\MONSTERS\\mn_brite.COL" );
		return( 1 );

	case ADULTFEMALEMONSTER:

		strcpy( zColFilename, "ANIMS\\MONSTERS\\femmon.COL" );
		return( 1 );

	case AM_MONSTER:

		strcpy( zColFilename, "ANIMS\\MONSTERS\\monster.COL" );
		return( 1 );

	case QUEENMONSTER:
	case COW:
	case CROW:
	case BLOODCAT:
	case HUMVEE:
	case ELDORADO:
	case ICECREAMTRUCK:
	case JEEP:
	case ROBOTNOWEAPON:
	case TANK_NW:
	case TANK_NE:

		return( 0 );
	}

	return( -1 );
}



BOOLEAN SetSoldierAnimationSurface( SOLDIERTYPE *pSoldier, UINT16 usAnimState )
{
	UINT16 usAnimSurface;

	// Delete any structure info!
	if ( pSoldier->pLevelNode != NULL )
	{
		DeleteStructureFromWorld( pSoldier->pLevelNode->pStructureData );
		pSoldier->pLevelNode->pStructureData = NULL;
	}


	usAnimSurface = LoadSoldierAnimationSurface( pSoldier, usAnimState );

	// Add structure info!
	if ( pSoldier->pLevelNode != NULL && !( pSoldier->flags.uiStatusFlags & SOLDIER_PAUSEANIMOVE ) )
	{
		AddMercStructureInfoFromAnimSurface( pSoldier->sGridNo, pSoldier, usAnimSurface, usAnimState );
	}

	// Set
	pSoldier->usAnimSurface = usAnimSurface;

	if ( usAnimSurface == INVALID_ANIMATION_SURFACE )
	{
		return( FALSE );
	}

	return( TRUE );
}


UINT16 LoadSoldierAnimationSurface( SOLDIERTYPE *pSoldier, UINT16 usAnimState )
{
	UINT16 usAnimSurface;

	usAnimSurface = DetermineSoldierAnimationSurface( pSoldier, usAnimState );

	if ( usAnimSurface != INVALID_ANIMATION_SURFACE )
	{
		// Ensure that it's been loaded!
		if ( GetCachedAnimationSurface( pSoldier->ubID, &(pSoldier->AnimCache), usAnimSurface, pSoldier->usAnimState ) == FALSE )
		{
			usAnimSurface = INVALID_ANIMATION_SURFACE;
		}

	}

	return( usAnimSurface );
}


UINT16	gusQueenMonsterSpitAnimPerDir[] =
{
	QUEENMONSTERSPIT_NE,			//NORTH
	QUEENMONSTERSPIT_E,
	QUEENMONSTERSPIT_SE,			// EAST
	QUEENMONSTERSPIT_S,
	QUEENMONSTERSPIT_SW,			// SOUTH
	QUEENMONSTERSPIT_SW,
	QUEENMONSTERSPIT_SW,			// WEST
	QUEENMONSTERSPIT_NE,
};


UINT16	DetermineSoldierAnimationSurface( SOLDIERTYPE *pSoldier, UINT16 usAnimState )
{
	UINT16 usAnimSurface;
	UINT16 usAltAnimSurface;
	UINT8 ubBodyType;
	UINT16	usItem;
	UINT8		ubWaterHandIndex = 1;
	INT32		cnt;
	BOOLEAN	fAdjustedForItem	= FALSE;
	UINT16		usNewAnimState;

	//DebugMsg(TOPIC_JA2,DBG_LEVEL_3,String("DetermineSoldierAnimationSurface"));

	ubBodyType = pSoldier->ubBodyType;

	if ( SubstituteBodyTypeAnimation( pSoldier, usAnimState, &usNewAnimState ) )
	{
		usAnimState = usNewAnimState;
	}

	usAnimSurface	=	gubAnimSurfaceIndex[pSoldier->ubBodyType][usAnimState];

	// CHECK IF WE CAN DO THIS ANIMATION, IE WE HAVE IT AVAILIBLE
	if ( usAnimSurface == INVALID_ANIMATION	)
	{
		// WE SHOULD NOT BE USING THIS ANIMATION
		ScreenMsg( FONT_MCOLOR_RED, MSG_BETAVERSION, L"Invalid Animation File for Body %d, animation %S.", pSoldier->ubBodyType, gAnimControl[ usAnimState ].zAnimStr );
		// Set index to FOUND_INVALID_ANIMATION
		gubAnimSurfaceIndex[pSoldier->ubBodyType][usAnimState] = FOUND_INVALID_ANIMATION;
		return( INVALID_ANIMATION_SURFACE );
	}
	if ( usAnimSurface == FOUND_INVALID_ANIMATION	)
	{
		return( INVALID_ANIMATION_SURFACE );
	}


	// OK - DO SOME MAGIC HERE TO SWITCH BODY TYPES IF WE WANT!


	// If we are a queen, pick the 'real' anim surface....
	if ( usAnimSurface == QUEENMONSTERSPIT_SW )
	{
		INT8	bDir;

		// Assume a target gridno is here.... get direction...
		// ATE: use +2 in gridno because here head is far from body
		bDir = (INT8)GetDirectionToGridNoFromGridNo( (INT16)( pSoldier->sGridNo + 2 ), pSoldier->sTargetGridNo );

		return( gusQueenMonsterSpitAnimPerDir[ bDir ] );
	}


	// IF we are not a merc, return
	if ( pSoldier->ubBodyType > REGFEMALE )
	{
		return( usAnimSurface );
	}

	// SWITCH TO DIFFERENT AIM ANIMATION FOR BIG GUY!
	if ( pSoldier->uiAnimSubFlags & SUB_ANIM_BIGGUYSHOOT2 ) // badass rifle holding animation
	{
		switch ( usAnimSurface )
		{
		case BGMSTANDAIM2:
			usAnimSurface = BGMSTANDAIM;
			break;
		case BGMSIDESTEP_R_RDY:
			usAnimSurface = BGMSIDESTEP_R_RDY2;
			break;
		case BGMWALK_R_RDY:
			usAnimSurface = BGMWALK_R_RDY2;
			break;
		default:
			break;
		}
	}

	// SWITCH TO DIFFERENT STAND ANIMATION FOR BIG GUY!
	switch (usAnimSurface)
	{
		case BGMSTANDING:
			if ( !DecideAltAnimForBigMerc( pSoldier ) )
			{
				usAnimSurface = BGMTHREATENSTAND;
			}
			break;
		case BGMWALKING:
			if ( !DecideAltAnimForBigMerc( pSoldier ) )
			{
				usAnimSurface = BGMWALK2;
			}
			break;
		case BGMRUNNING:
			if ( !DecideAltAnimForBigMerc( pSoldier ) )
			{
				usAnimSurface = BGMRUN2;
			}
			break;
		case BGMRAISE:
			if ( !DecideAltAnimForBigMerc( pSoldier ) )
			{
				usAnimSurface = BGMRAISE2;
			}
			break;
		case BGM_HIP_AIM:
			if ( DecideAltAnimForBigMerc( pSoldier ) )
			{
				usAnimSurface = BGMHIPAIMALT;
			}
			break;
		case BGMSTANDAIM2:
			if ( DecideAltAnimForBigMerc( pSoldier ) && !( pSoldier->uiAnimSubFlags & SUB_ANIM_BIGGUYSHOOT2 ))
			{
				usAnimSurface = BGMSRAIMALT;
			}
			break;
		default:
			break;
	}

	// ADJUST ANIMATION SURFACE BASED ON TERRAIN

	// CHECK FOR WATER
	if ( pSoldier->MercInWater( ) )
	{
		// Default it to the 1 ( ie: no rifle )
		if ( pSoldier->inv[ HANDPOS ].exists() == true )
		{
			// ADJUST BASED ON ITEM IN HAND....
			usItem = pSoldier->inv[ HANDPOS ].usItem;

			if ( ( Item[ usItem ].usItemClass == IC_GUN || Item[ usItem ].usItemClass == IC_LAUNCHER ) && !Item[usItem].rocketlauncher)
			{
				//				if ( (Item[ usItem ].fFlags & ITEM_TWO_HANDED) )
				if ( (Item[ usItem ].twohanded ) )
				{
					ubWaterHandIndex = 0;
				}
			}
		}

		// CHANGE BASED ON HIEGHT OF WATER
		usAltAnimSurface = gubAnimSurfaceMidWaterSubIndex[pSoldier->ubBodyType][usAnimState][ ubWaterHandIndex ];

		if ( usAltAnimSurface != INVALID_ANIMATION )
		{
			usAnimSurface = usAltAnimSurface;
		}

	}
	else
	{
		// ADJUST BASED ON ITEM IN HAND....
		usItem = pSoldier->inv[ HANDPOS ].usItem;

		if ( !(Item[ usItem ].usItemClass == IC_GUN ) && !(Item[ usItem ].usItemClass == IC_LAUNCHER ) || Item[usItem].rocketlauncher )
		{
			if ( usAnimState == STANDING )
			{
				usAnimSurface			= gusNothingBreath[ pSoldier->ubBodyType ];
				fAdjustedForItem	= TRUE;
			}
			else
			{
				usAltAnimSurface = gubAnimSurfaceItemSubIndex[pSoldier->ubBodyType][usAnimState];

				if ( usAltAnimSurface != INVALID_ANIMATION )
				{
					usAnimSurface			= usAltAnimSurface;
					fAdjustedForItem	= TRUE;
				}
			}
		}
		else
		{
			// CHECK FOR HANDGUN
			if ( ( Item[ usItem ].usItemClass == IC_GUN || Item[ usItem ].usItemClass == IC_LAUNCHER ) && !Item[usItem].rocketlauncher )
			{
				//				if ( !(Item[ usItem ].fFlags & ITEM_TWO_HANDED) )
				if ( !(Item[ usItem ].twohanded ) )
				{
					// SANDRO - new anim for running with pistol by PasHancock
					if ( usAnimState == RUNNING )
					{
						usAltAnimSurface = gubAnimSurfaceItemSubIndex[ pSoldier->ubBodyType ][RUNNING_W_PISTOL];
					}
					else
					{
						usAltAnimSurface = gubAnimSurfaceItemSubIndex[pSoldier->ubBodyType][usAnimState];
					}

					if ( usAltAnimSurface != INVALID_ANIMATION )
					{
						//ddd Put alternative pistol-shot animations here
						/*if ( usAnimSurface == BGMSTANDAIM2 )
						{
						
						usAnimSurface = BGMFLEX;
						ScreenMsg( FONT_MCOLOR_LTYELLOW, MSG_INTERFACE, L"usanimcashe");

						}
						else //}ddd*/
						usAnimSurface = usAltAnimSurface;
						fAdjustedForItem	= TRUE;
					}

					// Look for good two pistols sub anim.....
					if ( gDoubleHandledSub.usAnimState == usAnimState )
					{
						// Do we carry two pistols...
						//if ( Item[ pSoldier->inv[ SECONDHANDPOS ].usItem ].usItemClass == IC_GUN )
						if ( pSoldier->IsValidSecondHandShot() )
						{
							usAltAnimSurface = gDoubleHandledSub.usAnimationSurfaces[ pSoldier->ubBodyType ];
							if ( usAltAnimSurface != INVALID_ANIMATION )
							{
								usAnimSurface = usAltAnimSurface;
								fAdjustedForItem	= TRUE;
							}
						}
					}

				}
			}
			else
			{
				usAltAnimSurface = gubAnimSurfaceItemSubIndex[pSoldier->ubBodyType][usAnimState];

				if ( usAltAnimSurface != INVALID_ANIMATION )
				{
					usAnimSurface = usAltAnimSurface;
					fAdjustedForItem	= TRUE;
				}
			}
		}

		// Based on if we have adjusted for item or not... check for injured status...
		if ( fAdjustedForItem )
		{
			// If life below thresthold for being injured
			if ( pSoldier->stats.bLife < INJURED_CHANGE_THREASHOLD )
			{
				// ADJUST FOR INJURED....
				for ( cnt = 0; cnt < NUM_INJURED_SUBS; cnt++ )
				{
					if ( gNothingInjuredSub[ cnt ].usAnimState == usAnimState )
					{
						usAnimSurface = gNothingInjuredSub[ cnt ].usAnimationSurfaces[ pSoldier->ubBodyType ];
					}
				}
			}
		}
		else
		{
			// If life below thresthold for being injured
			if ( pSoldier->stats.bLife < INJURED_CHANGE_THREASHOLD )
			{
				// ADJUST FOR INJURED....
				for ( cnt = 0; cnt < NUM_INJURED_SUBS; cnt++ )
				{
					if ( gRifleInjuredSub[ cnt ].usAnimState == usAnimState )
					{
						usAnimSurface = gRifleInjuredSub[ cnt ].usAnimationSurfaces[ pSoldier->ubBodyType ];
					}
				}
			}
		}



	}
	//DebugMsg(TOPIC_JA2,DBG_LEVEL_3,String("DetermineSoldierAnimationSurface done"));
	return( usAnimSurface );
}


UINT16 GetSoldierAnimationSurface( SOLDIERTYPE *pSoldier, UINT16 usAnimState )
{
	UINT16 usAnimSurface;

	usAnimSurface = pSoldier->usAnimSurface;

	if ( usAnimSurface != INVALID_ANIMATION_SURFACE )
	{
		// Ensure that it's loaded!
		if ( gAnimSurfaceDatabase[ usAnimSurface ].hVideoObject == NULL )
		{
			if(!is_networked)ScreenMsg( FONT_MCOLOR_RED, MSG_BETAVERSION, L"IAnimation Surface for Body %d, animation %S, surface %d not loaded.", pSoldier->ubBodyType, gAnimControl[ usAnimState ].zAnimStr, usAnimSurface );
			AnimDebugMsg( String( "Surface Database: PROBLEMS!!!!!!" ) );
			usAnimSurface = INVALID_ANIMATION_SURFACE;
		}
	}

	return( usAnimSurface );
}
